/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.logging.LogUtils;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.utils.Constants;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7157;
import org.slf4j.Logger;

public class DisableAll {
    protected static final Logger LOGGER = LogUtils.getLogger();
    private static final long CONFIRM_TIMEOUT = 30000L;
    private static long confirmAllowedUntil;

    @Init
    public static void init() {
        ClientCommandRegistrationCallback.EVENT.register(DisableAll::registerCommand);
    }

    private static void registerCommand(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblocker").then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"disableAll").executes(DisableAll::confirmMessage)).then(ClientCommandManager.literal((String)"confirm").executes(DisableAll::disableAll))));
    }

    private static int confirmMessage(CommandContext<FabricClientCommandSource> context) {
        confirmAllowedUntil = System.currentTimeMillis() + 30000L;
        class_5250 confirm = class_2561.method_43471((String)"skyblocker.disableAll.confirmYes").method_27692(class_124.field_1061).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609("/skyblocker disableAll confirm")));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43469((String)"skyblocker.disableAll.confirm", (Object[])new Object[]{confirm})));
        return 1;
    }

    private static int disableAll(CommandContext<FabricClientCommandSource> context) {
        if (System.currentTimeMillis() > confirmAllowedUntil) {
            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.disableAll.notPending").method_27692(class_124.field_1061)));
            return 1;
        }
        confirmAllowedUntil = 0L;
        try {
            SkyblockerConfigManager.update(config -> {
                try {
                    DisableAll.disableBooleans(config);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.disableAll.success").method_27692(class_124.field_1061)));
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker DisableAll] Failed to disable all features", (Throwable)e);
            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.disableAll.failed").method_27692(class_124.field_1061)));
        }
        return 1;
    }

    protected static void disableBooleans(Object target) throws IllegalAccessException {
        for (Field field : target.getClass().getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            Object value = field.get(target);
            Class<?> type = field.getType();
            if (type == Boolean.TYPE) {
                field.setBoolean(target, false);
                continue;
            }
            if (type == Boolean.class) {
                field.set(target, false);
                continue;
            }
            if (value instanceof Map) {
                Map m = (Map)value;
                for (Map.Entry entry : m.entrySet()) {
                    if (!(entry.getValue() instanceof Boolean)) continue;
                    m.put(entry.getKey(), Boolean.FALSE);
                }
                continue;
            }
            if (value == null || !DisableAll.isConfigClass(type)) continue;
            DisableAll.disableBooleans(value);
        }
    }

    private static boolean isConfigClass(Class<?> clazz) {
        return !clazz.isPrimitive() && !clazz.isEnum() && !clazz.isRecord() && !clazz.equals(String.class) && !Number.class.isAssignableFrom(clazz) && clazz.getPackageName().startsWith("de.hysky.skyblocker.config.configs");
    }
}

