/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker;

import com.google.gson.JsonParser;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.utils.CodecUtils;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.loader.api.metadata.Person;
import net.minecraft.class_10799;
import net.minecraft.class_11724;
import net.minecraft.class_11885;
import net.minecraft.class_11908;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_437;
import net.minecraft.class_4844;
import net.minecraft.class_5195;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5481;
import net.minecraft.class_5699;
import net.minecraft.class_6880;
import net.minecraft.class_9296;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class SkyblockerCreditsScreen
extends class_437 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_2561 TITLE = class_2561.method_43470((String)"Skyblocker Credits");
    private static final class_2960 CREDITS_FILE = SkyblockerMod.id("credits.json");
    private static final class_2960 LOGO = SkyblockerMod.id("logo.png");
    private static final class_2960 VIGNETTE = class_2960.method_60656((String)"textures/misc/credits_vignette.png");
    private static final class_5195 SKYBLOCKER_CREDITS_MUSIC = new class_5195((class_6880)class_3417.field_51524, 0, 0, true);
    private static final class_2561 SECTION_HEADING = class_2561.method_43470((String)"================").method_27692(class_124.field_1068);
    private static final float SPEEDUP_FACTOR = 5.0f;
    private static final float SPEEDUP_FACTOR_FAST = 15.0f;
    private static final float UNMODIFIED_SCROLL_SPEED = 0.75f;
    private float scroll;
    private final List<class_5481> lines = new ArrayList<class_5481>();
    private final List<class_2561> narratorComponents = new ArrayList<class_2561>();
    private final IntSet centredLines = new IntOpenHashSet();
    private int totalScrollLength;
    private boolean speedupActive;
    private final IntSet speedupModifiers = new IntOpenHashSet();
    private float scrollSpeed = 0.75f;
    private int direction = 1;
    private @Nullable class_437 parent;

    protected SkyblockerCreditsScreen(@Nullable class_437 parent) {
        super(TITLE);
        this.parent = parent;
    }

    @Init
    public static void initClass() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblocker").then(ClientCommandManager.literal((String)"credits").executes(Scheduler.queueOpenScreenCommand(() -> new SkyblockerCreditsScreen(null))))));
    }

    private float calculateScrollSpeed() {
        return this.speedupActive ? 0.75f * (5.0f + (float)this.speedupModifiers.size() * 15.0f) * (float)this.direction : 0.75f * (float)this.direction;
    }

    public void method_25393() {
        this.field_22787.method_1538().method_18669();
        this.field_22787.method_1483().method_18670(false);
        float maxScroll = this.totalScrollLength + this.field_22790 + this.field_22790 + 24;
        if (this.scroll > maxScroll) {
            this.method_25419();
        }
    }

    public boolean method_25404(class_11908 keyEvent) {
        if (keyEvent.method_74234()) {
            this.direction = -1;
        } else if (keyEvent.comp_4795() == 341 || keyEvent.comp_4795() == 345) {
            this.speedupModifiers.add(keyEvent.comp_4795());
        } else if (keyEvent.comp_4795() == 32) {
            this.speedupActive = true;
        }
        this.scrollSpeed = this.calculateScrollSpeed();
        return super.method_25404(keyEvent);
    }

    public boolean method_16803(class_11908 keyEvent) {
        if (keyEvent.method_74234()) {
            this.direction = 1;
        }
        if (keyEvent.comp_4795() == 32) {
            this.speedupActive = false;
        } else if (keyEvent.comp_4795() == 341 || keyEvent.comp_4795() == 345) {
            this.speedupModifiers.remove(keyEvent.comp_4795());
        }
        this.scrollSpeed = this.calculateScrollSpeed();
        return super.method_16803(keyEvent);
    }

    public void method_25426() {
        if (this.lines.isEmpty()) {
            Credits credits = this.readCreditsFile();
            List<String> contributors = SkyblockerMod.SKYBLOCKER_MOD.getMetadata().getContributors().stream().map(Person::getName).toList();
            this.addCreditsLine(SECTION_HEADING, true, false);
            this.addCreditsLine((class_2561)class_2561.method_43470((String)"Authors").method_27692(class_124.field_1054), true, true);
            this.addCreditsLine(SECTION_HEADING, true, false);
            this.addEmptyLine();
            this.addEmptyLine();
            for (Author author : credits.authors()) {
                this.addCreditsLine(author.asText(), false, true);
                this.addEmptyLine();
            }
            this.addEmptyLine();
            this.addEmptyLine();
            this.addCreditsLine(SECTION_HEADING, true, false);
            this.addCreditsLine((class_2561)class_2561.method_43470((String)"Creative Team").method_27692(class_124.field_1054), true, true);
            this.addCreditsLine(SECTION_HEADING, true, false);
            this.addEmptyLine();
            this.addEmptyLine();
            for (String member : credits.creativeTeam()) {
                this.addCreditsLine((class_2561)class_2561.method_43470((String)member).method_27692(class_124.field_1068), false, true);
                this.addEmptyLine();
            }
            this.addEmptyLine();
            this.addEmptyLine();
            this.addCreditsLine(SECTION_HEADING, true, false);
            this.addCreditsLine((class_2561)class_2561.method_43470((String)"Code Contributors").method_27692(class_124.field_1054), true, true);
            this.addCreditsLine(SECTION_HEADING, true, false);
            this.addEmptyLine();
            this.addEmptyLine();
            for (String contributor : contributors) {
                this.addCreditsLine((class_2561)class_2561.method_43470((String)contributor).method_27692(class_124.field_1068), false, true);
            }
            this.addCreditsLine((class_2561)class_2561.method_43470((String)"and any other code contributors not listed").method_27692(class_124.field_1068), false, true);
            this.addEmptyLine();
            this.addEmptyLine();
            this.addEmptyLine();
            this.addCreditsLine(SECTION_HEADING, true, false);
            this.addCreditsLine((class_2561)class_2561.method_43470((String)"Translations").method_27692(class_124.field_1054), true, true);
            this.addCreditsLine(SECTION_HEADING, true, false);
            this.addEmptyLine();
            this.addEmptyLine();
            for (Translation translation : credits.translations()) {
                this.addCreditsLine((class_2561)class_2561.method_43470((String)translation.name()).method_27692(class_124.field_1080), false, true);
                for (String translator : translation.translators()) {
                    class_5250 text = class_2561.method_43473().method_27693("           ").method_10852((class_2561)class_2561.method_43470((String)translator).method_27692(class_124.field_1068));
                    this.addCreditsLine((class_2561)text, false, true);
                }
                this.addEmptyLine();
            }
            this.addEmptyLine();
            this.addEmptyLine();
            this.addCreditsLine(SECTION_HEADING, true, false);
            this.addCreditsLine((class_2561)class_2561.method_43470((String)"Libraries").method_27692(class_124.field_1054), true, true);
            this.addCreditsLine(SECTION_HEADING, true, false);
            this.addEmptyLine();
            this.addEmptyLine();
            for (Library library : credits.libraries()) {
                class_5250 libraryCreditText = class_2561.method_43473().method_27693("           ").method_10852((class_2561)class_2561.method_43470((String)library.credit()).method_27692(class_124.field_1068));
                this.addCreditsLine((class_2561)class_2561.method_43470((String)library.name()).method_27692(class_124.field_1080), false, true);
                this.addCreditsLine((class_2561)libraryCreditText, false, true);
                this.addEmptyLine();
            }
            this.addEmptyLine();
            this.addEmptyLine();
            this.addCreditsLine((class_2561)class_2561.method_43470((String)"Special thanks to all of our users!").method_27692(class_124.field_1054), true, true);
            this.totalScrollLength = this.lines.size() * 12;
        }
    }

    public class_2561 method_25435() {
        return class_5244.method_37111((class_2561[])((class_2561[])this.narratorComponents.toArray(class_2561[]::new)));
    }

    private Credits readCreditsFile() {
        Credits credits;
        block8: {
            BufferedReader reader = this.field_22787.method_1478().openAsReader(CREDITS_FILE);
            try {
                credits = (Credits)Credits.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader(reader)).getOrThrow();
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.error("[Skyblocker Credits] Failed to load credits file.", (Throwable)e);
                    return Credits.EMPTY;
                }
            }
            reader.close();
        }
        return credits;
    }

    private void addEmptyLine() {
        this.lines.add(class_5481.field_26385);
        this.narratorComponents.add(class_5244.field_39003);
    }

    private void addCreditsLine(class_2561 text, boolean centred, boolean narratable) {
        if (centred) {
            this.centredLines.add(this.lines.size());
        }
        this.lines.add(text.method_30937());
        if (narratable) {
            this.narratorComponents.add(text);
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float a) {
        super.method_25394(graphics, mouseX, mouseY, a);
        this.renderVignette(graphics);
        this.scroll = Math.max(0.0f, this.scroll + a * this.scrollSpeed);
        int logoX = this.field_22789 / 2 - 128;
        int logoY = this.field_22790 + 50;
        float yOffs = -this.scroll;
        graphics.method_51448().pushMatrix();
        graphics.method_51448().translate(0.0f, yOffs);
        graphics.method_71048();
        this.renderLogo(graphics, this.field_22789, logoY);
        int yPos = logoY + 100;
        for (int i = 0; i < this.lines.size(); ++i) {
            float diff;
            if (i == this.lines.size() - 1 && (diff = (float)yPos + yOffs - (float)(this.field_22790 / 2 - 6)) < 0.0f) {
                graphics.method_51448().translate(0.0f, -diff);
            }
            if ((float)yPos + yOffs + 12.0f + 8.0f > 0.0f && (float)yPos + yOffs < (float)this.field_22790) {
                class_5481 line = this.lines.get(i);
                if (this.centredLines.contains(i)) {
                    graphics.method_35719(this.field_22793, line, logoX + 128, yPos, -1);
                } else {
                    graphics.method_35720(this.field_22793, line, logoX, yPos, -1);
                }
            }
            yPos += 12;
        }
        graphics.method_51448().popMatrix();
    }

    private void renderVignette(class_332 graphics) {
        graphics.method_25290(class_10799.field_56889, VIGNETTE, 0, 0, 0.0f, 0.0f, this.field_22789, this.field_22790, this.field_22789, this.field_22790);
    }

    private void renderLogo(class_332 graphics, int width, int heightOffset) {
        int logoX = width / 2 - 128;
        graphics.method_25291(class_10799.field_56883, LOGO, logoX, heightOffset, 0.0f, 0.0f, 256, 64, 256, 64, -1);
    }

    protected void method_57736(class_332 graphics, int x, int y, int width, int height) {
        float v = this.scroll * 0.5f;
        class_437.method_57737((class_332)graphics, (class_2960)class_437.field_49511, (int)0, (int)0, (float)0.0f, (float)v, (int)width, (int)height);
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public void method_25432() {
        this.field_22787.method_1538().method_50025(SKYBLOCKER_CREDITS_MUSIC);
    }

    public class_5195 method_50024() {
        return SKYBLOCKER_CREDITS_MUSIC;
    }

    private record Credits(List<Author> authors, List<String> creativeTeam, List<Translation> translations, List<Library> libraries) {
        private static final Codec<Credits> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Author.CODEC.listOf().fieldOf("authors").forGetter(Credits::authors), (App)Codec.STRING.listOf().fieldOf("creativeTeam").forGetter(Credits::creativeTeam), (App)Translation.CODEC.listOf().fieldOf("translations").forGetter(Credits::translations), (App)Library.CODEC.listOf().fieldOf("libraries").forGetter(Credits::libraries)).apply((Applicative)instance, Credits::new));
        private static final Credits EMPTY = new Credits(List.of(new Author("Error", UUID.fromString("647ffd4c-f99c-4b06-a8f8-66cf1a587e57"), -65536)), List.of(), List.of(), List.of());
    }

    private record Author(String name, UUID uuid, int colour) {
        private static final Codec<Author> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(Author::name), (App)class_4844.field_41525.fieldOf("uuid").forGetter(Author::uuid), (App)class_5699.field_63682.optionalFieldOf("colour", (Object)-1).forGetter(Author::colour)).apply((Applicative)instance, Author::new));

        public class_2561 asText() {
            class_9296 profile = class_9296.method_73312((UUID)this.uuid);
            class_310.method_1551().method_73362().method_74320(profile);
            return class_2561.method_43473().method_10852((class_2561)class_2561.method_74062((class_11724)new class_11885(profile, true))).method_10852((class_2561)class_2561.method_43470((String)(" " + this.name)).method_54663(this.colour));
        }
    }

    private record Translation(String code, String name, List<String> translators) {
        private static final Codec<Translation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("code").forGetter(Translation::code), (App)Codec.STRING.fieldOf("name").forGetter(Translation::name), (App)CodecUtils.sortedListCodec(Codec.STRING, String::compareToIgnoreCase).fieldOf("translators").forGetter(Translation::translators)).apply((Applicative)instance, Translation::new));
    }

    private record Library(String name, String credit) {
        private static final Codec<Library> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(Library::name), (App)Codec.STRING.fieldOf("credit").forGetter(Library::credit)).apply((Applicative)instance, Library::new));
    }
}

