/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker;

import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.debug.Debug;
import de.hysky.skyblocker.events.SkyblockEvents;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.Http;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.data.ProfiledData;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.UnaryOperator;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.impl.game.minecraft.McVersionLookup;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_155;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3542;
import net.minecraft.class_370;
import net.minecraft.class_374;
import net.minecraft.class_5250;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class UpdateNotifications {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final class_310 MINECRAFT = class_310.method_1551();
    private static final String VERSIONS_URL = "https://api.modrinth.com/v2/project/skyblocker-liap/version?loaders=[%22fabric%22]&include_changelog=false";
    private static final Version MOD_VERSION = SkyblockerMod.SKYBLOCKER_MOD.getMetadata().getVersion();
    private static final Path CONFIG_PATH = SkyblockerMod.CONFIG_DIR.resolve("update_notifications_v2.json");
    @VisibleForTesting
    protected static final Comparator<Version> VERSION_COMPARATOR = Comparable::compareTo;
    @VisibleForTesting
    protected static final Codec<SemanticVersion> SEMANTIC_VERSION_CODEC = Codec.STRING.comapFlatMap(UpdateNotifications::parseVersion, SemanticVersion::toString);
    @VisibleForTesting
    protected static final Codec<SemanticVersion> MINECRAFT_VERSION_CODEC = Codec.STRING.comapFlatMap(UpdateNotifications::parseMinecraftVersion, SemanticVersion::toString);
    private static final class_370.class_9037 TOAST_TYPE = new class_370.class_9037(10000L);
    private static final ProfiledData<Config> CONFIG = new ProfiledData<Config>(CONFIG_PATH, Config.CODEC);
    private static boolean sentUpdateNotification;
    private static @Nullable CompletableFuture<Void> loaded;

    @Init
    public static void init() {
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> {
            loaded = CONFIG.init();
        });
        SkyblockEvents.JOIN.register(() -> Objects.requireNonNull(loaded).thenRunAsync(UpdateNotifications::tryCheckForNewVersion, (Executor)class_310.method_1551()));
    }

    private static void tryCheckForNewVersion() {
        if (UpdateNotifications.getConfig().enabled() && !sentUpdateNotification) {
            Scheduler.INSTANCE.schedule(UpdateNotifications::checkForNewVersion, 1200);
            Scheduler.INSTANCE.schedule(UpdateNotifications::introduceNewUpdate, 1200);
        }
    }

    private static void checkForNewVersion() {
        CompletableFuture.runAsync(() -> {
            try {
                SemanticVersion currentModVersion = (SemanticVersion)MOD_VERSION;
                SemanticVersion currentMinecraftVersion = (SemanticVersion)UpdateNotifications.parseMinecraftVersion(class_155.method_16673().comp_4024()).getOrThrow();
                String response = Http.sendGetRequest(VERSIONS_URL);
                List mrVersions = (List)MrVersion.LIST_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString(response)).getOrThrow();
                sentUpdateNotification = true;
                Optional<MrVersion> optimalVersion = UpdateNotifications.getOptimalVersion(currentModVersion, currentMinecraftVersion, mrVersions);
                if (optimalVersion.isPresent() && !UpdateNotifications.shouldDiscard(currentModVersion, optimalVersion.get().version())) {
                    MrVersion newVersion = optimalVersion.get();
                    String downloadLink = "https://modrinth.com/mod/skyblocker-liap/version/" + newVersion.id();
                    class_5250 versionText = class_2561.method_43470((String)newVersion.name()).method_27694(style -> style.method_27706(class_124.field_1080).method_30938(Boolean.valueOf(true)).method_10958((class_2558)new class_2558.class_10608(URI.create(downloadLink))));
                    MINECRAFT.execute(() -> UpdateNotifications.lambda$checkForNewVersion$3((class_2561)versionText, newVersion));
                }
            }
            catch (Exception e) {
                LOGGER.error("[Skyblocker Update Notifications] Failed to determine if an update is available or not!", (Throwable)e);
            }
        }, Executors.newVirtualThreadPerTaskExecutor());
    }

    private static void introduceNewUpdate() {
        try {
            boolean shouldIntroduceUpdate;
            Optional<SemanticVersion> newestVersionUsed = UpdateNotifications.getConfig().newestVersionUsed();
            SemanticVersion currentModVersion = (SemanticVersion)MOD_VERSION;
            boolean bl = shouldIntroduceUpdate = newestVersionUsed.isEmpty() || VERSION_COMPARATOR.compare((Version)currentModVersion, (Version)newestVersionUsed.get()) > 0;
            if (!shouldIntroduceUpdate) {
                return;
            }
            String versionTagString = String.format(Locale.ENGLISH, "v%d.%d.%d", currentModVersion.getVersionComponent(0), currentModVersion.getVersionComponent(1), currentModVersion.getVersionComponent(2));
            class_5250 configureText = class_2561.method_43471((String)"skyblocker.updateNotifications.configureNewVersionHere").method_27694(style -> style.method_27706(class_124.field_1080).method_30938(Boolean.valueOf(true)).method_10958((class_2558)new class_2558.class_10609("/skyblocker config " + versionTagString)));
            class_5250 newVersionText = class_2561.method_43469((String)"skyblocker.updateNotifications.configureNewVersion", (Object[])new Object[]{SkyblockerMod.VERSION, configureText});
            UpdateNotifications.MINECRAFT.field_1724.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)newVersionText), false);
            UpdateNotifications.setConfig(config -> config.withNewestVersionUsed(currentModVersion));
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker Update Notifications] Failed to introduce the new update!", (Throwable)e);
        }
    }

    @VisibleForTesting
    protected static Optional<MrVersion> getOptimalVersion(SemanticVersion currentModVersion, SemanticVersion currentMinecraftVersion, List<MrVersion> mrVersions) {
        Config config = Debug.isTestEnvironment() ? Config.DEFAULT : UpdateNotifications.getConfig();
        List<MrVersion> eligibleModVersions = mrVersions.stream().filter(releaseVersion -> config.encompassingChannels().contains((Object)releaseVersion.channel())).filter(releaseVersion -> VERSION_COMPARATOR.compare((Version)releaseVersion.version(), (Version)currentModVersion) > 0).toList();
        if (eligibleModVersions.isEmpty()) {
            return Optional.empty();
        }
        SemanticVersion newestModVersion = Collections.max(eligibleModVersions, Comparator.comparing(MrVersion::version)).version();
        Optional<MrVersion> latestModVersionForCurrentMinecraftVersion = eligibleModVersions.stream().filter(releaseVersion -> VERSION_COMPARATOR.compare((Version)releaseVersion.version(), (Version)newestModVersion) == 0).filter(releaseVersion -> releaseVersion.minecraftVersions().stream().anyMatch(version -> VERSION_COMPARATOR.compare((Version)version, (Version)currentMinecraftVersion) == 0)).findFirst();
        if (latestModVersionForCurrentMinecraftVersion.isPresent()) {
            return latestModVersionForCurrentMinecraftVersion;
        }
        Optional<MrVersion> latestModVersionForNewestMinecraftVersion = eligibleModVersions.stream().filter(releaseVersion -> VERSION_COMPARATOR.compare((Version)releaseVersion.version(), (Version)newestModVersion) == 0).max(Comparator.comparing(MrVersion::newestMinecraftVersionSupported, VERSION_COMPARATOR));
        return latestModVersionForNewestMinecraftVersion;
    }

    private static DataResult<SemanticVersion> parseVersion(String version) {
        String formattedVersion = version.transform(s -> s.charAt(0) == 'v' ? s.substring(1) : s);
        try {
            return DataResult.success((Object)SemanticVersion.parse((String)formattedVersion));
        }
        catch (VersionParsingException e) {
            return DataResult.error(() -> "Failed to parse semantic version from string: " + formattedVersion);
        }
    }

    private static DataResult<SemanticVersion> parseMinecraftVersion(String minecraftVersion) {
        String normalized = McVersionLookup.normalizeVersion((String)minecraftVersion, (String)McVersionLookup.getRelease((String)minecraftVersion));
        return UpdateNotifications.parseVersion(normalized);
    }

    private static boolean isUnofficialAlphaOrBeta(SemanticVersion version) {
        boolean bl;
        String string = version.getPrereleaseKey().orElse("");
        Objects.requireNonNull(string);
        String string2 = string;
        int n = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, String.class}, (Object)string2, n)) {
                case 0: {
                    String s = string2;
                    if (!s.startsWith("alpha")) {
                        n = 1;
                        continue block4;
                    }
                    if (s.substring(5).charAt(0) == '-') {
                        bl = true;
                        break block4;
                    }
                    bl = false;
                    break block4;
                }
                case 1: {
                    String s = string2;
                    if (!s.startsWith("beta")) {
                        n = 2;
                        continue block4;
                    }
                    if (s.substring(4).charAt(0) == '-') {
                        bl = true;
                        break block4;
                    }
                    bl = false;
                    break block4;
                }
                default: {
                    bl = false;
                    break block4;
                }
            }
            break;
        }
        return bl;
    }

    @VisibleForTesting
    protected static boolean shouldDiscard(SemanticVersion currentVersion, SemanticVersion latestVersion) {
        if (UpdateNotifications.isUnofficialAlphaOrBeta(currentVersion)) {
            int currentMajor = currentVersion.getVersionComponent(0);
            int currentMinor = currentVersion.getVersionComponent(1);
            int currentPatch = currentVersion.getVersionComponent(2);
            int latestMajor = latestVersion.getVersionComponent(0);
            int latestMinor = latestVersion.getVersionComponent(1);
            int latestPatch = latestVersion.getVersionComponent(2);
            return currentMajor == latestMajor && currentMinor == latestMinor && currentPatch == latestPatch;
        }
        return false;
    }

    public static Config getConfig() {
        return CONFIG.computeIfAbsent(Utils.getUuid(), "", () -> Config.DEFAULT);
    }

    public static void setConfig(UnaryOperator<Config> updater) {
        CONFIG.put(Utils.getUuid(), "", (Config)updater.apply(UpdateNotifications.getConfig()));
    }

    private static /* synthetic */ void lambda$checkForNewVersion$3(class_2561 versionText, MrVersion newVersion) {
        if (UpdateNotifications.MINECRAFT.field_1724 == null) {
            return;
        }
        UpdateNotifications.MINECRAFT.field_1724.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43469((String)"skyblocker.updateNotifications.newUpdateMessage", (Object[])new Object[]{versionText})), false);
        class_370.method_27024((class_374)MINECRAFT.method_1566(), (class_370.class_9037)TOAST_TYPE, (class_2561)class_2561.method_43471((String)"skyblocker.updateNotifications.newUpdateToast.title"), (class_2561)class_2561.method_54159((String)"skyblocker.updateNotifications.newUpdateToast.description", (Object[])new Object[]{newVersion.version()}));
    }

    public record Config(boolean enabled, Channel channel, Optional<SemanticVersion> newestVersionUsed) {
        public static final Config DEFAULT = new Config(true, Channel.ALPHA, Optional.empty());
        private static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("enabled").forGetter(Config::enabled), (App)Channel.CODEC.fieldOf("channel").forGetter(Config::channel), (App)SEMANTIC_VERSION_CODEC.optionalFieldOf("newestVersionUsed").forGetter(Config::newestVersionUsed)).apply((Applicative)instance, Config::new));

        private List<Channel> encompassingChannels() {
            return switch (this.channel.ordinal()) {
                case 1 -> List.of(Channel.RELEASE, Channel.BETA);
                case 2 -> List.of(Channel.values());
                default -> List.of(this.channel);
            };
        }

        public Config withEnabled(boolean newEnabled) {
            return new Config(newEnabled, this.channel, this.newestVersionUsed);
        }

        public Config withChannel(Channel newChannel) {
            return new Config(this.enabled, newChannel, this.newestVersionUsed);
        }

        private Config withNewestVersionUsed(SemanticVersion newNewestVersionUsed) {
            return new Config(this.enabled, this.channel, Optional.of(newNewestVersionUsed));
        }
    }

    @VisibleForTesting
    protected record MrVersion(String id, String name, SemanticVersion version, List<SemanticVersion> minecraftVersions, Channel channel) {
        private static final Codec<MrVersion> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("id").forGetter(MrVersion::id), (App)Codec.STRING.fieldOf("name").forGetter(MrVersion::name), (App)SEMANTIC_VERSION_CODEC.fieldOf("version_number").forGetter(MrVersion::version), (App)MINECRAFT_VERSION_CODEC.listOf().fieldOf("game_versions").forGetter(MrVersion::minecraftVersions), (App)Channel.CODEC.fieldOf("version_type").forGetter(MrVersion::channel)).apply((Applicative)instance, MrVersion::new));
        private static final Codec<List<MrVersion>> LIST_CODEC = CODEC.listOf();

        private SemanticVersion newestMinecraftVersionSupported() {
            return (SemanticVersion)this.minecraftVersions().stream().max(VERSION_COMPARATOR).orElseThrow();
        }
    }

    public static enum Channel implements class_3542
    {
        RELEASE,
        BETA,
        ALPHA;

        private static final Codec<Channel> CODEC;

        public String toString() {
            return class_1074.method_4662((String)("skyblocker.config.general.updateNotifications.updateChannel.channel." + this.name()), (Object[])new Object[0]);
        }

        public String method_15434() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        static {
            CODEC = class_3542.method_53955(Channel::values);
        }
    }
}

