/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.compatibility.emi;

import de.hysky.skyblocker.compatibility.emi.SkyblockerEMIPlugin;
import de.hysky.skyblocker.skyblock.itemlist.recipes.SkyblockRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5348;
import net.minecraft.class_8029;
import org.jspecify.annotations.Nullable;

public class SkyblockEmiRecipe
implements EmiRecipe {
    private final class_2561 craftText;
    private final SkyblockRecipe recipe;

    public SkyblockEmiRecipe(SkyblockRecipe recipe) {
        this.craftText = recipe.getExtraText();
        this.recipe = recipe;
    }

    public EmiRecipeCategory getCategory() {
        return SkyblockerEMIPlugin.IDENTIFIER_CATEGORY_MAP.get(this.recipe.getCategoryIdentifier());
    }

    public @Nullable class_2960 getId() {
        return this.recipe.getRecipeIdentifier();
    }

    public List<EmiIngredient> getInputs() {
        return this.recipe.getInputs().stream().map(EmiStack::of).map(EmiIngredient.class::cast).toList();
    }

    public List<EmiStack> getOutputs() {
        return this.recipe.getOutputs().stream().map(EmiStack::of).toList();
    }

    public int getDisplayWidth() {
        return 118;
    }

    public int getDisplayHeight() {
        return 54 + (this.craftText.getString().isEmpty() ? 0 : 10);
    }

    public void addWidgets(WidgetHolder widgets) {
        class_8029 arrowLocation = this.recipe.getArrowLocation(this.getDisplayWidth(), this.getDisplayHeight());
        if (arrowLocation != null) {
            widgets.addTexture(EmiTexture.EMPTY_ARROW, arrowLocation.comp_1193(), arrowLocation.comp_1194());
        }
        widgets.addText(this.craftText, 59 - class_310.method_1551().field_1772.method_27525((class_5348)this.craftText) / 2, 55, 0xFFFFFF, true);
        for (SkyblockRecipe.RecipeSlot inputSlot : this.recipe.getInputSlots(this.getDisplayWidth(), this.getDisplayHeight())) {
            widgets.addSlot((EmiIngredient)EmiStack.of((class_1799)inputSlot.stack()), inputSlot.x(), inputSlot.y());
        }
        for (SkyblockRecipe.RecipeSlot outputSlot : this.recipe.getOutputSlots(this.getDisplayWidth(), this.getDisplayHeight())) {
            widgets.addSlot((EmiIngredient)EmiStack.of((class_1799)outputSlot.stack()), outputSlot.x(), outputSlot.y()).recipeContext((EmiRecipe)this);
        }
        widgets.addDrawable(0, 0, this.getDisplayWidth(), this.getDisplayHeight(), (draw, mouseX, mouseY, delta) -> this.recipe.render(draw, this.getDisplayWidth(), this.getDisplayHeight(), mouseX, mouseY));
    }
}

