/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.config;

import com.mojang.logging.LogUtils;
import de.hysky.skyblocker.config.SkyblockerConfig;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;

public class ConfigNullFieldsFix {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final String CONFIGS_PACKAGE = "de.hysky.skyblocker.config.configs";

    public static void init() {
        SkyblockerConfigManager.update(config -> {
            try {
                ConfigNullFieldsFix.fixNullFields(config, new SkyblockerConfig());
            }
            catch (Exception e) {
                LOGGER.error("[Skyblocker Config Null Fields Fixer] Failed to ensure that the config has no null fields! You may encounter crashes :(", (Throwable)e);
            }
        });
    }

    private static void fixNullFields(Object target, Object source) throws Exception {
        for (Field field : target.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(SerialEntry.class)) continue;
            field.setAccessible(true);
            Object targetValue = field.get(target);
            Object sourceValue = field.get(source);
            if (targetValue == null && sourceValue != null) {
                field.set(target, sourceValue);
                continue;
            }
            if (targetValue == null || sourceValue == null || !ConfigNullFieldsFix.isFixable(field.getType())) continue;
            ConfigNullFieldsFix.fixNullFields(targetValue, sourceValue);
        }
    }

    private static boolean isFixable(Class<?> clazz) {
        return !clazz.isPrimitive() && !clazz.isEnum() && !clazz.isRecord() && !clazz.equals(String.class) && !Number.class.isAssignableFrom(clazz) && !Map.class.isAssignableFrom(clazz) && !Collection.class.isAssignableFrom(clazz) && clazz.getPackageName().startsWith(CONFIGS_PACKAGE);
    }
}

