/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.config;

import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.utils.Http;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import net.azureaaron.dandelion.api.patching.ConfigPatch;
import net.minecraft.class_310;
import org.slf4j.Logger;

public class ConfigPatchLoader {
    private static final Logger LOGGER = LogUtils.getLogger();

    @Init
    public static void init() {
        Scheduler.INSTANCE.scheduleCyclic(ConfigPatchLoader::fetchPatchList, 72000);
    }

    private static void fetchPatchList() {
        ((CompletableFuture)CompletableFuture.supplyAsync(() -> {
            try {
                String response = Http.sendGetRequest("https://api.azureaaron.net/skyblocker/configpatches");
                return JsonParser.parseString(response);
            }
            catch (Exception e) {
                LOGGER.error(LogUtils.FATAL_MARKER, "[Skyblocker Config Patch Loader] Failed to load config patches!", (Throwable)e);
                return null;
            }
        }, Executors.newVirtualThreadPerTaskExecutor()).thenAcceptAsync(json -> {
            List patches = (List)ConfigPatch.PATCH_LIST_CODEC.parse((DynamicOps)JsonOps.INSTANCE, json).setPartial(List.of()).resultOrPartial(error -> LOGGER.error(LogUtils.FATAL_MARKER, "[Skyblocker Config Patch Loader] Failed to parse config patches! Error: {}", error)).get();
            LOGGER.info("[Skyblocker Config Patch Loader] Successfully loaded config patches.");
            SkyblockerConfigManager.setPatches(patches);
        }, (Executor)class_310.method_1551())).exceptionally(e -> {
            LOGGER.error(LogUtils.FATAL_MARKER, "[Skyblocker Config Patch Loader] Failed to load config patches!", e);
            return null;
        });
    }
}

