/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.utils.FileUtils;
import de.hysky.skyblocker.utils.Http;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;

public class ImageRepoLoader {
    private static final Logger LOGGER = LogUtils.getLogger();
    static final Path REPO_DIRECTORY = SkyblockerMod.CONFIG_DIR.resolve("image-repo");
    private static final String BRANCH_INFO = "https://api.github.com/repos/SkyblockerMod/Skyblocker-Assets/branches/images";
    private static final String REPO_DOWNLOAD = "https://github.com/SkyblockerMod/Skyblocker-Assets/archive/refs/heads/images.zip";
    private static final String PLACEHOLDER_HASH = "None!";

    public static void init() {
        ImageRepoLoader.update(0);
    }

    private static void update(int retries) {
        CompletableFuture.runAsync(() -> {
            block13: {
                if (retries < 3) {
                    try {
                        long start = System.currentTimeMillis();
                        String savedCommitHash = ImageRepoLoader.checkSavedCommitData();
                        JsonObject response = JsonParser.parseString(Http.sendGetRequest(BRANCH_INFO)).getAsJsonObject();
                        String latestCommitHash = response.getAsJsonObject("commit").get("sha").getAsString();
                        if (!savedCommitHash.equals(latestCommitHash)) {
                            InputStream in = Http.downloadContent(REPO_DOWNLOAD);
                            if (Files.exists(REPO_DIRECTORY, new LinkOption[0])) {
                                ImageRepoLoader.deleteDirectories();
                            }
                            try (ZipInputStream zis = new ZipInputStream(in);){
                                ZipEntry entry;
                                while ((entry = zis.getNextEntry()) != null) {
                                    Path outputFile = REPO_DIRECTORY.resolve(entry.getName());
                                    if (entry.isDirectory()) {
                                        Files.createDirectories(outputFile, new FileAttribute[0]);
                                        continue;
                                    }
                                    Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
                                    Files.copy(zis, outputFile, StandardCopyOption.REPLACE_EXISTING);
                                }
                            }
                            ImageRepoLoader.writeCommitData(latestCommitHash);
                            long end = System.currentTimeMillis();
                            LOGGER.info("[Skyblocker] Successfully updated the Image Respository in {} ms! {} \u2192 {}", new Object[]{end - start, savedCommitHash, latestCommitHash});
                            break block13;
                        }
                        LOGGER.info("[Skyblocker] The Image Respository is up to date!");
                    }
                    catch (Exception e) {
                        LOGGER.error("[Skyblocker] Error while downloading image repo on attempt {}!", (Object)retries, (Object)e);
                        ImageRepoLoader.update(retries + 1);
                    }
                }
            }
        }, Executors.newVirtualThreadPerTaskExecutor());
    }

    private static String checkSavedCommitData() throws IOException {
        Path file = REPO_DIRECTORY.resolve("image_repo.json");
        if (Files.exists(file, new LinkOption[0])) {
            try (BufferedReader reader = Files.newBufferedReader(file);){
                CommitData commitData = (CommitData)CommitData.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader(reader)).getOrThrow();
                String string = commitData.commit();
                return string;
            }
        }
        return PLACEHOLDER_HASH;
    }

    private static void writeCommitData(String newHash) throws IOException {
        Path file = REPO_DIRECTORY.resolve("image_repo.json");
        CommitData commitData = new CommitData(newHash, System.currentTimeMillis());
        try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
            SkyblockerMod.GSON.toJson((JsonElement)CommitData.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)commitData).getOrThrow(), (Appendable)writer);
        }
    }

    private static void deleteDirectories() throws IOException {
        Files.list(REPO_DIRECTORY).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).forEach(dir -> {
            try {
                FileUtils.recursiveDelete(dir);
            }
            catch (Exception e) {
                LOGGER.error("[Skyblocker] Encountered an exception while deleting a directory! Path: {}", (Object)dir.toAbsolutePath(), (Object)e);
            }
        });
    }

    record CommitData(String commit, long lastUpdated) {
        static final Codec<CommitData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("commit").forGetter(CommitData::commit), (App)Codec.LONG.fieldOf("lastUpdated").forGetter(CommitData::lastUpdated)).apply((Applicative)instance, CommitData::new));
    }
}

