/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.logging.LogUtils;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.config.SkyblockerConfig;
import de.hysky.skyblocker.config.backup.ConfigBackupManager;
import de.hysky.skyblocker.config.categories.ChatCategory;
import de.hysky.skyblocker.config.categories.CrimsonIsleCategory;
import de.hysky.skyblocker.config.categories.DebugCategory;
import de.hysky.skyblocker.config.categories.DungeonsCategory;
import de.hysky.skyblocker.config.categories.EventNotificationsCategory;
import de.hysky.skyblocker.config.categories.FarmingCategory;
import de.hysky.skyblocker.config.categories.ForagingCategory;
import de.hysky.skyblocker.config.categories.GeneralCategory;
import de.hysky.skyblocker.config.categories.HelperCategory;
import de.hysky.skyblocker.config.categories.HuntingCategory;
import de.hysky.skyblocker.config.categories.MiningCategory;
import de.hysky.skyblocker.config.categories.MiscCategory;
import de.hysky.skyblocker.config.categories.OtherLocationsCategory;
import de.hysky.skyblocker.config.categories.QuickNavigationCategory;
import de.hysky.skyblocker.config.categories.SlayersCategory;
import de.hysky.skyblocker.config.categories.UIAndVisualsCategory;
import de.hysky.skyblocker.config.datafixer.ConfigDataFixer;
import de.hysky.skyblocker.debug.Debug;
import de.hysky.skyblocker.mixins.accessors.AbstractContainerScreenAccessor;
import de.hysky.skyblocker.utils.datafixer.JsonHelper;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.azureaaron.dandelion.api.ConfigManager;
import net.azureaaron.dandelion.api.DandelionConfigScreen;
import net.azureaaron.dandelion.api.patching.ConfigPatch;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_476;
import net.minecraft.class_7919;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class SkyblockerConfigManager {
    public static final int CONFIG_VERSION = 6;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Path CONFIG_DIR = FabricLoader.getInstance().getConfigDir();
    private static final Path CONFIG_FILE = CONFIG_DIR.resolve("skyblocker.json");
    private static final ConfigManager<SkyblockerConfig> CONFIG_MANAGER = ConfigManager.create(SkyblockerConfig.class, (Path)CONFIG_FILE, UnaryOperator.identity());

    public static SkyblockerConfig get() {
        return (SkyblockerConfig)CONFIG_MANAGER.instance();
    }

    protected static SkyblockerConfig getUnpatched() {
        return (SkyblockerConfig)CONFIG_MANAGER.unpatchedInstance();
    }

    public static void init() {
        if (StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).getCallerClass() != SkyblockerMod.class) {
            throw new RuntimeException("Skyblocker: Called config init from an illegal place!");
        }
        SkyblockerConfigManager.dataFix(CONFIG_FILE, CONFIG_DIR.resolve("skyblocker.json.old"));
        CONFIG_MANAGER.load();
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblocker").then(SkyblockerConfigManager.configLiteral("config"))).then(SkyblockerConfigManager.configLiteral("options"))));
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (SkyblockerConfigManager.get().uiAndVisuals.showConfigButton && screen instanceof class_476) {
                class_476 genericContainerScreen = (class_476)screen;
                if (screen.method_25440().getString().equals("SkyBlock Menu")) {
                    Screens.getButtons((class_437)screen).add(class_4185.method_46430((class_2561)class_2561.method_43470((String)"\ud83d\udd27"), buttonWidget -> client.method_1507(SkyblockerConfigManager.createGUI(screen))).method_46434(((AbstractContainerScreenAccessor)genericContainerScreen).getX() + ((AbstractContainerScreenAccessor)genericContainerScreen).getImageWidth() - 16, ((AbstractContainerScreenAccessor)genericContainerScreen).getY() + 4, 12, 12).method_46436(class_7919.method_47407((class_2561)class_2561.method_43469((String)"skyblocker.config.title", (Object[])new Object[]{class_2561.method_43471((String)"skyblocker.config.title.settings")}))).method_46431());
                }
            }
        });
    }

    protected static void setPatches(List<ConfigPatch> patches) {
        CONFIG_MANAGER.setPatches(patches);
    }

    public static void update(Consumer<SkyblockerConfig> action) {
        action.accept(SkyblockerConfigManager.getUnpatched());
        ConfigBackupManager.backupConfig();
        CONFIG_MANAGER.save();
    }

    public static void updateOnly(Consumer<SkyblockerConfig> action) {
        action.accept(SkyblockerConfigManager.getUnpatched());
        CONFIG_MANAGER.updatePatchedInstance();
    }

    public static class_437 createGUI(@Nullable class_437 parent) {
        return SkyblockerConfigManager.createGUI(parent, "");
    }

    public static class_437 createGUI(@Nullable class_437 parent, String search) {
        return DandelionConfigScreen.create(CONFIG_MANAGER, (defaults, config, builder) -> builder.title((class_2561)class_2561.method_43469((String)"skyblocker.config.title", (Object[])new Object[]{SkyblockerMod.VERSION})).category(GeneralCategory.create(defaults, config)).category(UIAndVisualsCategory.create(defaults, config)).category(HelperCategory.create(defaults, config)).category(DungeonsCategory.create(defaults, config)).category(ForagingCategory.create(defaults, config)).category(CrimsonIsleCategory.create(defaults, config)).category(MiningCategory.create(defaults, config)).category(FarmingCategory.create(defaults, config)).category(HuntingCategory.create(defaults, config)).category(OtherLocationsCategory.create(defaults, config)).category(SlayersCategory.create(defaults, config)).category(ChatCategory.create(defaults, config)).category(QuickNavigationCategory.create(defaults, config)).category(EventNotificationsCategory.create(defaults, config)).category(MiscCategory.create(defaults, config)).categoryIf(Debug.debugEnabled(), DebugCategory.create(defaults, config)).search(search)).generateScreen(parent, SkyblockerConfigManager.get().misc.configBackend);
    }

    public static Path getConfigPath() {
        return CONFIG_FILE;
    }

    public static void reload() {
        CONFIG_MANAGER.load();
    }

    private static LiteralArgumentBuilder<FabricClientCommandSource> configLiteral(String name) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)name).executes(Scheduler.queueOpenScreenCommand(() -> SkyblockerConfigManager.createGUI(null)))).then(ClientCommandManager.argument((String)"option", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> Scheduler.queueOpenScreen(SkyblockerConfigManager.createGUI(null, (String)ctx.getArgument("option", String.class)))));
    }

    public static void dataFix(Path configDir, Path backupDir) {
        if (!Files.exists(CONFIG_DIR, new LinkOption[0]) || !Files.exists(configDir, new LinkOption[0])) {
            return;
        }
        JsonObject oldConfig = SkyblockerConfigManager.loadConfig(configDir);
        if (oldConfig == null || JsonHelper.getInt(oldConfig, "version").orElse(1) == 6) {
            return;
        }
        JsonObject newConfig = ConfigDataFixer.apply(ConfigDataFixer.CONFIG_TYPE, oldConfig);
        if (!SkyblockerConfigManager.writeConfig(configDir, newConfig)) {
            LOGGER.error(LogUtils.FATAL_MARKER, "[Skyblocker Config Data Fixer] Failed to fix up config file!");
            SkyblockerConfigManager.writeConfig(backupDir, oldConfig);
        }
    }

    private static @Nullable JsonObject loadConfig(Path path) {
        JsonObject jsonObject;
        block8: {
            BufferedReader reader = Files.newBufferedReader(path);
            try {
                jsonObject = JsonParser.parseReader(reader).getAsJsonObject();
                if (reader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    LOGGER.error("[Skyblocker Config Data Fixer] Failed to load config file!", t);
                    return null;
                }
            }
            reader.close();
        }
        return jsonObject;
    }

    private static boolean writeConfig(Path path, JsonObject config) {
        boolean bl;
        block8: {
            BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);
            try {
                SkyblockerMod.GSON.toJson((JsonElement)config, (Appendable)writer);
                bl = true;
                if (writer == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    LOGGER.error("[Skyblocker Config Data Fixer] Failed to save config file at {}!", (Object)path, (Object)t);
                    return false;
                }
            }
            writer.close();
        }
        return bl;
    }
}

