/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.config.backup;

import com.mojang.logging.LogUtils;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import org.slf4j.Logger;

public class ConfigBackupManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Path BACKUP_DIR = SkyblockerMod.CONFIG_DIR.resolve("config_backups");
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss");
    private static final int MAX_BACKUPS = 10;

    private ConfigBackupManager() {
    }

    public static void init() {
        CompletableFuture.runAsync(() -> {
            try {
                Files.createDirectories(BACKUP_DIR, new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.error("[Skyblocker] Failed to create backup directory!", (Throwable)e);
            }
        }, Executors.newVirtualThreadPerTaskExecutor());
        ClientLifecycleEvents.CLIENT_STOPPING.register(client -> ConfigBackupManager.backupConfig());
    }

    public static void backupConfig() {
        try {
            Path latest;
            Path configPath = SkyblockerConfigManager.getConfigPath();
            if (!Files.exists(configPath, new LinkOption[0])) {
                return;
            }
            Files.createDirectories(BACKUP_DIR, new FileAttribute[0]);
            List<Path> backups = ConfigBackupManager.listBackups();
            Path path = latest = backups.isEmpty() ? null : backups.getFirst();
            if (latest != null && Files.mismatch(configPath, latest) == -1L) {
                return;
            }
            Path backup = BACKUP_DIR.resolve("skyblocker_" + FORMATTER.format(LocalDateTime.now()) + ".json");
            Files.copy(configPath, backup, StandardCopyOption.REPLACE_EXISTING);
            ConfigBackupManager.cleanOldBackups();
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker] Failed to backup config!", (Throwable)e);
        }
    }

    public static List<Path> listBackups() throws IOException {
        if (!Files.exists(BACKUP_DIR, new LinkOption[0])) {
            return List.of();
        }
        try (Stream<Path> stream = Files.list(BACKUP_DIR);){
            List<Path> list = stream.filter(p -> p.getFileName().toString().endsWith(".json")).sorted(Comparator.reverseOrder()).toList();
            return list;
        }
    }

    public static void restoreBackup(Path backup) throws IOException {
        Files.copy(backup, SkyblockerConfigManager.getConfigPath(), StandardCopyOption.REPLACE_EXISTING);
        SkyblockerConfigManager.reload();
    }

    private static void cleanOldBackups() throws IOException {
        List<Path> backups = ConfigBackupManager.listBackups();
        for (int i = 10; i < backups.size(); ++i) {
            try {
                Files.deleteIfExists(backups.get(i));
                continue;
            }
            catch (IOException e) {
                LOGGER.error("[Skyblocker] Failed to delete old backup {}", (Object)backups.get(i), (Object)e);
            }
        }
    }
}

