/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.config.backup;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.config.backup.ConfigBackupManager;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_11876;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_7842;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class ConfigBackupScreen
extends class_437 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final class_437 parent;
    private BackupListWidget listWidget;
    private SettingsListWidget detailsWidget;
    private Set<String> changedPaths = Collections.emptySet();

    public ConfigBackupScreen(@Nullable class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"skyblocker.config.general.backup.title"));
        this.parent = parent;
    }

    protected void method_25426() {
        int listWidth = this.field_22789 / 2 - 4;
        int detailsWidth = this.field_22789 - listWidth - 8;
        int listHeight = this.field_22790 - 64;
        if (this.listWidget == null) {
            this.listWidget = new BackupListWidget(this.field_22787, listWidth, listHeight, 32, 25);
            this.listWidget.updateEntries();
        } else {
            this.listWidget.method_55445(listWidth, listHeight);
        }
        this.listWidget.method_46421(4);
        this.listWidget.method_65506();
        this.method_37063((class_364)this.listWidget);
        if (this.detailsWidget == null) {
            this.detailsWidget = new SettingsListWidget(this.field_22787, detailsWidth, listHeight, 32, 10);
            this.detailsWidget.updateEntries(this.listWidget.getSelectedPath());
        } else {
            this.detailsWidget.method_55445(detailsWidth, listHeight);
        }
        this.detailsWidget.method_46421(listWidth + 8);
        this.detailsWidget.method_65506();
        this.method_37063((class_364)this.detailsWidget);
        class_4185 restoreBtn = class_4185.method_46430((class_2561)class_2561.method_43471((String)"skyblocker.config.general.backup.restore"), b -> {
            Path selected = this.listWidget.getSelectedPath();
            if (selected != null) {
                assert (this.field_22787 != null);
                this.field_22787.method_1507((class_437)new class_410(confirm -> {
                    if (confirm) {
                        try {
                            ConfigBackupManager.restoreBackup(selected);
                        }
                        catch (IOException e) {
                            LOGGER.error("[Skyblocker] Failed to restore backup {}", (Object)selected.getFileName().toString(), (Object)e);
                            this.field_22787.method_1566().method_1999((class_368)new class_370(class_370.class_9037.field_47588, (class_2561)class_2561.method_43471((String)"skyblocker.config.general.backup.restore.error"), null));
                            return;
                        }
                        if (this.parent != null) {
                            this.field_22787.method_1507(SkyblockerConfigManager.createGUI(this.parent));
                        } else {
                            this.field_22787.method_1507(null);
                        }
                    } else {
                        this.field_22787.method_1507((class_437)this);
                    }
                }, (class_2561)class_2561.method_43471((String)"skyblocker.config.general.backup.confirm.title"), (class_2561)class_2561.method_54159((String)"skyblocker.config.general.backup.confirm.text", (Object[])new Object[]{selected.getFileName().toString()}), class_5244.field_24336, class_5244.field_24337));
            }
        }).method_46437(90, 20).method_46433(this.field_22789 / 2 - 95, this.field_22790 - 28).method_46431();
        this.method_37063((class_364)restoreBtn);
        class_4185 done = class_4185.method_46430((class_2561)class_5244.field_24334, b -> this.method_25419()).method_46437(90, 20).method_46433(this.field_22789 / 2 + 5, this.field_22790 - 28).method_46431();
        this.method_37063((class_364)done);
        class_7842 titleWidget = new class_7842(this.field_22785, this.field_22793);
        titleWidget.method_48229((this.field_22789 - this.field_22793.method_27525((class_5348)this.field_22785)) / 2, 12);
        this.method_37063((class_364)titleWidget);
    }

    public void method_25419() {
        assert (this.field_22787 != null);
        this.field_22787.method_1507(this.parent);
    }

    private class BackupListWidget
    extends class_4280<BackupEntry> {
        BackupListWidget(class_310 client, int width, int height, int y, int itemHeight) {
            super(client, width, height, y, itemHeight);
            this.updateEntries();
        }

        Path getSelectedPath() {
            BackupEntry entry = (BackupEntry)this.method_25334();
            return entry != null ? entry.path : null;
        }

        public void setSelected(@Nullable BackupEntry entry) {
            super.method_25313((class_350.class_351)entry);
            ConfigBackupScreen.this.detailsWidget.updateEntries(entry != null ? entry.path : null);
        }

        void updateEntries() {
            this.method_25339();
            try {
                List<Path> backups = ConfigBackupManager.listBackups();
                for (Path backup : backups) {
                    this.method_25321((class_350.class_351)new BackupEntry(backup));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        protected int method_65507() {
            return this.method_46426() + this.method_25368() - 6;
        }
    }

    private class SettingsListWidget
    extends class_4265<StringEntry> {
        SettingsListWidget(class_310 client, int width, int height, int y, int itemHeight) {
            super(client, width, height, y, itemHeight);
        }

        void updateEntries(@Nullable Path path) {
            this.method_25339();
            ConfigBackupScreen.this.changedPaths = Collections.emptySet();
            if (path == null) {
                return;
            }
            try {
                JsonElement backupJson = JsonParser.parseReader(Files.newBufferedReader(path));
                JsonElement currentJson = JsonParser.parseReader(Files.newBufferedReader(SkyblockerConfigManager.getConfigPath()));
                HashSet<String> diffs = new HashSet<String>();
                this.findDiffs("", backupJson, currentJson, diffs);
                ConfigBackupScreen.this.changedPaths = diffs;
                ArrayList<JsonLine> lines = new ArrayList<JsonLine>();
                this.formatJson(null, backupJson, "", 0, true, lines);
                for (JsonLine l : lines) {
                    this.method_25321((class_350.class_351)new StringEntry(l.text, l.path));
                }
            }
            catch (IOException e) {
                LOGGER.error("[Skyblocker] Error reading backup file for diff display", (Throwable)e);
            }
        }

        public int method_25322() {
            return this.method_25368() - 8 - 20;
        }

        private void findDiffs(String pathPrefix, JsonElement backup, JsonElement current, Set<String> diffs) {
            if (backup == null) {
                return;
            }
            if (!backup.equals(current)) {
                if (backup.isJsonObject() && current != null && current.isJsonObject()) {
                    for (Map.Entry<String, JsonElement> entry : backup.getAsJsonObject().entrySet()) {
                        String next = pathPrefix.isEmpty() ? entry.getKey() : pathPrefix + "." + entry.getKey();
                        this.findDiffs(next, entry.getValue(), current.getAsJsonObject().get(entry.getKey()), diffs);
                    }
                } else if (backup.isJsonArray() && current != null && current.isJsonArray()) {
                    for (int i = 0; i < backup.getAsJsonArray().size(); ++i) {
                        String next = pathPrefix + "[" + i + "]";
                        JsonElement curr = i < current.getAsJsonArray().size() ? current.getAsJsonArray().get(i) : null;
                        this.findDiffs(next, backup.getAsJsonArray().get(i), curr, diffs);
                    }
                } else {
                    diffs.add(pathPrefix);
                }
            }
        }

        private void formatJson(String key, JsonElement element, String path, int indent, boolean last, List<JsonLine> out) {
            String newPath;
            String ind = "  ".repeat(indent);
            String string = key == null ? path : (newPath = path.isEmpty() ? key : path + "." + key);
            if (element.isJsonObject()) {
                String line = key == null ? ind + "{" : ind + "\"" + key + "\": {";
                out.add(new JsonLine(line, null));
                Iterator<Map.Entry<String, JsonElement>> it = element.getAsJsonObject().entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, JsonElement> e = it.next();
                    this.formatJson(e.getKey(), e.getValue(), newPath, indent + 1, !it.hasNext(), out);
                }
                out.add(new JsonLine(ind + "}" + (last ? "" : ","), path.isEmpty() ? null : path));
            } else if (element.isJsonArray()) {
                String line = key == null ? ind + "[" : ind + "\"" + key + "\": [";
                out.add(new JsonLine(line, null));
                JsonArray arr = element.getAsJsonArray();
                for (int i = 0; i < arr.size(); ++i) {
                    this.formatJson(null, arr.get(i), newPath + "[" + i + "]", indent + 1, i == arr.size() - 1, out);
                }
                out.add(new JsonLine(ind + "]" + (last ? "" : ","), path));
            } else {
                String value = element.toString();
                String line = key == null ? ind + value : ind + "\"" + key + "\": " + value;
                out.add(new JsonLine(line + (last ? "" : ","), newPath));
            }
        }

        protected void method_44396(class_332 context, int mouseX, int mouseY) {
            super.method_44396(context, mouseX, mouseY);
            if (this.method_44392()) {
                int scrollBarX = this.method_65507();
                int listWidgetY = this.method_46427();
                int totalHeight = this.field_22759 + this.method_44390();
                int scrollbarThumbHeight = this.method_44394();
                for (int i = 0; i < this.method_25396().size(); ++i) {
                    StringEntry entry = (StringEntry)((Object)this.method_25396().get(i));
                    if (entry.path == null || !ConfigBackupScreen.this.changedPaths.contains(entry.path)) continue;
                    int entryY = 4 + i * this.field_62109 + this.method_46427();
                    int barY = entryY * (this.field_22759 - scrollbarThumbHeight - 2) / (totalHeight - this.field_62109) + listWidgetY + scrollbarThumbHeight / 2;
                    context.method_25294(scrollBarX, barY, scrollBarX + 6, barY + 2, -171);
                }
            }
        }

        private record JsonLine(String text, @Nullable String path) {
        }
    }

    private class StringEntry
    extends class_4265.class_4266<StringEntry> {
        private final String text;
        private final @Nullable String path;

        StringEntry(@Nullable String text, String path) {
            this.text = text;
            this.path = path;
        }

        public List<class_364> method_25396() {
            return List.of();
        }

        public List<class_6379> method_37025() {
            return List.of();
        }

        public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
            int color = -1;
            if (this.path != null && ConfigBackupScreen.this.changedPaths.contains(this.path)) {
                color = -171;
            }
            context.method_51433(ConfigBackupScreen.this.field_22793, this.text, this.method_46426() + 2, this.method_46427() + 2, color, false);
        }
    }

    private class BackupEntry
    extends class_4280.class_4281<BackupEntry> {
        private final Path path;

        BackupEntry(Path path) {
            this.path = path;
        }

        public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
            context.method_25300(ConfigBackupScreen.this.field_22793, this.path.getFileName().toString(), this.method_73388(), this.method_46427() + 7, -1);
            if (this.method_25405(mouseX, mouseY)) {
                context.method_74037(class_11876.field_62455);
            }
        }

        public class_2561 method_37006() {
            return class_2561.method_43473();
        }
    }
}

