/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.config.datafixer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.DataFixerBuilder;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.hysky.skyblocker.config.datafixer.ConfigFix1;
import de.hysky.skyblocker.config.datafixer.ConfigFix2QuickNav;
import de.hysky.skyblocker.config.datafixer.ConfigFix3AnimatedDyeAndItemBackground;
import de.hysky.skyblocker.config.datafixer.ConfigFix4ChatRulesObject;
import de.hysky.skyblocker.config.datafixer.ConfigFix5ChatRulesSeparateOutputs;
import de.hysky.skyblocker.config.datafixer.ConfigSchema;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class ConfigDataFixer {
    static final String VERSION_KEY = "version";
    protected static final Logger LOGGER = LogUtils.getLogger();
    public static final DSL.TypeReference CONFIG_TYPE = () -> "config";
    public static final DSL.TypeReference CHAT_RULES_TYPE = () -> "chat_rules";
    private static @Nullable DataFixer dataFixer;

    public static JsonObject apply(DSL.TypeReference type, JsonObject oldConfig) {
        return ConfigDataFixer.apply(type, oldConfig, 6);
    }

    public static <T> Dynamic<T> apply(DSL.TypeReference type, Dynamic<T> oldConfig) {
        return ConfigDataFixer.apply(type, oldConfig, 6);
    }

    public static <T> Dynamic<T> apply(DSL.TypeReference type, Dynamic<T> oldConfig, int newVersion) {
        long start = System.currentTimeMillis();
        Dynamic newConfig = ConfigDataFixer.build().update(type, oldConfig, oldConfig.get(VERSION_KEY).asInt(1), newVersion);
        long end = System.currentTimeMillis();
        LOGGER.info("[Skyblocker Config Data Fixer] Applied {} datafixers in {} ms!", (Object)type.typeName(), (Object)(end - start));
        return newConfig;
    }

    public static JsonObject apply(DSL.TypeReference type, JsonObject oldConfig, int newVersion) {
        return ((JsonElement)ConfigDataFixer.apply(type, new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)oldConfig), newVersion).getValue()).getAsJsonObject();
    }

    private static DataFixer build() {
        if (dataFixer != null) {
            return dataFixer;
        }
        DataFixerBuilder builder = new DataFixerBuilder(6);
        builder.addSchema(1, ConfigSchema::new);
        Schema schema2 = builder.addSchema(2, Schema::new);
        builder.addFixer((DataFix)new ConfigFix1(schema2, true));
        Schema schema3 = builder.addSchema(3, Schema::new);
        builder.addFixer((DataFix)new ConfigFix2QuickNav(schema3, true));
        Schema schema4 = builder.addSchema(4, Schema::new);
        builder.addFixer((DataFix)new ConfigFix3AnimatedDyeAndItemBackground(schema4, true));
        Schema schema5 = builder.addSchema(5, Schema::new);
        builder.addFixer((DataFix)new ConfigFix4ChatRulesObject(schema5, true));
        Schema schema6 = builder.addSchema(6, Schema::new);
        builder.addFixer((DataFix)new ConfigFix5ChatRulesSeparateOutputs(schema6, true));
        dataFixer = builder.build().fixer();
        return dataFixer;
    }

    public static <A> Codec<A> createDataFixingCodec(final DSL.TypeReference type, final Codec<A> baseCodec) {
        return new Codec<A>(){

            public <T> DataResult<T> encode(A input, DynamicOps<T> ops, T prefix) {
                return baseCodec.encode(input, ops, prefix);
            }

            public <T> DataResult<Pair<A, T>> decode(DynamicOps<T> ops, T input) {
                Dynamic dynamic2 = ConfigDataFixer.apply(type, new Dynamic(ops, input));
                return baseCodec.decode(dynamic2);
            }
        };
    }
}

