/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.events;

import de.hysky.skyblocker.skyblock.dungeon.secrets.Room;
import de.hysky.skyblocker.skyblock.dungeon.secrets.SecretWaypoint;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;

public class DungeonEvents {
    public static final Event<DungeonLoaded> DUNGEON_LOADED = EventFactory.createArrayBacked(DungeonLoaded.class, callbacks -> () -> {
        for (DungeonLoaded callback : callbacks) {
            callback.onDungeonLoaded();
        }
    });
    public static final Event<DungeonStarted> DUNGEON_STARTED = EventFactory.createArrayBacked(DungeonStarted.class, callbacks -> () -> {
        for (DungeonStarted callback : callbacks) {
            callback.onDungeonStarted();
        }
    });
    public static final Event<DungeonEnded> DUNGEON_ENDED = EventFactory.createArrayBacked(DungeonEnded.class, callbacks -> () -> {
        for (DungeonEnded callback : callbacks) {
            callback.onDungeonEnded();
        }
    });
    public static final Event<RoomMatched> PUZZLE_MATCHED = EventFactory.createArrayBacked(RoomMatched.class, callbacks -> room -> {
        for (RoomMatched callback : callbacks) {
            callback.onRoomMatched(room);
        }
    });
    public static final Event<RoomMatched> ROOM_MATCHED = EventFactory.createArrayBacked(RoomMatched.class, callbacks -> room -> {
        for (RoomMatched callback : callbacks) {
            callback.onRoomMatched(room);
        }
        if (room.getType() == Room.Type.PUZZLE) {
            ((RoomMatched)PUZZLE_MATCHED.invoker()).onRoomMatched(room);
        }
    });
    public static final Event<SecretFound> SECRET_FOUND = EventFactory.createArrayBacked(SecretFound.class, callbacks -> (room, secretWaypoint) -> {
        for (SecretFound callback : callbacks) {
            callback.onSecretFound(room, secretWaypoint);
        }
    });
    public static final Event<SecretCountUpdate> SECRET_COUNT_UPDATED = EventFactory.createArrayBacked(SecretCountUpdate.class, callbacks -> (room, fromWS) -> {
        for (SecretCountUpdate callback : callbacks) {
            callback.onSecretCountUpdate(room, fromWS);
        }
    });

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface SecretCountUpdate {
        public void onSecretCountUpdate(Room var1, boolean var2);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface SecretFound {
        public void onSecretFound(Room var1, SecretWaypoint var2);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface RoomMatched {
        public void onRoomMatched(Room var1);
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface DungeonEnded {
        public void onDungeonEnded();
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface DungeonStarted {
        public void onDungeonStarted();
    }

    @FunctionalInterface
    @Environment(value=EnvType.CLIENT)
    public static interface DungeonLoaded {
        public void onDungeonLoaded();
    }
}

