/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.mixins;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.datafixers.util.Either;
import de.hysky.skyblocker.config.SkyblockerConfig;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.InventorySearch;
import de.hysky.skyblocker.skyblock.PetCache;
import de.hysky.skyblocker.skyblock.experiment.UltrasequencerSolver;
import de.hysky.skyblocker.skyblock.garden.visitor.VisitorHelper;
import de.hysky.skyblocker.skyblock.item.ItemPrice;
import de.hysky.skyblocker.skyblock.item.ItemProtection;
import de.hysky.skyblocker.skyblock.item.background.ItemBackgroundManager;
import de.hysky.skyblocker.skyblock.item.slottext.SlotTextManager;
import de.hysky.skyblocker.skyblock.item.tooltip.BackpackPreview;
import de.hysky.skyblocker.skyblock.item.tooltip.CompactorDeletorPreview;
import de.hysky.skyblocker.skyblock.item.wikilookup.WikiLookupManager;
import de.hysky.skyblocker.skyblock.museum.MuseumItemCache;
import de.hysky.skyblocker.skyblock.museum.MuseumManager;
import de.hysky.skyblocker.skyblock.quicknav.QuickNav;
import de.hysky.skyblocker.skyblock.quicknav.QuickNavButton;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.container.ContainerSolver;
import de.hysky.skyblocker.utils.container.ContainerSolverManager;
import de.hysky.skyblocker.utils.container.StackDisplayModifier;
import de.hysky.skyblocker.utils.render.HudHelper;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_10799;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_5632;
import org.jspecify.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_465.class})
public abstract class AbstractContainerScreenMixin<T extends class_1703>
extends class_437 {
    @Unique
    private static final class_2960 GENERIC_CONTAINER_TEXTURE = class_2960.method_60656((String)"textures/gui/container/generic_54.png");
    @Unique
    private static final int OUT_OF_BOUNDS_SLOT = -999;
    @Unique
    private static final Set<String> FILLER_ITEMS = Set.of(" ", "Locked Page", "Quick Crafting Slot", "Locked Backpack Slot 2", "Locked Backpack Slot 3", "Locked Backpack Slot 4", "Locked Backpack Slot 5", "Locked Backpack Slot 6", "Locked Backpack Slot 7", "Locked Backpack Slot 8", "Locked Backpack Slot 9", "Locked Backpack Slot 10", "Locked Backpack Slot 11", "Locked Backpack Slot 12", "Locked Backpack Slot 13", "Locked Backpack Slot 14", "Locked Backpack Slot 15", "Locked Backpack Slot 16", "Locked Backpack Slot 17", "Locked Backpack Slot 18", "Preparing");
    @Shadow
    protected @Nullable class_1735 field_2787;
    @Shadow
    @Final
    protected T field_2797;
    @Shadow
    protected int field_2776;
    @Shadow
    protected int field_2800;
    @Shadow
    protected int field_2792;
    @Unique
    private List<QuickNavButton> quickNavButtons;

    @Shadow
    protected abstract List<class_2561> method_51454(class_1799 var1);

    protected AbstractContainerScreenMixin(class_2561 title) {
        super(title);
    }

    @Inject(method={"method_25426"}, at={@At(value="RETURN")})
    private void skyblocker$initQuickNav(CallbackInfo ci) {
        if (Utils.isOnSkyblock() && SkyblockerConfigManager.get().quickNav.enableQuickNav && this.field_22787 != null && this.field_22787.field_1724 != null && !this.field_22787.field_1724.method_68878()) {
            this.quickNavButtons = QuickNav.init(this.method_25440().getString().trim());
            for (QuickNavButton quickNavButton : this.quickNavButtons) {
                this.method_25429((class_364)quickNavButton);
            }
        }
    }

    @Inject(method={"method_25426"}, at={@At(value="TAIL")})
    private void skyblocker$initMuseumOverlay(CallbackInfo ci) {
        if (Utils.isOnSkyblock() && SkyblockerConfigManager.get().uiAndVisuals.museumOverlay && this.field_22787 != null && this.field_22787.field_1724 != null && this.method_25440().getString().contains("Museum")) {
            int inventoryX = (this.field_22789 - this.field_2792) / 2;
            int spacing = 2;
            int overlayWidth = 147;
            if (inventoryX + this.field_2792 + spacing + overlayWidth > this.field_22789 && (inventoryX = this.field_22789 - (this.field_2792 + overlayWidth + spacing)) < 0) {
                inventoryX = 0;
            }
            this.field_2776 = inventoryX;
            new MuseumManager(this, this.field_2776, this.field_2800, this.field_2792);
        }
    }

    @WrapOperation(method={"method_25420"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_465;method_2389(Lnet/minecraft/class_332;FII)V")})
    private void skyblocker$DrawMuseumOverlayBackground(class_465<?> instance, class_332 context, float delta, int mouseX, int mouseY, Operation<Void> original) {
        if (Utils.isOnSkyblock() && SkyblockerConfigManager.get().uiAndVisuals.museumOverlay && this.field_22787 != null && this.field_22787.field_1724 != null && this.method_25440().getString().contains("Museum")) {
            int rows = 6;
            context.method_25290(class_10799.field_56883, GENERIC_CONTAINER_TEXTURE, this.field_2776, this.field_2800, 0.0f, 0.0f, this.field_2792, rows * 18 + 17, 256, 256);
            context.method_25290(class_10799.field_56883, GENERIC_CONTAINER_TEXTURE, this.field_2776, this.field_2800 + rows * 18 + 17, 0.0f, 126.0f, this.field_2792, 96, 256, 256);
        } else {
            original.call(new Object[]{instance, context, Float.valueOf(delta), mouseX, mouseY});
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"method_25404"})
    public void skyblocker$keyPressed(class_11908 input, CallbackInfoReturnable<Boolean> cir) {
        if (this.field_22787 != null && this.field_22787.field_1724 != null && this.field_2787 != null && !input.method_74231() && !this.field_22787.field_1690.field_1822.method_1417(input) && Utils.isOnSkyblock()) {
            SkyblockerConfig config = SkyblockerConfigManager.get();
            WikiLookupManager.handleWikiLookup(this.method_25440().getString(), (Either<class_1735, class_1799>)Either.left((Object)this.field_2787), (class_1657)this.field_22787.field_1724, input);
            if (ItemProtection.itemProtection.method_1417(input)) {
                ItemProtection.handleKeyPressed(this.field_2787.method_7677());
            }
            if (config.helpers.itemPrice.enableItemPriceLookup && ItemPrice.ITEM_PRICE_LOOKUP.method_1417(input)) {
                ItemPrice.itemPriceLookup(this.field_22787.field_1724, this.field_2787);
            }
        }
    }

    @ModifyExpressionValue(method={"method_25402"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_437;method_25402(Lnet/minecraft/class_11909;Z)Z")})
    public boolean skyblocker$passThroughSearchFieldUnfocusedClicks(boolean superClicked, class_11909 click, boolean doubled) {
        if (!superClicked) {
            Optional<class_339> searchField = Screens.getButtons((class_437)this).stream().filter(InventorySearch.SearchTextFieldWidget.class::isInstance).findFirst();
            if (searchField.isPresent() && searchField.get().method_25402(click, doubled)) {
                return true;
            }
        }
        return superClicked;
    }

    @Inject(method={"method_25420"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_465;method_2389(Lnet/minecraft/class_332;FII)V")})
    private void skyblocker$drawUnselectedQuickNavButtons(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if (this.quickNavButtons != null) {
            for (QuickNavButton quickNavButton : this.quickNavButtons) {
                if (quickNavButton.toggled() && !(quickNavButton.method_75798() < 255.0f)) continue;
                quickNavButton.setRenderInFront(false);
                quickNavButton.method_25394(context, mouseX, mouseY, delta);
            }
        }
    }

    @Inject(method={"method_25420"}, at={@At(value="RETURN")})
    private void skyblocker$drawSelectedQuickNavButtons(class_332 context, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if (this.quickNavButtons != null) {
            for (QuickNavButton quickNavButton : this.quickNavButtons) {
                if (!quickNavButton.toggled()) continue;
                quickNavButton.setRenderInFront(true);
                quickNavButton.method_25394(context, mouseX, mouseY, delta);
            }
        }
    }

    @Inject(method={"method_2380"}, at={@At(value="HEAD")})
    private void skyblocker$beforeTooltipDrawn(CallbackInfo ci, @Local(argsOnly=true) class_332 context) {
        ContainerSolverManager.onDraw(context, (class_465<class_1707>)((class_465)this), (List<class_1735>)((class_1703)this.field_2797).field_7761);
    }

    @WrapOperation(method={"method_2380"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_332;method_51437(Lnet/minecraft/class_327;Ljava/util/List;Ljava/util/Optional;IILnet/minecraft/class_2960;)V")})
    private void skyblocker$drawMouseOverTooltip(class_332 context, class_327 textRenderer, List<class_2561> text, Optional<class_5632> data, int x, int y, class_2960 texture, Operation<Void> original, @Local(ordinal=0) class_1799 stack) {
        Matcher matcher;
        if (ContainerSolverManager.getCurrentSolver() instanceof StackDisplayModifier && stack.method_7960()) {
            return;
        }
        if (!Utils.isOnSkyblock() || text.isEmpty()) {
            original.call(new Object[]{context, textRenderer, text, data, x, y, texture});
            return;
        }
        String name = text.getFirst().getString();
        if (SkyblockerConfigManager.get().uiAndVisuals.hideEmptyTooltips && name.isBlank()) {
            return;
        }
        boolean shiftDown = SkyblockerConfigManager.get().uiAndVisuals.backpackPreviewWithoutShift ^ HudHelper.hasShiftDown();
        if (shiftDown && this.method_25440().getString().equals("Storage") && this.field_2787.field_7871 != this.field_22787.field_1724.method_31548() && BackpackPreview.renderPreview(context, this, this.field_2787.method_34266(), x, y)) {
            return;
        }
        if (SkyblockerConfigManager.get().uiAndVisuals.compactorDeletorPreview && (matcher = CompactorDeletorPreview.NAME.matcher(stack.getSkyblockId())).matches() && CompactorDeletorPreview.drawPreview(context, stack, this.method_51454(stack), matcher.group("type"), matcher.group("size"), x, y)) {
            return;
        }
        original.call(new Object[]{context, textRenderer, text, data, x, y, texture});
    }

    @ModifyVariable(method={"method_2380"}, at=@At(value="STORE"))
    private class_1799 skyblocker$modifyTooltipDisplayStack(class_1799 stack) {
        return this.skyblocker$modifyDisplayStack(this.field_2787, stack, ContainerSolverManager.getCurrentSolver());
    }

    @ModifyVariable(method={"method_2385"}, at=@At(value="LOAD", ordinal=3), ordinal=0)
    private class_1799 skyblocker$modifyDisplayStack(class_1799 stack, @Local(argsOnly=true) class_1735 slot) {
        return this.skyblocker$modifyDisplayStack(slot, stack, ContainerSolverManager.getCurrentSolver());
    }

    @Unique
    private class_1799 skyblocker$modifyDisplayStack(class_1735 slot, class_1799 stack, ContainerSolver solver) {
        if (solver instanceof StackDisplayModifier) {
            StackDisplayModifier modifier = (StackDisplayModifier)((Object)solver);
            if (solver.isSolverSlot(slot, this)) {
                return modifier.modifyDisplayStack(slot.method_34266(), stack);
            }
        }
        return stack;
    }

    @Inject(method={"method_2383(Lnet/minecraft/class_1735;IILnet/minecraft/class_1713;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_636;method_2906(IIILnet/minecraft/class_1713;Lnet/minecraft/class_1657;)V")}, cancellable=true)
    private void skyblocker$onSlotClick(class_1735 slot, int slotId, int button, class_1713 actionType, CallbackInfo ci) {
        boolean disallowed;
        boolean isInAuctionGUI;
        String lore;
        if (!Utils.isOnSkyblock()) {
            return;
        }
        if (slotId == -999 && ItemProtection.isItemProtected(this.field_2797.method_34255())) {
            ci.cancel();
            return;
        }
        if (slot == null) {
            return;
        }
        String title = this.method_25440().getString();
        ContainerSolver currentSolver = ContainerSolverManager.getCurrentSolver();
        class_1799 stack = this.skyblocker$modifyDisplayStack(slot, slot.method_7677(), currentSolver);
        boolean isTitleEmptyOrFiller = FILLER_ITEMS.contains(stack.method_7964().getString());
        if (isTitleEmptyOrFiller) {
            List<String> tooltip = stack.method_7950(class_1792.class_9635.field_51353, (class_1657)class_310.method_1551().field_1724, (class_1836)class_1836.field_41070).stream().map(class_2561::getString).toList();
            lore = String.join((CharSequence)"\n", tooltip);
            boolean bl = isTitleEmptyOrFiller = lore.isBlank() || FILLER_ITEMS.contains(tooltip.getFirst());
        }
        if (SkyblockerConfigManager.get().uiAndVisuals.hideEmptyTooltips && isTitleEmptyOrFiller && (!UltrasequencerSolver.INSTANCE.test(title) || SkyblockerConfigManager.get().helpers.experiments.enableUltrasequencerSolver)) {
            ci.cancel();
            return;
        }
        if (actionType == class_1713.field_7795 && ItemProtection.isItemProtected(stack)) {
            ci.cancel();
            return;
        }
        if (title.equals("Salvage Items") && ItemProtection.isItemProtected(stack)) {
            ci.cancel();
            return;
        }
        if (title.startsWith("You  ") && ItemProtection.isItemProtected(stack)) {
            ci.cancel();
            return;
        }
        boolean bl = isInAuctionGUI = title.endsWith("Auction House") || title.equals("Create Auction") || title.equals("Create BIN Auction");
        if (isInAuctionGUI && ItemProtection.isItemProtected(stack)) {
            ci.cancel();
            return;
        }
        lore = this.field_2797;
        int n = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_1707.class, class_1707.class}, (Object)lore, n)) {
                case 0: {
                    class_1707 genericContainerScreenHandler = (class_1707)lore;
                    if (genericContainerScreenHandler.method_17388() != 6) {
                        n = 1;
                        continue block4;
                    }
                    VisitorHelper.onSlotClick(slot, slotId, title, genericContainerScreenHandler.method_7611(13));
                    class_1799 sellStack = ((class_1735)((class_1703)this.field_2797).field_7761.get(49)).method_7677();
                    if (!sellStack.method_7964().getString().equals("Sell Item") && ItemUtils.getLoreLineIf(sellStack, text -> text.contains("buyback")) == null || slotId == 49 || !ItemProtection.isItemProtected(stack)) break block4;
                    ci.cancel();
                    return;
                }
                case 1: {
                    class_1707 genericContainerScreenHandler = (class_1707)lore;
                    if (!title.equals("Confirm Donation")) {
                        n = 2;
                        continue block4;
                    }
                    MuseumItemCache.handleClick(slot, slotId, (class_2371<class_1735>)genericContainerScreenHandler.field_7761);
                    break block4;
                }
            }
            break;
        }
        if (button == 0 && title.startsWith("Pets")) {
            PetCache.handlePetEquip(slot, slotId);
        }
        if (currentSolver != null && (disallowed = ContainerSolverManager.onSlotClick(slotId, stack, button))) {
            ci.cancel();
        }
    }

    @Inject(method={"method_2385"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_332;method_51428(Lnet/minecraft/class_1799;III)V")})
    private void skyblocker$drawOnItem(CallbackInfo ci, @Local(argsOnly=true) class_332 context, @Local(argsOnly=true) class_1735 slot) {
        if (Utils.isOnSkyblock()) {
            ItemBackgroundManager.drawBackgrounds(slot.method_7677(), context, slot.field_7873, slot.field_7872);
        }
        if (ItemProtection.isItemProtected(slot.method_7677())) {
            context.method_25290(class_10799.field_56883, ItemProtection.ITEM_PROTECTION_TEX, slot.field_7873, slot.field_7872, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        if (InventorySearch.isSearching() && !InventorySearch.slotMatches(slot)) {
            context.method_25294(slot.field_7873, slot.field_7872, slot.field_7873 + 16, slot.field_7872 + 16, -2013265920);
        }
    }

    @Inject(method={"method_2385"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_332;method_51432(Lnet/minecraft/class_327;Lnet/minecraft/class_1799;IILjava/lang/String;)V")})
    private void skyblocker$drawSlotText(CallbackInfo ci, @Local(argsOnly=true) class_332 context, @Local(argsOnly=true) class_1735 slot) {
        if (Utils.isOnSkyblock()) {
            SlotTextManager.renderSlotText(context, this.field_22793, slot);
        }
    }
}

