/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.mixins;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.config.configs.UIAndVisualsConfig;
import de.hysky.skyblocker.events.ParticleEvents;
import de.hysky.skyblocker.events.PlaySoundEvents;
import de.hysky.skyblocker.skyblock.CompactDamage;
import de.hysky.skyblocker.skyblock.HealthBars;
import de.hysky.skyblocker.skyblock.dungeon.DungeonMapTexture;
import de.hysky.skyblocker.skyblock.dungeon.DungeonScore;
import de.hysky.skyblocker.skyblock.dungeon.puzzle.TeleportMaze;
import de.hysky.skyblocker.skyblock.dungeon.secrets.DungeonManager;
import de.hysky.skyblocker.skyblock.dwarven.CorpseFinder;
import de.hysky.skyblocker.skyblock.end.TheEnd;
import de.hysky.skyblocker.skyblock.fishing.FishingHelper;
import de.hysky.skyblocker.skyblock.fishing.FishingHookDisplayHelper;
import de.hysky.skyblocker.skyblock.fishing.SeaCreatureTracker;
import de.hysky.skyblocker.skyblock.galatea.TreeBreakProgressHud;
import de.hysky.skyblocker.skyblock.hunting.LassoHud;
import de.hysky.skyblocker.skyblock.slayers.SlayerManager;
import de.hysky.skyblocker.skyblock.slayers.boss.demonlord.FirePillarAnnouncer;
import de.hysky.skyblocker.skyblock.tabhud.util.PlayerListManager;
import de.hysky.skyblocker.skyblock.teleport.PredictiveSmoothAOTE;
import de.hysky.skyblocker.skyblock.teleport.ResponsiveSmoothAOTE;
import de.hysky.skyblocker.utils.Utils;
import net.minecraft.class_1297;
import net.minecraft.class_1531;
import net.minecraft.class_1542;
import net.minecraft.class_2338;
import net.minecraft.class_2535;
import net.minecraft.class_2663;
import net.minecraft.class_2675;
import net.minecraft.class_2683;
import net.minecraft.class_2708;
import net.minecraft.class_2739;
import net.minecraft.class_2740;
import net.minecraft.class_2744;
import net.minecraft.class_2767;
import net.minecraft.class_2772;
import net.minecraft.class_2775;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_8673;
import net.minecraft.class_8675;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_634.class})
public abstract class ClientPacketListenerMixin
extends class_8673 {
    @Shadow
    @Final
    private static Logger field_3695;

    protected ClientPacketListenerMixin(class_310 client, class_2535 connection, class_8675 connectionState) {
        super(client, connection, connectionState);
    }

    @Inject(method={"method_11093"}, at={@At(value="TAIL")})
    private void skyblocker$onEntityTrackerUpdate(class_2739 packet, CallbackInfo ci, @Local class_1297 entity) {
        if (!(entity instanceof class_1531)) {
            return;
        }
        class_1531 armorStandEntity = (class_1531)entity;
        SlayerManager.checkSlayerBoss(armorStandEntity);
        FirePillarAnnouncer.checkFirePillar(entity);
        CorpseFinder.checkIfCorpse(armorStandEntity);
        HealthBars.healthBar(armorStandEntity);
        SeaCreatureTracker.onEntitySpawn(armorStandEntity);
        FishingHelper.checkIfFishWasCaught(armorStandEntity);
        TreeBreakProgressHud.onEntityUpdate(armorStandEntity);
        LassoHud.onEntityUpdate(armorStandEntity);
        try {
            CompactDamage.compactDamage(armorStandEntity);
        }
        catch (Exception e) {
            field_3695.error("[Skyblocker Compact Damage] Failed to compact damage number", (Throwable)e);
        }
        FishingHookDisplayHelper.onArmorStandSpawn(armorStandEntity);
    }

    @Inject(method={"method_11110"}, at={@At(value="TAIL")})
    private void skyblocker$onEntityAttach(class_2740 packet, CallbackInfo ci) {
        LassoHud.onEntityAttach(packet);
    }

    @Inject(method={"method_11157"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_2600;method_11074(Lnet/minecraft/class_2596;Lnet/minecraft/class_2547;Lnet/minecraft/class_11980;)V", shift=At.Shift.AFTER)})
    private void skyblocker$beforeTeleport(class_2708 packet, CallbackInfo ci, @Share(value="playerBeforeTeleportBlockPos") LocalRef<class_2338> beforeTeleport) {
        beforeTeleport.set((Object)this.field_45588.field_1724.method_24515().method_10062());
        ResponsiveSmoothAOTE.playerGoingToTeleport();
    }

    @Inject(method={"method_11157"}, at={@At(value="RETURN")})
    private void skyblocker$onTeleport(class_2708 packet, CallbackInfo ci, @Share(value="playerBeforeTeleportBlockPos") LocalRef<class_2338> beforeTeleport) {
        PredictiveSmoothAOTE.playerTeleported();
        TeleportMaze.INSTANCE.onTeleport(this.field_45588, (class_2338)beforeTeleport.get(), this.field_45588.field_1724.method_24515().method_10062());
    }

    @Inject(method={"method_11150"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_1542;method_6983()Lnet/minecraft/class_1799;")})
    private void skyblocker$onItemPickup(class_2775 packet, CallbackInfo ci, @Local class_1542 itemEntity) {
        DungeonManager.onItemPickup(itemEntity);
    }

    @WrapWithCondition(method={"method_11080"}, at={@At(value="INVOKE", target="Lorg/slf4j/Logger;warn(Ljava/lang/String;)V")})
    private boolean skyblocker$cancelEntityPassengersWarning(Logger instance, String msg) {
        return !Utils.isOnHypixel();
    }

    @ModifyExpressionValue(method={"method_11148"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_2663;method_11469(Lnet/minecraft/class_1937;)Lnet/minecraft/class_1297;")})
    private class_1297 skyblocker$onEntityDeath(class_1297 entity, @Local(argsOnly=true) class_2663 packet) {
        if (packet.method_11470() == 3) {
            DungeonScore.handleEntityDeath(entity);
            TheEnd.onEntityDeath(entity);
        }
        return entity;
    }

    @Inject(method={"method_11151"}, at={@At(value="TAIL")})
    private void skyblocker$onEntityEquip(class_2744 packet, CallbackInfo ci, @Local class_1297 entity) {
        CorpseFinder.checkIfCorpse(entity);
    }

    @Inject(method={"method_11105"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_355;method_1924(Lnet/minecraft/class_2561;)V")})
    private void skyblocker$updatePlayerListFooter(class_2772 packet, CallbackInfo ci) {
        PlayerListManager.updateFooter(packet.comp_2283());
    }

    @WrapWithCondition(method={"method_11113"}, at={@At(value="INVOKE", target="Lorg/slf4j/Logger;warn(Ljava/lang/String;Ljava/lang/Object;Ljava/lang/Object;)V")})
    private boolean skyblocker$cancelPlayerListWarning(Logger instance, String format, Object arg1, Object arg2) {
        return !Utils.isOnHypixel();
    }

    @Inject(method={"method_11146"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_2600;method_11074(Lnet/minecraft/class_2596;Lnet/minecraft/class_2547;Lnet/minecraft/class_11980;)V", shift=At.Shift.AFTER)})
    private void skyblocker$onPlaySound(class_2767 packet, CallbackInfo ci) {
        ((PlaySoundEvents.FromServer)PlaySoundEvents.FROM_SERVER.invoker()).onPlaySoundFromServer(packet);
    }

    @WrapWithCondition(method={"method_52801"}, at={@At(value="INVOKE", target="Lorg/slf4j/Logger;warn(Ljava/lang/String;Ljava/lang/Object;)V")})
    private boolean skyblocker$dropBadlionPacketWarnings(Logger instance, String message, Object identifier) {
        return !Utils.isOnHypixel() || !((class_2960)identifier).method_12836().equals("badlion");
    }

    @WrapWithCondition(method={"method_11118", "method_55450"}, at={@At(value="INVOKE", target="Lorg/slf4j/Logger;warn(Ljava/lang/String;Ljava/lang/Object;)V")}, require=2)
    private boolean skyblocker$cancelUnknownScoreboardObjectiveWarnings(Logger instance, String message, Object objectiveName) {
        return !Utils.isOnHypixel();
    }

    @WrapWithCondition(method={"method_11099"}, at={@At(value="INVOKE", target="Lorg/slf4j/Logger;warn(Ljava/lang/String;[Ljava/lang/Object;)V")})
    private boolean skyblocker$cancelTeamWarning(Logger instance, String format, Object ... arg) {
        return !Utils.isOnHypixel();
    }

    @Inject(method={"method_11077"}, at={@At(value="RETURN")})
    private void skyblocker$onParticle(class_2675 packet, CallbackInfo ci) {
        ((ParticleEvents.FromServer)ParticleEvents.FROM_SERVER.invoker()).onParticleFromServer(packet);
    }

    @Inject(method={"method_11088"}, at={@At(value="RETURN")})
    private void skyblocker$onMapItemData(class_2683 packet, CallbackInfo ci) {
        DungeonMapTexture.onMapItemDataUpdate(packet.comp_2270(), packet.comp_2274().isPresent());
    }

    @ModifyExpressionValue(method={"method_18784"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_340;method_53538()Z")})
    private boolean shouldShowPacketSizeAndPingCharts(boolean original) {
        UIAndVisualsConfig.SmoothAOTE options = SkyblockerConfigManager.get().uiAndVisuals.smoothAOTE;
        if (Utils.isOnSkyblock() && options.predictive && !PredictiveSmoothAOTE.teleportDisabled && (options.enableWeirdTransmission || options.enableEtherTransmission || options.enableInstantTransmission || options.enableSinrecallTransmission || options.enableWitherImpact)) {
            return true;
        }
        return original;
    }
}

