/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.mixins;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.injected.SkyblockerStack;
import de.hysky.skyblocker.skyblock.item.PetInfo;
import de.hysky.skyblocker.skyblock.item.SkyblockItemRarity;
import de.hysky.skyblocker.skyblock.profileviewer.ProfileViewerScreen;
import de.hysky.skyblocker.utils.ItemAbility;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.OkLabColor;
import de.hysky.skyblocker.utils.Utils;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_9299;
import net.minecraft.class_9304;
import net.minecraft.class_9322;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import org.jspecify.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1799.class})
public abstract class ItemStackMixin
implements class_9322,
SkyblockerStack {
    @Unique
    private float durabilityBarFill = -1.0f;
    @Unique
    private @Nullable String skyblockId;
    @Unique
    private @Nullable String skyblockApiId;
    @Unique
    private @Nullable String neuName;
    @Unique
    private @Nullable String uuid;
    @Unique
    private @Nullable List<String> loreString;
    @Unique
    private @Nullable List<ItemAbility> abilities;
    @Unique
    private @Nullable PetInfo petInfo;
    @Unique
    private @Nullable SkyblockItemRarity skyblockRarity;

    @ModifyReturnValue(method={"method_7964"}, at={@At(value="RETURN")})
    private class_2561 skyblocker$customItemNames(class_2561 original) {
        if (Utils.isOnSkyblock()) {
            return (class_2561)SkyblockerConfigManager.get().general.customItemNames.getOrDefault((Object)this.getUuid(), (Object)original);
        }
        return original;
    }

    @ModifyExpressionValue(method={"method_57369"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_10712;method_67214(Lnet/minecraft/class_9331;)Z")})
    private boolean skyblocker$hideVanillaEnchants(boolean shouldDisplay, @Local class_9299 component) {
        return shouldDisplay && (!Utils.isOnSkyblock() || !(component instanceof class_9304));
    }

    @Inject(method={"method_67194"}, slice={@Slice(from=@At(value="INVOKE", target="Lnet/minecraft/class_7922;method_10221(Ljava/lang/Object;)Lnet/minecraft/class_2960;"))}, at={@At(value="INVOKE", target="Ljava/util/function/Consumer;accept(Ljava/lang/Object;)V", shift=At.Shift.AFTER, ordinal=0)})
    private void skyblocker$skyblockIdTooltip(CallbackInfo ci, @Local(argsOnly=true) Consumer<class_2561> textConsumer) {
        String skyblockId;
        if (Utils.isOnSkyblock() && !(skyblockId = this.getSkyblockId()).isEmpty()) {
            textConsumer.accept((class_2561)class_2561.method_43470((String)("skyblock:" + skyblockId)).method_27692(class_124.field_1063));
        }
    }

    @Inject(method={"method_7917"}, at={@At(value="TAIL")})
    private void skyblocker$updateDamage(CallbackInfo ci) {
        this.skyblocker$getAndCacheDurability();
    }

    @ModifyReturnValue(method={"method_31578"}, at={@At(value="RETURN")})
    private boolean modifyItemBarVisible(boolean original) {
        return original || this.durabilityBarFill >= 0.0f;
    }

    @ModifyReturnValue(method={"method_31579"}, at={@At(value="RETURN")})
    private int modifyItemBarStep(int original) {
        return this.durabilityBarFill >= 0.0f ? (int)(this.durabilityBarFill * 13.0f) : original;
    }

    @ModifyReturnValue(method={"method_31580"}, at={@At(value="RETURN")})
    private int modifyItemBarColor(int original) {
        return this.durabilityBarFill >= 0.0f ? OkLabColor.interpolate(-65536, -16711936, this.durabilityBarFill) : original;
    }

    @Inject(method={"<init>(Lnet/minecraft/class_1935;ILnet/minecraft/class_9335;)V"}, at={@At(value="TAIL")})
    private void onInit(CallbackInfo ci) {
        this.skyblocker$getAndCacheDurability();
    }

    @Inject(method={"method_57379*"}, at={@At(value="TAIL")})
    private <T> void skyblocker$resetFields(class_9331<T> type, @Nullable T value, CallbackInfoReturnable<T> cir) {
        if (type == class_9334.field_49628) {
            this.uuid = null;
            this.skyblockId = null;
            this.skyblockApiId = null;
            this.neuName = null;
            this.petInfo = null;
        }
        if (type == class_9334.field_49632) {
            this.loreString = null;
            this.skyblockRarity = null;
            this.abilities = null;
        }
    }

    @Unique
    private boolean skyblocker$shouldProcess() {
        return (class_310.method_1551() == null || !(class_310.method_1551().field_1755 instanceof ProfileViewerScreen)) && Utils.isOnSkyblock() && SkyblockerConfigManager.get().mining.enableDrillFuel && ItemUtils.hasCustomDurability((class_1799)this);
    }

    @Unique
    private void skyblocker$getAndCacheDurability() {
        if (!this.skyblocker$shouldProcess()) {
            this.durabilityBarFill = -1.0f;
            return;
        }
        IntIntPair durability = ItemUtils.getDurability((class_1799)this);
        if (durability == null) {
            this.durabilityBarFill = -1.0f;
            return;
        }
        this.durabilityBarFill = (float)durability.firstInt() / (float)durability.secondInt();
    }

    @Override
    public String getSkyblockId() {
        if (this.skyblockId != null && !this.skyblockId.isEmpty()) {
            return this.skyblockId;
        }
        this.skyblockId = ItemUtils.getItemId(this);
        return this.skyblockId;
    }

    @Override
    public String getSkyblockApiId() {
        if (this.skyblockApiId != null && !this.skyblockApiId.isEmpty()) {
            return this.skyblockApiId;
        }
        this.skyblockApiId = ItemUtils.getSkyblockApiId(this);
        return this.skyblockApiId;
    }

    @Override
    public String getNeuName() {
        if (this.neuName != null && !this.neuName.isEmpty()) {
            return this.neuName;
        }
        this.neuName = ItemUtils.getNeuId((class_1799)this);
        return this.neuName;
    }

    @Override
    public String getUuid() {
        if (this.uuid != null) {
            return this.uuid;
        }
        this.uuid = ItemUtils.getItemUuid(this);
        return this.uuid;
    }

    @Override
    public List<String> skyblocker$getLoreStrings() {
        if (this.loreString != null) {
            return this.loreString;
        }
        this.loreString = ItemUtils.getLore((class_1799)this).stream().map(class_2561::getString).toList();
        return this.loreString;
    }

    @Override
    public List<ItemAbility> skyblocker$getAbilities() {
        if (this.abilities != null) {
            return this.abilities;
        }
        this.abilities = ItemAbility.getAbilities((class_1799)this);
        return this.abilities;
    }

    @Override
    public PetInfo getPetInfo() {
        if (this.petInfo != null) {
            return this.petInfo;
        }
        this.petInfo = ItemUtils.getPetInfo((class_1799)this);
        return this.petInfo;
    }

    @Override
    public SkyblockItemRarity getSkyblockRarity() {
        if (this.skyblockRarity != null) {
            return this.skyblockRarity;
        }
        this.skyblockRarity = ItemUtils.getItemRarity((class_1799)this);
        return this.skyblockRarity;
    }
}

