/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.mixins;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.item.PlayerHeadHashCache;
import de.hysky.skyblocker.skyblock.profileviewer.ProfileViewerScreen;
import de.hysky.skyblocker.utils.Utils;
import java.awt.Color;
import java.util.Set;
import net.minecraft.class_1011;
import net.minecraft.class_10538;
import net.minecraft.class_310;
import net.minecraft.class_9848;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_10538.class})
public class SkinTextureDownloaderMixin {
    @Unique
    private static final Set<String> STRIP_DE_FACTO_TRANSPARENT_PIXELS = Set.of(PlayerHeadHashCache.getSkinHashFromBase64("ewogICJ0aW1lc3RhbXAiIDogMTcyMDA1MjQ5NzEwMiwKICAicHJvZmlsZUlkIiA6ICI3Mjc2ZThmYzVkNjE0ODNjYmMwN2IxYjIzNjI3MDA4ZSIsCiAgInByb2ZpbGVOYW1lIiA6ICJXYWJvV2ViaSIsCiAgInNpZ25hdHVyZVJlcXVpcmVkIiA6IHRydWUsCiAgInRleHR1cmVzIiA6IHsKICAgICJTS0lOIiA6IHsKICAgICAgInVybCIgOiAiaHR0cDovL3RleHR1cmVzLm1pbmVjcmFmdC5uZXQvdGV4dHVyZS80ZjNiOTFiNmFhNzEyNGYzMGVkNGFkMWIyYmIwMTJhODI5ODVhMzM2NDA1NTVlMThlNzkyZjk2YWY4ZjU4ZWM2IgogICAgfQogIH0KfQ=="), PlayerHeadHashCache.getSkinHashFromBase64("ewogICJ0aW1lc3RhbXAiIDogMTcyMDA1MjkyNzU1NywKICAicHJvZmlsZUlkIiA6ICIxNDU1MDNhNDRjZmI0NzcwYmM3NWNjMTRjYjUwMDE4NyIsCiAgInByb2ZpbGVOYW1lIiA6ICJMaWtlbHlFcmljIiwKICAic2lnbmF0dXJlUmVxdWlyZWQiIDogdHJ1ZSwKICAidGV4dHVyZXMiIDogewogICAgIlNLSU4iIDogewogICAgICAidXJsIiA6ICJodHRwOi8vdGV4dHVyZXMubWluZWNyYWZ0Lm5ldC90ZXh0dXJlLzQ5ODIxNDEwNjMxMTg2YzZmM2ZiYmFlNWYwZWY1Yjk0N2Y0NzVlYjMyMDI3YThhYWQwYTQ1NjUxMjU0N2MyMDkiLAogICAgICAibWV0YWRhdGEiIDogewogICAgICAgICJtb2RlbCIgOiAic2xpbSIKICAgICAgfQogICAgfQogIH0KfQ=="), PlayerHeadHashCache.getSkinHashFromBase64("ewogICJ0aW1lc3RhbXAiIDogMTcyMDA1MjU2MDkxNywKICAicHJvZmlsZUlkIiA6ICIyMDJiZWVlYWY4NTk0MmQ0ODI3NGJjNzYwM2VhYWZhZSIsCiAgInByb2ZpbGVOYW1lIiA6ICJSaWtvcjk4NiIsCiAgInNpZ25hdHVyZVJlcXVpcmVkIiA6IHRydWUsCiAgInRleHR1cmVzIiA6IHsKICAgICJTS0lOIiA6IHsKICAgICAgInVybCIgOiAiaHR0cDovL3RleHR1cmVzLm1pbmVjcmFmdC5uZXQvdGV4dHVyZS80MTYyMzAzYmNkZDc3MGFlYmU3ZmQxOWZhMjYzNzEzOTBhNzUxNTE0MDM1ODU0ODA4NDM2MWI1MDU2Y2RjNGU2IiwKICAgICAgIm1ldGFkYXRhIiA6IHsKICAgICAgICAibW9kZWwiIDogInNsaW0iCiAgICAgIH0KICAgIH0KICB9Cn0="));
    @Unique
    private static final float BRIGHTNESS_THRESHOLD = 0.1f;

    @Inject(method={"method_65863"}, at={@At(value="HEAD")})
    private static void skyblocker$determineSkinSource(class_1011 image, String uri, CallbackInfoReturnable<class_1011> cir, @Share(value="isSkyblockSkinTexture") LocalBooleanRef isSkyblockSkinTexture) {
        if (SkyblockerConfigManager.get().uiAndVisuals.dontStripSkinAlphaValues && (Utils.isOnSkyblock() || class_310.method_1551().field_1755 instanceof ProfileViewerScreen)) {
            String skinTextureHash = PlayerHeadHashCache.getSkinHashFromUrl(uri);
            int skinHash = skinTextureHash.hashCode();
            isSkyblockSkinTexture.set(PlayerHeadHashCache.contains(skinHash));
            if (STRIP_DE_FACTO_TRANSPARENT_PIXELS.contains(skinTextureHash)) {
                SkinTextureDownloaderMixin.stripDeFactoTransparentPixels(image);
            }
        }
    }

    @WrapWithCondition(method={"method_65863"}, at={@At(value="INVOKE", target="Lnet/minecraft/class_10538;method_65868(Lnet/minecraft/class_1011;IIII)V")})
    private static boolean skyblocker$dontStripAlphaValues(class_1011 image, int x1, int y1, int x2, int y2, @Share(value="isSkyblockSkinTexture") LocalBooleanRef isSkyblockSkinTexture) {
        return !isSkyblockSkinTexture.get();
    }

    @Unique
    private static void stripDeFactoTransparentPixels(class_1011 image) {
        int height = image.method_4323();
        int width = image.method_4307();
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int color = image.method_61940(x, y);
                float[] hsb = Color.RGBtoHSB(color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF, null);
                if (!(hsb[2] <= 0.1f)) continue;
                image.method_61941(x, y, class_9848.method_61330((int)0, (int)(color & 0xFFFFFF)));
            }
        }
    }
}

