/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.render.WorldRenderExtractionCallback;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveCollector;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3965;

public class BuildersWandPreview {
    private static final int MAX_BLOCKS = 241;
    public static final int PLOT_SIZE = 96;
    public static final int PLOT_OFFSET = 48;
    private static final float[] RED = new float[]{1.0f, 0.0f, 0.0f};
    public static final boolean SODIUM_LOADED = FabricLoader.getInstance().isModLoaded("sodium");
    private static final class_310 client = class_310.method_1551();

    @Init
    public static void init() {
        WorldRenderExtractionCallback.EVENT.register(collector -> {
            class_3965 blockHitResult;
            if (!SkyblockerConfigManager.get().helpers.enableBuildersWandPreview || !Utils.isOnSkyblock() || BuildersWandPreview.client.field_1724 == null) {
                return;
            }
            if (!Utils.isInPrivateIsland() && !Utils.isInGarden()) {
                return;
            }
            class_239 patt0$temp = BuildersWandPreview.client.field_1765;
            if (!(patt0$temp instanceof class_3965) || (blockHitResult = (class_3965)patt0$temp).method_17783() != class_239.class_240.field_1332) {
                return;
            }
            class_1799 stack = BuildersWandPreview.client.field_1724.method_6047();
            if (!stack.method_31574(class_1802.field_8894)) {
                return;
            }
            switch (stack.getSkyblockId()) {
                case "BUILDERS_WAND": {
                    BuildersWandPreview.extractBuildersWandPreview(collector, blockHitResult);
                    break;
                }
                case "BUILDERS_RULER": {
                    BuildersWandPreview.extractBuildersRulerPreview(collector, blockHitResult);
                }
            }
        });
    }

    private static void extractBuildersWandPreview(PrimitiveCollector collector, class_3965 hitResult) {
        class_2350 side;
        if (BuildersWandPreview.client.field_1687 == null) {
            return;
        }
        class_2338 hitPos = hitResult.method_17777();
        if (!BuildersWandPreview.client.field_1687.method_8320(hitPos.method_10093(side = hitResult.method_17780())).method_26215()) {
            return;
        }
        class_2680 state = BuildersWandPreview.client.field_1687.method_8320(hitPos);
        for (class_2338 pos : BuildersWandPreview.findConnectedFaces((class_1937)BuildersWandPreview.client.field_1687, hitPos, side, state)) {
            BuildersWandPreview.extractBlockPreview(collector, pos.method_10093(side), state);
        }
    }

    private static Set<class_2338> findConnectedFaces(class_1937 world, class_2338 pos, class_2350 side, class_2680 state) {
        ArrayDeque<class_2338> q = new ArrayDeque<class_2338>();
        HashSet<class_2338> visited = new HashSet<class_2338>();
        q.add(pos);
        visited.add(pos);
        while (!q.isEmpty()) {
            class_2338 current = (class_2338)q.poll();
            class_2338.class_2339 mutable = current.method_25503();
            for (class_2350 dir : class_2350.values()) {
                if (dir == side || dir == side.method_10153()) continue;
                mutable.method_10098(dir);
                if (!visited.contains(mutable) && world.method_8320((class_2338)mutable).equals((Object)state)) {
                    if (world.method_8320((class_2338)mutable.method_10098(side)).method_26215()) {
                        class_2338 neighbor = mutable.method_10098(side.method_10153()).method_10062();
                        q.add(neighbor);
                        visited.add(neighbor);
                    } else {
                        mutable.method_10098(side.method_10153());
                    }
                }
                mutable.method_10098(dir.method_10153());
            }
            if (visited.size() <= 241) continue;
            return Set.of();
        }
        return visited;
    }

    private static void extractBuildersRulerPreview(PrimitiveCollector collector, class_3965 hitResult) {
        if (BuildersWandPreview.client.field_1724 == null || BuildersWandPreview.client.field_1687 == null || !Utils.isInGarden()) {
            return;
        }
        class_2338 startPos = hitResult.method_17777();
        boolean isSneaking = BuildersWandPreview.client.field_1724.method_5715();
        class_2248 startBlock = class_2246.field_10124;
        if (!isSneaking) {
            startPos = startPos.method_10093(hitResult.method_17780());
        } else {
            startBlock = BuildersWandPreview.client.field_1687.method_8320(startPos).method_26204();
        }
        class_2338.class_2339 pos = startPos.method_25503();
        for (int i = 0; i < 241 && BuildersWandPreview.checkPos(startPos, pos, BuildersWandPreview.client.field_1687.method_8320((class_2338)pos), isSneaking, startBlock); ++i) {
            if (isSneaking) {
                collector.submitFilledBox((class_2338)pos, RED, 0.5f, true);
            } else {
                BuildersWandPreview.extractBlockPreview(collector, (class_2338)pos, class_2246.field_10566.method_9564());
            }
            pos.method_10098(BuildersWandPreview.client.field_1724.method_5735());
        }
    }

    private static boolean checkPos(class_2338 plotPos, class_2338.class_2339 pos, class_2680 state, boolean isSneaking, class_2248 startBlock) {
        return BuildersWandPreview.isInPlot(plotPos, (class_2338)pos) && (isSneaking ? state.method_27852(startBlock) : state.method_26215());
    }

    private static boolean isInPlot(class_2338 plotPos, class_2338 pos) {
        return Math.floorDiv(plotPos.method_10263() + 48, 96) == Math.floorDiv(pos.method_10263() + 48, 96) && Math.floorDiv(plotPos.method_10260() + 48, 96) == Math.floorDiv(pos.method_10260() + 48, 96);
    }

    private static void extractBlockPreview(PrimitiveCollector collector, class_2338 pos, class_2680 state) {
        collector.submitBlockHologram(pos, state);
    }
}

