/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.config.configs.DungeonsConfig;
import de.hysky.skyblocker.config.configs.UIAndVisualsConfig;
import de.hysky.skyblocker.mixins.accessors.AbstractContainerScreenAccessor;
import de.hysky.skyblocker.mixins.accessors.ScreenAccessor;
import de.hysky.skyblocker.skyblock.crimson.CrimsonFaction;
import de.hysky.skyblocker.skyblock.crimson.kuudra.Kuudra;
import de.hysky.skyblocker.skyblock.crimson.kuudra.KuudraProfileData;
import de.hysky.skyblocker.skyblock.hunting.Attribute;
import de.hysky.skyblocker.skyblock.hunting.Attributes;
import de.hysky.skyblocker.skyblock.item.PetInfo;
import de.hysky.skyblocker.skyblock.item.SkyblockItemRarity;
import de.hysky.skyblocker.utils.Formatters;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.RegexUtils;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.networth.NetworthCalculator;
import it.unimi.dsi.fastutil.doubles.DoubleBooleanPair;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_124;
import net.minecraft.class_1707;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_476;
import net.minecraft.class_5348;
import net.minecraft.class_7842;
import net.minecraft.class_7919;
import net.minecraft.class_9322;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChestValue {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChestValue.class);
    private static final Set<String> DUNGEON_CHESTS = Set.of("Wood Chest", "Gold Chest", "Diamond Chest", "Emerald Chest", "Obsidian Chest", "Bedrock Chest");
    public static final Pattern DUNGEON_CHEST_COIN_COST_PATTERN = Pattern.compile("^([0-9,]+) Coins$");
    private static final Set<String> KUUDRA_CHESTS = Set.of("Free Chest", "Free Chest Chest", "Paid Chest", "Paid Chest Chest");
    private static final Map<String, String> KUUDRA_KEYS = Map.of("Kuudra Key", "KUUDRA_TIER_KEY", "Hot Kuudra Key", "KUUDRA_HOT_TIER_KEY", "Burning Kuudra Key", "KUUDRA_BURNING_TIER_KEY", "Fiery Kuudra Key", "KUUDRA_FIERY_TIER_KEY", "Infernal Kuudra Key", "KUUDRA_INFERNAL_TIER_KEY");
    public static final Pattern ESSENCE_PATTERN = Pattern.compile("(?<type>[A-Za-z]+) Essence(?: x(?<amount>\\d+))?");
    public static final Pattern SHARD_PATTERN = Pattern.compile("[A-Za-z ]+ Shard(?: x(?<amount>\\d+))?");
    public static final Pattern KUUDRA_TEETH_PATTERN = Pattern.compile("Kuudra Teeth(?: x(?<amount>\\d+))?");
    public static final Pattern HEAVY_PEARL_PATTERN = Pattern.compile("Heavy Pearl(?: x(?<amount>\\d+))?");
    private static final Pattern MINION_PATTERN = Pattern.compile("Minion (I|II|III|IV|V|VI|VII|VIII|IX|X|XI|XII)$");

    @Init
    public static void init() {
        ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
            if (Utils.isOnSkyblock() && screen instanceof class_476) {
                RewardChestType chestType;
                class_476 genericContainerScreen = (class_476)screen;
                class_2561 title = screen.method_25440();
                String titleString = title.getString();
                RewardChestType rewardChestType = DUNGEON_CHESTS.contains(titleString) ? RewardChestType.DUNGEON : (chestType = KUUDRA_CHESTS.contains(titleString) ? RewardChestType.KUUDRA : null);
                if (chestType != null) {
                    if (SkyblockerConfigManager.get().dungeons.dungeonChestProfit.enableProfitCalculator) {
                        ScreenEvents.afterTick((class_437)screen).register(ignored -> {
                            class_2561 dungeonChestProfit = ChestValue.getRewardChestProfit((class_1707)genericContainerScreen.method_17577(), chestType);
                            if (dungeonChestProfit != null) {
                                ChestValue.addValueToContainer(genericContainerScreen, dungeonChestProfit, title);
                            }
                        });
                    }
                } else if (SkyblockerConfigManager.get().uiAndVisuals.chestValue.enableChestValue && !titleString.equals("SkyBlock Menu")) {
                    ScreenType screenType = ChestValue.determineScreenType(titleString);
                    Screens.getButtons((class_437)screen).add(class_4185.method_46430((class_2561)class_2561.method_43470((String)"$"), buttonWidget -> {
                        Screens.getButtons((class_437)screen).remove(buttonWidget);
                        ScreenEvents.afterTick((class_437)screen).register(ignored -> {
                            class_2561 chestValue = ChestValue.getChestValue((class_1707)genericContainerScreen.method_17577(), screenType);
                            if (chestValue != null) {
                                ChestValue.addValueToContainer(genericContainerScreen, chestValue, title);
                            }
                        });
                    }).method_46434(((AbstractContainerScreenAccessor)genericContainerScreen).getX() + ((AbstractContainerScreenAccessor)genericContainerScreen).getImageWidth() - 16, ((AbstractContainerScreenAccessor)genericContainerScreen).getY() + 4, 12, 12).method_46436(class_7919.method_47407((class_2561)ChestValue.getButtonTooltipText(screenType))).method_46431());
                }
            }
        });
    }

    private static @Nullable class_2561 getRewardChestProfit(class_1707 handler, RewardChestType chestType) {
        try {
            double profit = 0.0;
            boolean hasIncompleteData = false;
            boolean usedKismet = false;
            List slots = handler.field_7761.subList(0, handler.method_17388() * 9);
            if (((class_1735)slots.get(31)).method_7677().method_7960() || ((class_1735)slots.get(50)).method_7677().method_7960()) {
                return null;
            }
            for (class_1735 slot : slots) {
                Matcher matcher;
                class_1799 stack = slot.method_7677();
                if (stack.method_7960()) continue;
                String name = stack.method_7964().getString();
                String skyblockApiId = stack.getSkyblockApiId();
                if (!(skyblockApiId.isEmpty() || name.contains("Essence") || name.contains("Shard"))) {
                    DoubleBooleanPair priceData = ItemUtils.getItemPrice(skyblockApiId);
                    profit += priceData.leftDouble() * (double)stack.method_7947();
                    hasIncompleteData |= !priceData.rightBoolean();
                    continue;
                }
                if (name.contains("Essence") && SkyblockerConfigManager.get().dungeons.dungeonChestProfit.includeEssence && (matcher = ESSENCE_PATTERN.matcher(name)).matches()) {
                    String type = matcher.group("type").toUpperCase(Locale.ENGLISH);
                    int amount = RegexUtils.parseOptionalIntFromMatcher((MatchResult)matcher, "amount").orElse(1);
                    DoubleBooleanPair priceData = ItemUtils.getItemPrice(skyblockApiId);
                    if (type.equals("CRIMSON")) {
                        amount = (int)((float)amount * ChestValue.computeCrimsonEssenceMultiplier());
                    }
                    profit += priceData.leftDouble() * (double)amount;
                    hasIncompleteData |= !priceData.rightBoolean();
                    continue;
                }
                if (name.contains("Shard") && !name.contains("Reroll") && (matcher = SHARD_PATTERN.matcher(name)).matches()) {
                    int shards = RegexUtils.parseOptionalIntFromMatcher((MatchResult)matcher, "amount").orElse(1);
                    Attribute attribute = Attributes.getAttributeFromItemName((class_9322)stack);
                    if (attribute == null) {
                        LOGGER.warn("[Skyblocker Profit Calculator] Encountered unknown shard {}", (Object)name);
                        continue;
                    }
                    String shardApiId = attribute.apiId();
                    DoubleBooleanPair priceData = ItemUtils.getItemPrice(shardApiId);
                    profit += priceData.leftDouble() * (double)shards;
                    hasIncompleteData |= !priceData.rightBoolean();
                    continue;
                }
                if (name.contains("Open Reward Chest")) {
                    switch (chestType.ordinal()) {
                        case 0: {
                            String foundString;
                            matcher = ItemUtils.getLoreLineIfContainsMatch(stack, DUNGEON_CHEST_COIN_COST_PATTERN);
                            if (matcher == null || !NumberUtils.isCreatable((String)(foundString = matcher.group(1).replaceAll("\\D", "")))) break;
                            profit -= (double)Integer.parseInt(foundString);
                            break;
                        }
                        case 1: {
                            String key = ItemUtils.getLoreLineIf(stack, KUUDRA_KEYS::containsKey);
                            if (key == null) break;
                            DoubleBooleanPair keyCost = ChestValue.computeKuudraKeyPrice(key);
                            profit -= keyCost.leftDouble();
                            hasIncompleteData |= !keyCost.rightBoolean();
                        }
                    }
                    continue;
                }
                if (!name.contains("Reroll Chest")) continue;
                usedKismet = !StringUtils.isBlank((CharSequence)ItemUtils.getLoreLineContains(stack, "You already rerolled a chest!"));
            }
            if (SkyblockerConfigManager.get().dungeons.dungeonChestProfit.includeKismet && usedKismet) {
                DoubleBooleanPair kismetPriceData = ItemUtils.getItemPrice("KISMET_FEATHER");
                profit -= kismetPriceData.leftDouble();
                hasIncompleteData |= !kismetPriceData.rightBoolean();
            }
            return ChestValue.getProfitText((long)profit, hasIncompleteData);
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker Profit Calculator] Failed to calculate reward chest profit for {}! ", (Object)chestType, (Object)e);
            return null;
        }
    }

    public static float computeCrimsonEssenceMultiplier() {
        PetInfo kuudraPet = Kuudra.getKuudraProfileData().kuudraPet();
        float percentBonus = (switch (kuudraPet.tier()) {
            case SkyblockItemRarity.COMMON -> 10.0f;
            case SkyblockItemRarity.UNCOMMON, SkyblockItemRarity.RARE -> 15.0f;
            case SkyblockItemRarity.EPIC, SkyblockItemRarity.LEGENDARY -> 20.0f;
            default -> 10.0f;
        }) * ((float)kuudraPet.level() / 100.0f);
        return percentBonus / 100.0f + 1.0f;
    }

    public static DoubleBooleanPair computeKuudraKeyPrice(String kuudraKeyName) {
        String kuudraKeyId = KUUDRA_KEYS.get(kuudraKeyName);
        if (kuudraKeyId == null) {
            throw new IllegalArgumentException("Expected a Kuudra Key variant but got: " + kuudraKeyName);
        }
        int baseCost = Kuudra.getKuudraProfileData().kuudraKeyPrices().getOrDefault(kuudraKeyId, KuudraProfileData.EMPTY.kuudraKeyPrices().get(kuudraKeyId));
        String ingredient = switch (Kuudra.getKuudraProfileData().faction()) {
            default -> throw new MatchException(null, null);
            case CrimsonFaction.MAGE -> "ENCHANTED_MYCELIUM";
            case CrimsonFaction.BARBARIAN -> "ENCHANTED_RED_SAND";
        };
        int ingredientAmount = switch (kuudraKeyId) {
            case "KUUDRA_TIER_KEY" -> 2;
            case "KUUDRA_HOT_TIER_KEY" -> 4;
            case "KUUDRA_BURNING_TIER_KEY" -> 16;
            case "KUUDRA_FIERY_TIER_KEY" -> 40;
            case "KUUDRA_INFERNAL_TIER_KEY" -> 80;
            default -> throw new IllegalArgumentException("Expected a Kuudra Key variant but got: " + kuudraKeyName);
        };
        double price = 0.0;
        boolean hasCompleteData = true;
        DoubleBooleanPair ingredientPriceData = ItemUtils.getItemPrice(ingredient);
        DoubleBooleanPair netherStarPriceData = ItemUtils.getItemPrice("CORRUPTED_NETHER_STAR");
        price += (double)baseCost;
        price += ingredientPriceData.leftDouble() * (double)ingredientAmount;
        hasCompleteData &= ingredientPriceData.rightBoolean();
        return DoubleBooleanPair.of((double)(price += netherStarPriceData.leftDouble() * 2.0), (boolean)(hasCompleteData &= netherStarPriceData.rightBoolean()));
    }

    private static @Nullable class_2561 getChestValue(class_1707 handler, ScreenType screenType) {
        try {
            double value = 0.0;
            boolean hasIncompleteData = false;
            List slots = switch (screenType.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> ChestValue.getMinionSlots(handler);
                case 1 -> handler.field_7761.subList(10, handler.method_17388() * 9 - 10);
                case 2 -> handler.field_7761.subList(0, (handler.method_17388() - 1) * 9);
                case 3 -> handler.field_7761.subList(0, handler.method_17388() * 9);
            };
            for (class_1735 slot : slots) {
                int count;
                String coinsLine;
                class_1799 stack = slot.method_7677();
                if (stack.method_7960()) continue;
                if (screenType == ScreenType.MINION && slot.field_7874 == 28 && stack.method_31574(class_1802.field_8239) && (coinsLine = ItemUtils.getLoreLineIf(stack, s -> s.contains("Held Coins:"))) != null) {
                    String source = coinsLine.split(":")[1];
                    try {
                        value += NumberFormat.getNumberInstance(Locale.US).parse(source.trim()).doubleValue();
                    }
                    catch (ParseException e) {
                        LOGGER.warn("[Skyblocker] Failed to parse `{}`", (Object)source);
                    }
                    continue;
                }
                String id = stack.getSkyblockApiId();
                if ((count = (switch (screenType.ordinal()) {
                    default -> throw new MatchException(null, null);
                    case 1 -> {
                        List lines = stack.skyblocker$getLoreStrings();
                        yield ItemUtils.getItemCountInSack(stack, lines).orElse(0);
                    }
                    case 2 -> ItemUtils.getItemCountInStash(stack).orElse(0);
                    case 0, 3 -> stack.method_7947();
                })) == 0 || id.isEmpty()) continue;
                DoubleBooleanPair priceData = ItemUtils.getItemPrice(id);
                if (!priceData.rightBoolean()) {
                    hasIncompleteData = true;
                }
                value += NetworthCalculator.getItemNetworth(stack, count).price();
            }
            return ChestValue.getValueText((long)value, hasIncompleteData);
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker Value Calculator] Failed to calculate dungeon chest value! ", (Throwable)e);
            return null;
        }
    }

    private static List<class_1735> getMinionSlots(class_1707 handler) {
        return handler.field_7761.subList(0, handler.method_17388() * 9).stream().filter(slot -> {
            int x = slot.field_7874 % 9;
            int y = slot.field_7874 / 9;
            return x > 2 && x < 8 && y > 1 && y < 5 || slot.field_7874 == 28;
        }).toList();
    }

    static class_2561 getProfitText(long profit, boolean hasIncompleteData) {
        return class_2561.method_43470((String)(String.valueOf(profit > 0L ? " +" : Character.valueOf(' ')) + Formatters.INTEGER_NUMBERS.format(profit) + " Coins")).method_27692(ChestValue.getProfitColor(hasIncompleteData, profit));
    }

    static class_124 getProfitColor(boolean hasIncompleteData, long profit) {
        DungeonsConfig.DungeonChestProfit config = SkyblockerConfigManager.get().dungeons.dungeonChestProfit;
        if (hasIncompleteData) {
            return config.incompleteColor;
        }
        if (Math.abs(profit) < (long)config.neutralThreshold) {
            return config.neutralColor;
        }
        if (profit > 0L) {
            return config.profitColor;
        }
        return config.lossColor;
    }

    static class_2561 getValueText(long value, boolean hasIncompleteData) {
        UIAndVisualsConfig.ChestValue config = SkyblockerConfigManager.get().uiAndVisuals.chestValue;
        return class_2561.method_43470((String)(" " + Formatters.INTEGER_NUMBERS.format(value) + " Coins")).method_27692(hasIncompleteData ? config.incompleteColor : config.color);
    }

    private static void addValueToContainer(class_476 genericContainerScreen, class_2561 chestValue, class_2561 title) {
        Screens.getButtons((class_437)genericContainerScreen).removeIf(ChestValueTextWidget.class::isInstance);
        int backgroundWidth = ((AbstractContainerScreenAccessor)genericContainerScreen).getImageWidth();
        int y = ((AbstractContainerScreenAccessor)genericContainerScreen).getY();
        int x = ((AbstractContainerScreenAccessor)genericContainerScreen).getX();
        ((ScreenAccessor)genericContainerScreen).setTitle((class_2561)class_2561.method_43473());
        class_327 textRenderer = class_310.method_1551().field_1772;
        int chestValueWidth = Math.min(textRenderer.method_27525((class_5348)chestValue), Math.max((backgroundWidth - 8) / 2 - 2, backgroundWidth - 8 - textRenderer.method_27525((class_5348)title)));
        Objects.requireNonNull(textRenderer);
        ChestValueTextWidget chestValueWidget = new ChestValueTextWidget(chestValueWidth, 9, chestValue, textRenderer);
        chestValueWidget.method_48229(x + backgroundWidth - chestValueWidget.method_25368() - 4, y + 6);
        Screens.getButtons((class_437)genericContainerScreen).add(chestValueWidget);
        Objects.requireNonNull(textRenderer);
        ChestValueTextWidget chestTitleWidget = new ChestValueTextWidget(backgroundWidth - 8 - chestValueWidth - 2, 9, (class_2561)title.method_27661().method_27696(class_2583.field_24360.method_36139(0x404040)), textRenderer);
        chestTitleWidget.method_48229(x + 8, y + 6);
        Screens.getButtons((class_437)genericContainerScreen).add(chestTitleWidget);
    }

    private static ScreenType determineScreenType(String rawTitleString) {
        if (rawTitleString.toLowerCase(Locale.ENGLISH).endsWith("sack")) {
            return ScreenType.SACK;
        }
        if (MINION_PATTERN.matcher(rawTitleString.trim()).find()) {
            return ScreenType.MINION;
        }
        if ("View Stash".equalsIgnoreCase(rawTitleString)) {
            return ScreenType.STASH;
        }
        return ScreenType.OTHER;
    }

    private static class_2561 getButtonTooltipText(ScreenType screenType) {
        return switch (screenType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> class_2561.method_43471((String)"skyblocker.containerValue.minionValue.@Tooltip");
            case 3 -> class_2561.method_43471((String)"skyblocker.containerValue.chestValue.@Tooltip");
            case 2 -> class_2561.method_43471((String)"skyblocker.containerValue.stashValue.@Tooltip");
            case 1 -> class_2561.method_43471((String)"skyblocker.containerValue.sackValue.@Tooltip");
        };
    }

    private static enum RewardChestType {
        DUNGEON,
        KUUDRA;

    }

    private static enum ScreenType {
        MINION,
        SACK,
        STASH,
        OTHER;

    }

    private static class ChestValueTextWidget
    extends class_7842 {
        private ChestValueTextWidget(int width, int height, class_2561 message, class_327 textRenderer) {
            super(width, height, (class_2561)message.method_27661().method_27696(class_2583.field_24360.method_65302(0)), textRenderer);
            this.method_73395(this.method_25368(), class_7842.class_11764.field_62127);
        }
    }
}

