/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock;

import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.config.configs.UIAndVisualsConfig;
import de.hysky.skyblocker.utils.OkLabColor;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1531;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import org.apache.commons.lang3.math.NumberUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class CompactDamage {
    private static final Pattern DAMAGE_PATTERN = Pattern.compile("([\u2727\u272f]?)[\\d,]+[\u2727\u272f]?([\u2764+\u2694\u2604\u265e]?)");
    private static final int[] guesses = new int[]{0, 1, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 4, 5, 5, 5, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8, 9, 9, 9, 10, 10, 10, 10, 11, 11, 11, 12, 12, 12, 13, 13, 13, 13, 14, 14, 14, 15, 15, 15, 16, 16, 16, 16, 17, 17, 17, 18, 18, 18, 19, 19, 19};
    private static final long[] powersOfTen = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};

    private CompactDamage() {
    }

    public static void compactDamage(class_1531 entity) {
        UIAndVisualsConfig.CompactDamage config = SkyblockerConfigManager.get().uiAndVisuals.compactDamage;
        if (!config.enabled) {
            return;
        }
        if (!(entity.method_5767() && entity.method_16914() && entity.method_5807())) {
            return;
        }
        class_2561 customName = entity.method_5797();
        if (customName == null) {
            return;
        }
        String customNameString = customName.getString();
        Matcher matcher = DAMAGE_PATTERN.matcher(customNameString);
        if (!matcher.matches()) {
            return;
        }
        List siblings = customName.method_10855();
        if (siblings.isEmpty()) {
            return;
        }
        boolean isCrit = !matcher.group(1).isEmpty();
        String dmg = customNameString.replaceAll("\\D", "");
        if (!NumberUtils.isParsable((String)dmg)) {
            return;
        }
        class_5251 textColor = ((class_2561)siblings.getFirst()).method_10866().method_10973();
        class_5250 prettierCustomName = class_2561.method_43473();
        Object prettifiedDmg = CompactDamage.prettifyDamageNumber(Long.parseLong(dmg), config.maxPrecision);
        if (isCrit) {
            String dmgSymbol = matcher.group(1);
            prettifiedDmg = dmgSymbol + (String)prettifiedDmg + dmgSymbol;
            int length = ((String)prettifiedDmg).length();
            for (int i = 0; i < length; ++i) {
                prettierCustomName.method_10852((class_2561)class_2561.method_43470((String)((String)prettifiedDmg).substring(i, i + 1)).method_54663(OkLabColor.interpolate(config.critDamageGradientStart.getRGB() & 0xFFFFFF, config.critDamageGradientEnd.getRGB() & 0xFFFFFF, (float)i / ((float)length - 1.0f))));
            }
            prettierCustomName.method_10862(customName.method_10866());
        } else {
            int color = textColor == null || textColor == class_5251.method_27718((class_124)class_124.field_1080) ? config.normalDamageColor.getRGB() & 0xFFFFFF : textColor.method_27716();
            prettierCustomName = class_2561.method_43470((String)prettifiedDmg).method_10862(customName.method_10866()).method_54663(color);
        }
        if (!matcher.group(2).isEmpty()) {
            prettierCustomName.method_10852((class_2561)class_2561.method_43470((String)matcher.group(2)).method_10862(((class_2561)siblings.getLast()).method_10866()));
        }
        entity.skyblocker$setCustomName((class_2561)prettierCustomName);
    }

    @VisibleForTesting
    static String prettifyDamageNumber(long damage, int maxPrecision) {
        long targetDamage = damage;
        int targetPrecision = maxPrecision;
        int usedPrecision = CompactDamage.baseTenDigits(targetDamage);
        if (usedPrecision > targetPrecision) {
            double powerToRoundTo = powersOfTen[usedPrecision - maxPrecision];
            targetDamage = (long)((double)Math.round((double)targetDamage / powerToRoundTo) * powerToRoundTo);
        } else if (targetPrecision > usedPrecision) {
            targetPrecision = usedPrecision;
        }
        if (targetDamage < 1000L) {
            return String.valueOf(targetDamage);
        }
        if (targetDamage < 1000000L) {
            return CompactDamage.formatToPrecision((double)targetDamage / 1000.0, targetPrecision) + "k";
        }
        if (targetDamage < 1000000000L) {
            return CompactDamage.formatToPrecision((double)targetDamage / 1000000.0, targetPrecision) + "M";
        }
        if (targetDamage < 1000000000000L) {
            return CompactDamage.formatToPrecision((double)targetDamage / 1.0E9, targetPrecision) + "B";
        }
        if (targetDamage < 1000000000000000L) {
            return CompactDamage.formatToPrecision((double)targetDamage / 1.0E12, targetPrecision) + "T";
        }
        return CompactDamage.formatToPrecision((double)targetDamage / 1.0E15, targetPrecision) + "Q";
    }

    @VisibleForTesting
    static String formatToPrecision(double number, int precision) {
        int usedPrecision = CompactDamage.baseTenDigits((int)number);
        int remainingPrecision = precision - usedPrecision;
        if (remainingPrecision <= 0) {
            long powerToRoundTo = powersOfTen[usedPrecision - precision];
            return String.valueOf(Math.round(number / (double)powerToRoundTo) * powerToRoundTo);
        }
        return ("%." + remainingPrecision + "f").formatted(number);
    }

    private static int baseTwoDigits(long x) {
        return 64 - Long.numberOfLeadingZeros(x);
    }

    @VisibleForTesting
    static int baseTenDigits(long x) {
        int guess;
        return guess + (x >= powersOfTen[guess = guesses[CompactDamage.baseTwoDigits(x)]] ? 1 : 0);
    }
}

