/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.utils.Http;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.command.CommandUtils;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2172;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JoinInstanceAutocomplete {
    private static final Logger LOGGER = LoggerFactory.getLogger(JoinInstanceAutocomplete.class);
    public static @Nullable LiteralCommandNode<FabricClientCommandSource> joinInstanceCommand;
    public static @Nullable LiteralCommandNode<FabricClientCommandSource> dungeonCommand;
    public static @Nullable LiteralCommandNode<FabricClientCommandSource> kuudraCommand;
    private static Map<String, String> instanceMap;

    @Init
    public static void init() {
        CompletableFuture.runAsync(() -> {
            try {
                String json = Http.sendGetRequest("https://hysky.de/api/joininstances");
                JsonObject obj = JsonParser.parseString(json).getAsJsonObject();
                instanceMap = obj.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((JsonElement)e.getValue()).getAsString()));
                joinInstanceCommand = JoinInstanceAutocomplete.buildCommand("joininstance", s -> true);
                dungeonCommand = JoinInstanceAutocomplete.buildCommand("joindungeon", s -> instanceMap.get(s).equalsIgnoreCase("Catacombs"));
                kuudraCommand = JoinInstanceAutocomplete.buildCommand("joinkuudra", s -> instanceMap.get(s).equalsIgnoreCase("Kuudra"));
            }
            catch (Exception e2) {
                LOGGER.error("[Skyblocker] Failed to load joininstance list", (Throwable)e2);
            }
        }, Executors.newVirtualThreadPerTaskExecutor());
    }

    private static LiteralCommandNode<FabricClientCommandSource> buildCommand(String command, Predicate<String> filter) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)command).requires(source -> Utils.isOnSkyblock())).executes(CommandUtils.noOp)).then(ClientCommandManager.argument((String)"instance", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9264(instanceMap.keySet().stream().filter(filter).sorted(), (SuggestionsBuilder)builder)).executes(CommandUtils.noOp))).build();
    }
}

