/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock;

import com.google.gson.JsonParser;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.utils.Http;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.command.CommandUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2172;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;

public class RngMeterAutocomplete {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Codec<Map<String, List<String>>> CODEC = Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.STRING.listOf());
    private static Map<String, List<String>> rngMeters = new HashMap<String, List<String>>();
    public static @Nullable LiteralCommandNode<FabricClientCommandSource> longCommand;
    public static @Nullable LiteralCommandNode<FabricClientCommandSource> shortCommand;

    @Init
    public static void init() {
        CompletableFuture.runAsync(() -> {
            try {
                String json = Http.sendGetRequest("https://hysky.de/api/rngmeters");
                rngMeters = (Map)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString(json)).getOrThrow();
                longCommand = RngMeterAutocomplete.createCommandNode("rngmeter");
                shortCommand = RngMeterAutocomplete.createCommandNode("rng");
            }
            catch (Exception e) {
                LOGGER.error("[Skyblocker RNG Meter Autocomplete] Failed to load RNG Meter data.", (Throwable)e);
            }
        }, Executors.newVirtualThreadPerTaskExecutor());
    }

    private static LiteralCommandNode<FabricClientCommandSource> createCommandNode(String command) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)command).requires(source -> Utils.isOnSkyblock())).executes(CommandUtils.noOp)).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"type", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> class_2172.method_9265(rngMeters.keySet(), (SuggestionsBuilder)builder)).executes(CommandUtils.noOp)).then(ClientCommandManager.argument((String)"subtype", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> class_2172.method_9265((Iterable)rngMeters.getOrDefault(StringArgumentType.getString((CommandContext)context, (String)"type"), List.of()), (SuggestionsBuilder)builder)).executes(CommandUtils.noOp)))).build();
    }
}

