/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.accessories;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.injected.SkyblockerStack;
import de.hysky.skyblocker.skyblock.accessories.AccessoriesHelperWidget;
import de.hysky.skyblocker.skyblock.item.tooltip.info.TooltipInfoType;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.data.ProfiledData;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_1707;
import net.minecraft.class_1735;
import net.minecraft.class_437;
import net.minecraft.class_476;
import net.minecraft.class_9322;

public class AccessoriesHelper {
    private static final ObjectOpenHashSet<String> EMPTY = new ObjectOpenHashSet(0);
    private static final Path FILE = SkyblockerMod.CONFIG_DIR.resolve("collected_accessories.json");
    static final Pattern ACCESSORY_BAG_TITLE = Pattern.compile("Accessory Bag(?: \\((?<page>\\d+)\\/\\d+\\))?");
    private static final ProfiledData<ProfileAccessoryData> COLLECTED_ACCESSORIES = new ProfiledData<ProfileAccessoryData>(FILE, ProfileAccessoryData.CODEC, true);
    private static final Predicate<String> NON_EMPTY = s -> !s.isEmpty();
    private static final Predicate<Accessory> HAS_FAMILY = Accessory::hasFamily;
    private static final ToIntFunction<Accessory> ACCESSORY_TIER = Accessory::tier;
    public static Map<String, Accessory> ACCESSORY_DATA = new Object2ObjectOpenHashMap();

    @Init
    public static void init() {
        COLLECTED_ACCESSORIES.init();
        ScreenEvents.AFTER_INIT.register((_client, screen, _scaledWidth, _scaledHeight) -> {
            class_476 genericContainerScreen;
            Matcher matcher;
            if (Utils.isOnSkyblock() && TooltipInfoType.ACCESSORIES.isTooltipEnabled() && !Utils.getProfileId().isEmpty() && screen instanceof class_476 && (matcher = ACCESSORY_BAG_TITLE.matcher((genericContainerScreen = (class_476)screen).method_25440().getString())).matches()) {
                ScreenEvents.afterTick((class_437)screen).register(_screen -> {
                    class_1707 handler = (class_1707)genericContainerScreen.method_17577();
                    int page = matcher.group("page") != null ? Integer.parseInt(matcher.group("page")) : 1;
                    AccessoriesHelper.collectAccessories(handler.field_7761.subList(0, handler.method_17388() * 9), page);
                });
                AccessoriesHelperWidget.attachToScreen(genericContainerScreen);
            }
        });
    }

    private static void collectAccessories(List<class_1735> slots, int page) {
        if (!COLLECTED_ACCESSORIES.isLoaded()) {
            return;
        }
        List<String> accessoryIds = slots.stream().map(class_1735::method_7677).map(SkyblockerStack::getSkyblockId).filter(NON_EMPTY).toList();
        List<String> recombobulated = slots.stream().map(class_1735::method_7677).filter(stack -> ItemUtils.getCustomData((class_9322)stack).method_68083("rarity_upgrades", 0) > 0).map(SkyblockerStack::getSkyblockId).filter(NON_EMPTY).toList();
        ProfileAccessoryData data = COLLECTED_ACCESSORIES.computeIfAbsent(ProfileAccessoryData::createDefault);
        data.recombobulatedAccessories().removeAll((Collection)data.pages().getOrDefault(page, EMPTY));
        data.recombobulatedAccessories().addAll(recombobulated);
        data.pages().put(page, (Object)new ObjectOpenHashSet(accessoryIds));
    }

    public static Pair<AccessoryReport, String> calculateReport4Accessory(String accessoryId) {
        if (!ACCESSORY_DATA.containsKey(accessoryId) || Utils.getProfileId().isEmpty()) {
            return Pair.of((Object)((Object)AccessoryReport.INELIGIBLE), null);
        }
        Accessory accessory = ACCESSORY_DATA.get(accessoryId);
        if (accessory.origin().orElse("").equals("RIFT")) {
            return Pair.of((Object)((Object)AccessoryReport.INELIGIBLE), null);
        }
        Set<Accessory> collectedAccessories = AccessoriesHelper.getCollectedAccessories();
        if (accessory.family().isEmpty()) {
            return collectedAccessories.contains(accessory) ? Pair.of((Object)((Object)AccessoryReport.HAS_HIGHEST_TIER), null) : Pair.of((Object)((Object)AccessoryReport.MISSING), (Object)"");
        }
        FamilyReport report = AccessoriesHelper.calculateFamilyReport(accessory, collectedAccessories);
        int highestTierInFamily = report.highestInFamily().tier();
        if (report.highestCollectedInFamily().isEmpty()) {
            return Pair.of((Object)((Object)AccessoryReport.MISSING), (Object)String.format("(%d/%d)", accessory.tier(), highestTierInFamily));
        }
        int highestTierCollectedInFamily = report.highestCollectedInFamily().get().tier();
        if (accessory.tier() == highestTierInFamily && highestTierCollectedInFamily == highestTierInFamily) {
            return Pair.of((Object)((Object)AccessoryReport.HAS_HIGHEST_TIER), null);
        }
        if (accessory.tier() > highestTierCollectedInFamily) {
            return Pair.of((Object)((Object)AccessoryReport.IS_GREATER_TIER), (Object)String.format("(%d\u2192%d/%d)", highestTierCollectedInFamily, accessory.tier(), highestTierInFamily));
        }
        if (accessory.tier() < highestTierCollectedInFamily) {
            return Pair.of((Object)((Object)AccessoryReport.OWNS_BETTER_TIER), (Object)String.format("(%d\u2192%d/%d)", highestTierCollectedInFamily, accessory.tier(), highestTierInFamily));
        }
        if (accessory.tier() < highestTierInFamily) {
            return Pair.of((Object)((Object)AccessoryReport.HAS_GREATER_TIER), (Object)String.format("(%d/%d)", highestTierCollectedInFamily, highestTierInFamily));
        }
        return Pair.of((Object)((Object)AccessoryReport.MISSING), (Object)String.format("(%d/%d)", accessory.tier(), highestTierInFamily));
    }

    public static FamilyReport calculateFamilyReport(Accessory accessory, Set<Accessory> collectedAccessories) {
        if (accessory.family().isEmpty()) {
            throw new IllegalArgumentException("accessory family cannot be empty");
        }
        Predicate<Accessory> hasSameFamily = accessory::hasSameFamily;
        return new FamilyReport(ACCESSORY_DATA.values().stream().filter(HAS_FAMILY).filter(hasSameFamily).max(Comparator.comparingInt(ACCESSORY_TIER)).orElse(accessory), collectedAccessories.stream().filter(HAS_FAMILY).filter(hasSameFamily).max(Comparator.comparingInt(ACCESSORY_TIER)));
    }

    public static Set<Accessory> getCollectedAccessories() {
        return COLLECTED_ACCESSORIES.computeIfAbsent(ProfileAccessoryData::createDefault).pages().values().stream().flatMap(Collection::stream).filter(ACCESSORY_DATA::containsKey).map(ACCESSORY_DATA::get).collect(Collectors.toSet());
    }

    public static boolean hasAccessory(String accessoryId) {
        return COLLECTED_ACCESSORIES.computeIfAbsent(ProfileAccessoryData::createDefault).pages().values().stream().anyMatch(set -> set.contains((Object)accessoryId));
    }

    public static boolean isRecombobulated(String accessoryId) {
        return AccessoriesHelper.hasAccessory(accessoryId) && COLLECTED_ACCESSORIES.computeIfAbsent(ProfileAccessoryData::createDefault).recombobulatedAccessories().contains((Object)accessoryId);
    }

    public static void refreshData(Map<String, Accessory> data) {
        ACCESSORY_DATA = data;
    }

    private record ProfileAccessoryData(Int2ObjectOpenHashMap<ObjectOpenHashSet<String>> pages, ObjectOpenHashSet<String> recombobulatedAccessories) {
        private static final Codec<ProfileAccessoryData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.INT, (Codec)Codec.STRING.listOf().xmap(ObjectOpenHashSet::new, ObjectArrayList::new)).xmap(Int2ObjectOpenHashMap::new, Int2ObjectOpenHashMap::new).fieldOf("pages").forGetter(ProfileAccessoryData::pages), (App)Codec.STRING.listOf().optionalFieldOf("recombobulatedAccessories", List.of()).xmap(ObjectOpenHashSet::new, List::copyOf).forGetter(ProfileAccessoryData::recombobulatedAccessories)).apply((Applicative)instance, ProfileAccessoryData::new));

        private static ProfileAccessoryData createDefault() {
            return new ProfileAccessoryData((Int2ObjectOpenHashMap<ObjectOpenHashSet<String>>)new Int2ObjectOpenHashMap(), (ObjectOpenHashSet<String>)new ObjectOpenHashSet());
        }
    }

    public static enum AccessoryReport {
        HAS_HIGHEST_TIER,
        IS_GREATER_TIER,
        HAS_GREATER_TIER,
        OWNS_BETTER_TIER,
        MISSING,
        INELIGIBLE;

    }

    public record Accessory(String id, Optional<String> family, int tier, Optional<String> origin, boolean enrichable, boolean recombobulatable) {
        private static final Codec<Accessory> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("id").forGetter(Accessory::id), (App)Codec.STRING.optionalFieldOf("family").forGetter(Accessory::family), (App)Codec.INT.optionalFieldOf("tier", (Object)0).forGetter(Accessory::tier), (App)Codec.STRING.optionalFieldOf("origin").forGetter(Accessory::origin), (App)Codec.BOOL.optionalFieldOf("enrichable", (Object)true).forGetter(Accessory::enrichable), (App)Codec.BOOL.optionalFieldOf("recombobulatable", (Object)true).forGetter(Accessory::recombobulatable)).apply((Applicative)instance, Accessory::new));
        public static final Codec<Map<String, Accessory>> MAP_CODEC = Codec.unboundedMap((Codec)Codec.STRING, CODEC);

        private boolean hasFamily() {
            return this.family.isPresent();
        }

        private boolean hasSameFamily(Accessory other) {
            return other.family().equals(this.family);
        }
    }

    public record FamilyReport(Accessory highestInFamily, Optional<Accessory> highestCollectedInFamily) {
    }
}

