/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.accessories;

import com.google.common.collect.ImmutableList;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.injected.SkyblockerStack;
import de.hysky.skyblocker.mixins.accessors.AbstractContainerScreenAccessor;
import de.hysky.skyblocker.skyblock.accessories.AccessoriesContainerSolver;
import de.hysky.skyblocker.skyblock.accessories.AccessoriesHelper;
import de.hysky.skyblocker.skyblock.item.SkyblockItemRarity;
import de.hysky.skyblocker.skyblock.item.tooltip.ItemTooltip;
import de.hysky.skyblocker.skyblock.item.tooltip.adders.LineSmoothener;
import de.hysky.skyblocker.skyblock.item.tooltip.info.TooltipInfoType;
import de.hysky.skyblocker.skyblock.item.wikilookup.WikiLookupManager;
import de.hysky.skyblocker.skyblock.itemlist.ItemRepository;
import de.hysky.skyblocker.skyblock.itemlist.recipebook.SkyblockRecipeResultButton;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.NEURepoManager;
import de.hysky.skyblocker.utils.container.ContainerSolverManager;
import de.hysky.skyblocker.utils.hoveredItem.HoveredItemStackProvider;
import it.unimi.dsi.fastutil.doubles.DoubleBooleanPair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_10799;
import net.minecraft.class_11876;
import net.minecraft.class_11907;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_344;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_476;
import net.minecraft.class_512;
import net.minecraft.class_513;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5676;
import net.minecraft.class_6382;
import net.minecraft.class_7413;
import net.minecraft.class_746;
import net.minecraft.class_7842;
import net.minecraft.class_7843;
import net.minecraft.class_7845;
import net.minecraft.class_8021;
import net.minecraft.class_8666;
import net.minecraft.class_8667;
import net.minecraft.class_9017;
import net.minecraft.class_9334;
import org.jspecify.annotations.Nullable;

class AccessoriesHelperWidget
extends class_9017
implements HoveredItemStackProvider {
    private static final class_2960 TEXTURE = SkyblockerMod.id("background");
    private static final int BORDER_SIZE = 8;
    private static final int BUTTON_COUNT = 20;
    private final List<class_339> widgets;
    private final List<ResultButton> buttons = new ArrayList<ResultButton>(20);
    private final class_7843 layout;
    private final class_7842 pageText;
    private final ArrowButton prevPageButton;
    private final ArrowButton nextPageButton;
    private List<AccessoryInfo> accessories;
    private List<MagicPowerSource> displays;
    private List<RecombobulateSource> recombDisplays;
    private boolean refreshWhenDoneLoading;
    private static Filter filter = Filter.MISSING;
    private static int page;
    private static boolean open;
    private static boolean showHighestTierOnly;

    static void attachToScreen(class_476 screen) {
        if (!SkyblockerConfigManager.get().general.itemTooltip.enableAccessoriesHelper || !SkyblockerConfigManager.get().helpers.enableAccessoriesHelperWidget) {
            return;
        }
        AccessoriesHelperWidget widget = new AccessoriesHelperWidget();
        widget.method_46419((screen.field_22790 - widget.method_25364()) / 2);
        Screens.getButtons((class_437)screen).add(widget);
        int previousX = ((AbstractContainerScreenAccessor)screen).getX();
        int offset = Math.max(180 - previousX, 0);
        TabButton tabButton = new TabButton(button -> {
            boolean toggled;
            widget.field_22764 = open = (toggled = button.toggled);
            int x = toggled ? previousX + offset : previousX;
            ((AbstractContainerScreenAccessor)screen).setX(x);
            widget.method_46421(x - widget.method_25368() - 2);
            button.method_46421((toggled ? widget.method_46426() : x) - button.method_25368() + 5);
            button.method_46419((toggled ? widget.method_46427() : ((AbstractContainerScreenAccessor)screen).getY()) + 8);
            if (toggled) {
                widget.refreshData();
            } else {
                filter = Filter.MISSING;
                page = 0;
                showHighestTierOnly = false;
            }
        });
        Screens.getButtons((class_437)screen).add(tabButton);
        tabButton.setToggled(open);
    }

    AccessoriesHelperWidget() {
        super(0, 0, 147, 182, class_5244.field_39003);
        this.pageText = new class_7842(class_5244.field_39003, class_310.method_1551().field_1772).method_73395(30, class_7842.class_11764.field_62127);
        this.prevPageButton = new ArrowButton(false);
        this.nextPageButton = new ArrowButton(true);
        this.accessories = List.of();
        this.displays = List.of();
        this.recombDisplays = List.of();
        this.refreshWhenDoneLoading = false;
        this.layout = new class_7843(this.method_25368() - 16, this.method_25364() - 16);
        class_8667 mainLayout = (class_8667)this.layout.method_46441((class_8021)class_8667.method_52741());
        mainLayout.method_52740().method_46467();
        class_7845.class_7939 adder = ((class_7845)mainLayout.method_52736((class_8021)new class_7845())).method_47610(5);
        for (int i = 0; i < 20; ++i) {
            ResultButton button2 = new ResultButton();
            this.buttons.add(button2);
            adder.method_47612((class_8021)button2);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        class_8667 pageSwitcher = (class_8667)mainLayout.method_52738((class_8021)class_8667.method_52742().method_52735(2), p -> p.method_46479(4));
        pageSwitcher.method_52740().method_46474();
        pageSwitcher.method_52736((class_8021)this.prevPageButton);
        ((class_7843)pageSwitcher.method_52736((class_8021)new class_7843(30, 0))).method_46441((class_8021)this.pageText);
        pageSwitcher.method_52736((class_8021)this.nextPageButton);
        int filterWidth = this.layout.method_25368() - 2;
        mainLayout.method_52736((class_8021)class_5676.method_32606(f -> class_2561.method_43471((String)f.toString()), (Object)((Object)filter)).method_32624((Object[])Filter.values()).method_32617(0, 0, filterWidth, 16, (class_2561)class_2561.method_43471((String)"skyblocker.accessoryHelper.filter"), (b, v) -> {
            filter = v;
            this.updateFilter();
            this.changePage(0);
        }));
        mainLayout.method_52736((class_8021)class_5676.method_32607((class_2561)class_2561.method_43471((String)"skyblocker.accessoryHelper.highestTierOnly"), (class_2561)class_2561.method_43471((String)"skyblocker.accessoryHelper.allTiers"), (boolean)showHighestTierOnly).method_32616().method_32617(0, 0, filterWidth, 16, class_5244.field_39003, (button, value) -> {
            showHighestTierOnly = value;
            this.updateFilter();
            this.changePage(0);
        }));
        mainLayout.method_48206(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        this.widgets = builder.build();
        mainLayout.method_48222();
        this.updatePageSwitcher();
    }

    private void refreshData() {
        Set<AccessoriesHelper.Accessory> collectedAccessories = AccessoriesHelper.getCollectedAccessories();
        this.recombDisplays = collectedAccessories.stream().filter(AccessoriesHelper.Accessory::recombobulatable).map(AccessoriesHelper.Accessory::id).filter(id -> !AccessoriesHelper.isRecombobulated(id)).map(ItemRepository::getItemStack).filter(Objects::nonNull).map(SkyblockerStack::getSkyblockRarity).distinct().map(RecombobulateSource::new).toList();
        this.accessories = AccessoriesHelper.ACCESSORY_DATA.values().stream().filter(accessory -> NEURepoManager.isLoading() || !NEURepoManager.getConstants().getMisc().getIgnoredTalismans().contains(accessory.id())).map(accessory -> {
            if (accessory.family().isPresent()) {
                AccessoriesHelper.FamilyReport report = AccessoriesHelper.calculateFamilyReport(accessory, collectedAccessories);
                return new AccessoryInfo((AccessoriesHelper.Accessory)accessory, report.highestCollectedInFamily(), report.highestInFamily());
            }
            return new AccessoryInfo((AccessoriesHelper.Accessory)accessory, collectedAccessories.contains(accessory) ? Optional.of(accessory) : Optional.empty(), (AccessoriesHelper.Accessory)accessory);
        }).distinct().filter(info -> info.accessory().tier() > info.highestOwned().map(AccessoriesHelper.Accessory::tier).orElse(-1)).toList();
        this.updateFilter();
        this.changePage(0);
    }

    private void updateFilter() {
        Predicate<AccessoryInfo> predicate = switch (filter.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> info -> true;
            case 1 -> info -> info.highestOwned().isEmpty();
            case 2 -> info -> info.highestOwned().isPresent() && info.accessory().tier() > info.highestOwned().get().tier();
        };
        Stream<AccessoryInfo.Source> stream = this.accessories.stream().filter(predicate).filter(info -> !showHighestTierOnly || info.accessory().tier() >= info.highestInFamily().tier()).map(AccessoryInfo.Source::new);
        this.displays = Stream.concat(stream, this.recombDisplays.stream()).sorted(Comparator.comparingDouble(MagicPowerSource::pricePerMp)).toList();
    }

    private static OptionalDouble getPrice(AccessoriesHelper.Accessory acc) {
        class_1799 stack = ItemRepository.getItemStack(acc.id());
        if (stack == null) {
            return OptionalDouble.empty();
        }
        DoubleBooleanPair optionalPrice = ItemUtils.getItemPrice(stack);
        double price = optionalPrice.rightBoolean() ? optionalPrice.firstDouble() : ItemUtils.getCraftCost(stack.getSkyblockApiId());
        if (price <= 0.0) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(price);
    }

    private void changePage(int offset) {
        page = Math.clamp((long)(page + offset), 0, this.getPageCount());
        this.updatePageSwitcher();
        for (int i = 0; i < 20; ++i) {
            int j = i + page * 20;
            if (j < this.displays.size()) {
                this.buttons.get(i).setSource(this.displays.get(j));
                continue;
            }
            this.buttons.get(i).clearDisplayStack();
        }
    }

    private int getPageCount() {
        return this.displays.size() / 20 + 1;
    }

    private void updatePageSwitcher() {
        this.pageText.method_25355((class_2561)class_2561.method_43469((String)"gui.recipebook.page", (Object[])new Object[]{page + 1, this.getPageCount()}));
        this.prevPageButton.field_22764 = page > 0;
        this.nextPageButton.field_22764 = page < this.getPageCount() - 1;
        this.layout.method_48222();
    }

    public List<? extends class_364> method_25396() {
        return this.widgets;
    }

    public void method_46421(int x) {
        super.method_46421(x);
        this.layout.method_46421(x + 8);
    }

    public void method_46419(int y) {
        super.method_46419(y);
        this.layout.method_46419(y + 8);
    }

    protected void method_48579(class_332 context, int mouseX, int mouseY, float deltaTicks) {
        context.method_52706(class_10799.field_56883, TEXTURE, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
        String prevHighlighted = AccessoriesContainerSolver.INSTANCE.highlightedAccessory;
        AccessoriesContainerSolver.INSTANCE.highlightedAccessory = null;
        for (class_339 widget : this.widgets) {
            widget.method_25394(context, mouseX, mouseY, deltaTicks);
        }
        if (!ItemRepository.filesImported() || TooltipInfoType.ACCESSORIES.getData() == null) {
            this.refreshWhenDoneLoading = true;
            int x = this.method_46426() + this.method_25368() / 2;
            int y = this.method_46427() + this.method_25364() / 4;
            context.method_25300(class_310.method_1551().field_1772, "Loading...", x, y, -1);
            context.method_25300(class_310.method_1551().field_1772, class_7413.method_43449((long)class_156.method_658()), x, y + 10, -1);
        } else if (this.refreshWhenDoneLoading) {
            this.refreshWhenDoneLoading = false;
            this.refreshData();
        }
        if (!Objects.equals(prevHighlighted, AccessoriesContainerSolver.INSTANCE.highlightedAccessory)) {
            ContainerSolverManager.markHighlightsDirty();
        }
    }

    protected void method_47399(class_6382 builder) {
    }

    protected double method_44393() {
        return 0.0;
    }

    protected int method_44395() {
        return 0;
    }

    @Override
    public @Nullable class_1799 getFocusedItem() {
        return this.buttons.stream().map(ResultButton::getFocusedItem).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private static class TabButton
    extends class_344 {
        private final Consumer<TabButton> onToggled;
        private boolean toggled;

        TabButton(Consumer<TabButton> onToggled) {
            super(35, 27, class_512.field_45554, b -> {}, class_5244.field_39003);
            this.onToggled = onToggled;
        }

        public void method_75752(class_332 context, int mouseX, int mouseY, float deltaTicks) {
            int x = this.method_46426();
            if (this.toggled) {
                x -= 2;
            }
            context.method_52706(class_10799.field_56883, this.field_45356.method_52729(true, this.toggled), x, this.method_46427(), this.field_22758, this.field_22759);
            int offset = this.toggled ? -2 : 0;
            class_8666 buttonTextures = this.toggled ? class_513.field_45552 : class_513.field_45553;
            context.method_52706(class_10799.field_56883, buttonTextures.method_52729(false, this.method_49606()), this.method_46426() + offset + 9, this.method_46427() + (this.method_25364() - 17) / 2, 12, 17);
            if (this.method_49606()) {
                context.method_74037(class_11876.field_62455);
            }
        }

        public void method_25306(class_11907 input) {
            this.setToggled(!this.toggled);
        }

        public void setToggled(boolean toggled) {
            this.toggled = toggled;
            this.onToggled.accept(this);
        }
    }

    private class ArrowButton
    extends class_339 {
        private final boolean next;
        private final class_8666 textures;

        ArrowButton(boolean next) {
            super(0, 0, 12, 17, class_5244.field_39003);
            this.next = next;
            this.textures = next ? class_513.field_45552 : class_513.field_45553;
        }

        public void method_25348(class_11909 click, boolean doubled) {
            AccessoriesHelperWidget.this.changePage(this.next ? 1 : -1);
        }

        protected void method_48579(class_332 context, int mouseX, int mouseY, float deltaTicks) {
            context.method_52706(class_10799.field_56883, this.textures.method_52729(true, this.method_49606()), this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
            if (this.method_49606()) {
                context.method_74037(class_11876.field_62455);
            }
        }

        protected void method_47399(class_6382 builder) {
        }
    }

    private static class ResultButton
    extends SkyblockRecipeResultButton
    implements HoveredItemStackProvider {
        private @Nullable MagicPowerSource source;

        private ResultButton() {
        }

        private void setSource(MagicPowerSource source) {
            this.source = source;
            this.setDisplayStack(source.icon());
        }

        @Override
        protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            super.method_48579(context, mouseX, mouseY, delta);
            class_1799 stack = this.getDisplayStack();
            if (this.method_49606() && stack != null && this.source != null) {
                this.source.drawTooltip(context, mouseX, mouseY);
                context.method_74037(class_11876.field_62455);
            }
        }

        public void method_25348(class_11909 click, boolean doubled) {
            if (this.source != null) {
                this.source.click();
            }
        }

        @Override
        protected void clearDisplayStack() {
            super.clearDisplayStack();
        }

        @Override
        public @Nullable class_1799 getFocusedItem() {
            return this.method_49606() ? this.getDisplayStack() : null;
        }
    }

    private static enum Filter {
        ALL,
        MISSING,
        UPGRADES;


        public String toString() {
            return "skyblocker.accessoryHelper.filter." + this.name();
        }
    }

    private static interface MagicPowerSource {
        public class_1799 icon();

        public void drawTooltip(class_332 var1, int var2, int var3);

        public double pricePerMp();

        public void click();
    }

    private record AccessoryInfo(AccessoriesHelper.Accessory accessory, Optional<AccessoriesHelper.Accessory> highestOwned, AccessoriesHelper.Accessory highestInFamily) {

        private static class Source
        implements MagicPowerSource {
            private static final class_2561 smoothLine = LineSmoothener.createSmoothLine();
            private static final class_2561 wikiLine = class_2561.method_43471((String)"skyblocker.accessoryHelper.openWiki").method_27692(class_124.field_1054);
            private static final class_2561 fandomLine = class_2561.method_43471((String)"skyblocker.accessoryHelper.fandom").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056});
            private final AccessoryInfo info;
            private final @Nullable List<class_5481> afterSelling;
            private @Nullable class_1799 icon;

            private Source(AccessoryInfo info) {
                this.info = info;
                this.afterSelling = info.highestOwned().map(AccessoriesHelper.Accessory::id).map(ItemRepository::getItemStack).flatMap(accStack -> {
                    OptionalDouble priceOpt = AccessoriesHelperWidget.getPrice(info.accessory());
                    if (priceOpt.isEmpty()) {
                        return Optional.empty();
                    }
                    DoubleBooleanPair price = ItemUtils.getItemPrice(accStack);
                    if (!price.rightBoolean()) {
                        return Optional.empty();
                    }
                    class_5250 translatable = class_2561.method_43469((String)"skyblocker.accessoryHelper.afterSelling", (Object[])new Object[]{ItemTooltip.getCoinsMessage(priceOpt.getAsDouble() - price.leftDouble(), 1), accStack.method_7964()});
                    return Optional.of(class_310.method_1551().field_1772.method_1728((class_5348)translatable, 170));
                }).orElse(null);
            }

            @Override
            public class_1799 icon() {
                return this.icon != null ? this.icon : (this.icon = Optional.ofNullable(ItemRepository.getItemStack(this.info.accessory().id())).orElse(ItemUtils.getItemIdPlaceholder(this.info.accessory().id())));
            }

            @Override
            public void drawTooltip(class_332 context, int mouseX, int mouseY) {
                if (this.icon == null) {
                    return;
                }
                this.info.highestOwned().ifPresent(owned -> {
                    AccessoriesContainerSolver.INSTANCE.highlightedAccessory = owned.id();
                });
                class_310 client = class_310.method_1551();
                List tooltip = (List)class_437.method_25408((class_310)client, (class_1799)this.icon).stream().map(class_2561::method_30937).collect(class_156.method_58579());
                tooltip.add(smoothLine.method_30937());
                if (this.afterSelling != null) {
                    tooltip.addAll(this.afterSelling);
                    tooltip.add(class_5481.field_26385);
                }
                tooltip.add(wikiLine.method_30937());
                tooltip.add(fandomLine.method_30937());
                context.method_64236(client.field_1772, tooltip, mouseX, mouseY, (class_2960)this.icon.method_58694(class_9334.field_54198));
            }

            @Override
            public double pricePerMp() {
                class_1799 stack;
                OptionalDouble priceOpt = AccessoriesHelperWidget.getPrice(this.info.accessory());
                if (priceOpt.isEmpty()) {
                    return Double.MAX_VALUE;
                }
                double price = priceOpt.getAsDouble();
                int originalMP = 0;
                if (this.info.highestOwned().isPresent()) {
                    OptionalDouble ownedPrice = AccessoriesHelperWidget.getPrice(this.info.highestOwned().get());
                    price -= ownedPrice.orElse(0.0);
                    class_1799 stack2 = ItemRepository.getItemStack(this.info.highestOwned().get().id());
                    int n = originalMP = stack2 != null ? stack2.getSkyblockRarity().getMP() : 0;
                }
                if ((stack = ItemRepository.getItemStack(this.info.accessory().id())) == null) {
                    return Double.MAX_VALUE;
                }
                int mp = stack.getSkyblockRarity().getMP() - originalMP;
                return mp <= 0 ? Double.MAX_VALUE : price / (double)mp;
            }

            @Override
            public void click() {
                if (this.icon == null) {
                    return;
                }
                class_746 player = class_310.method_1551().field_1724;
                if (player == null) {
                    return;
                }
                WikiLookupManager.openWiki(this.icon, (class_1657)player, !class_310.method_1551().method_74187());
            }
        }
    }

    private static class RecombobulateSource
    implements MagicPowerSource {
        private final class_1799 icon = ItemRepository.getItemStack("RECOMBOBULATOR_3000", class_1799.field_8037);
        private final double pricePerMp;
        private final List<class_2561> tooltip;

        private RecombobulateSource(SkyblockItemRarity rarity) {
            DoubleBooleanPair pair = ItemUtils.getItemPrice("RECOMBOBULATOR_3000");
            double price = pair.rightBoolean() ? pair.leftDouble() : 6000000.0;
            int mp = rarity.recombobulate().getMP() - rarity.getMP();
            this.pricePerMp = mp <= 0 ? Double.MAX_VALUE : price / (double)mp;
            this.tooltip = List.of(class_2561.method_43469((String)"skyblocker.accessoryHelper.recombobulate", (Object[])new Object[]{class_2561.method_43470((String)rarity.name().replace("_", " ")).method_54663(rarity.color)}), ItemTooltip.getCoinsMessage(price, 1));
        }

        @Override
        public class_1799 icon() {
            return this.icon;
        }

        @Override
        public void drawTooltip(class_332 context, int mouseX, int mouseY) {
            class_327 textRenderer = class_310.method_1551().field_1772;
            context.method_51434(textRenderer, this.tooltip, mouseX, mouseY);
        }

        @Override
        public double pricePerMp() {
            return this.pricePerMp;
        }

        @Override
        public void click() {
            class_746 player = class_310.method_1551().field_1724;
            if (player == null) {
                return;
            }
            WikiLookupManager.openWikiLinkName("Recombobulator_3000#Usage", (class_1657)player, !class_310.method_1551().method_74187());
        }
    }
}

