/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.accessories.newyearcakes;

import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.utils.Formatters;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.container.SimpleContainerSolver;
import de.hysky.skyblocker.utils.render.gui.ColorHighlight;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewYearCakesHelper
extends SimpleContainerSolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(NewYearCakesHelper.class);
    private static final Pattern NEW_YEAR_CAKE = Pattern.compile("New Year Cake \\(Year (?<year>\\d+)\\)");
    private static final Pattern NEW_YEAR_CAKE_PURCHASE = Pattern.compile("You purchased New Year Cake \\(Year (?<year>\\d+)\\) for .+ coins!");
    public static final NewYearCakesHelper INSTANCE = new NewYearCakesHelper();
    private final Map<String, IntSet> cakes = new HashMap<String, IntSet>();

    private NewYearCakesHelper() {
        super("Auctions: \".*\"");
        ClientReceiveMessageEvents.ALLOW_GAME.register(this::onChatMessage);
    }

    public static int getCakeYear(class_1799 stack) {
        return NewYearCakesHelper.getCakeYear(NEW_YEAR_CAKE, stack.method_7964().getString());
    }

    public static int getCakeYear(Pattern pattern, String name) {
        Matcher matcher = pattern.matcher(name);
        if (matcher.matches()) {
            try {
                return Formatters.INTEGER_NUMBERS.parse(matcher.group("year")).intValue();
            }
            catch (ParseException e) {
                LOGGER.info("Failed to parse year from New Year Cake: " + name, (Throwable)e);
            }
        }
        return -1;
    }

    @Override
    public boolean isEnabled() {
        return SkyblockerConfigManager.get().helpers.enableNewYearCakesHelper;
    }

    public boolean addCake(int year) {
        if (year < 0) {
            return false;
        }
        return this.cakes.computeIfAbsent(Utils.getProfile(), _profile -> new IntOpenHashSet()).add(year);
    }

    private boolean onChatMessage(class_2561 message, boolean overlay) {
        if (this.isEnabled()) {
            this.addCake(NewYearCakesHelper.getCakeYear(NEW_YEAR_CAKE_PURCHASE, message.getString()));
        }
        return true;
    }

    @Override
    public List<ColorHighlight> getColors(Int2ObjectMap<class_1799> slots) {
        String profile = Utils.getProfile();
        if (this.cakes.isEmpty() || !this.cakes.containsKey(profile) || this.cakes.containsKey(profile) && this.cakes.get(profile).isEmpty()) {
            return List.of();
        }
        ArrayList<ColorHighlight> highlights = new ArrayList<ColorHighlight>();
        for (Int2ObjectMap.Entry entry : slots.int2ObjectEntrySet()) {
            int year = NewYearCakesHelper.getCakeYear((class_1799)entry.getValue());
            if (year < 0 || !this.cakes.containsKey(profile)) continue;
            highlights.add(this.cakes.get(profile).contains(year) ? ColorHighlight.red(entry.getIntKey()) : ColorHighlight.green(entry.getIntKey()));
        }
        return highlights;
    }
}

