/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.auction;

import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.compatibility.ResourcePackCompatibility;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.auction.AuctionHouseScreenHandler;
import de.hysky.skyblocker.skyblock.auction.widgets.AuctionTypeWidget;
import de.hysky.skyblocker.skyblock.auction.widgets.CategoryTabWidget;
import de.hysky.skyblocker.skyblock.auction.widgets.RarityWidget;
import de.hysky.skyblocker.skyblock.auction.widgets.SortWidget;
import de.hysky.skyblocker.skyblock.item.tooltip.info.TooltipInfoType;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.render.HudHelper;
import de.hysky.skyblocker.utils.render.gui.AbstractCustomHypixelGUI;
import it.unimi.dsi.fastutil.ints.Int2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import java.awt.Color;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_1058;
import net.minecraft.class_10725;
import net.minecraft.class_10799;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_5348;
import net.minecraft.class_7919;
import net.minecraft.class_9848;
import org.apache.commons.lang3.math.NumberUtils;
import org.joml.Matrix3x2fStack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuctionBrowserScreen
extends AbstractCustomHypixelGUI<AuctionHouseScreenHandler> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuctionBrowserScreen.class);
    private static final class_2960 TEXTURE = SkyblockerMod.id("textures/gui/auctions_gui/browser.png");
    private static final class_2960 SCROLLER_TEXTURE = class_2960.method_60656((String)"container/creative_inventory/scroller");
    private static final class_2960 up_arrow_tex = SkyblockerMod.id("up_arrow_even");
    private static final class_2960 down_arrow_tex = SkyblockerMod.id("down_arrow_even");
    public static final Supplier<class_1058> UP_ARROW = () -> class_310.method_1551().method_72703().method_73025(class_10725.field_56385).method_4608(up_arrow_tex);
    public static final Supplier<class_1058> DOWN_ARROW = () -> class_310.method_1551().method_72703().method_73025(class_10725.field_56385).method_4608(down_arrow_tex);
    public static final int RESET_BUTTON_SLOT = 47;
    public static final int SEARCH_BUTTON_SLOT = 48;
    public static final int BACK_BUTTON_SLOT = 49;
    public static final int SORT_BUTTON_SLOT = 50;
    public static final int RARITY_BUTTON_SLOT = 51;
    public static final int AUCTION_TYPE_BUTTON_SLOT = 52;
    public static final int PREV_PAGE_BUTTON = 46;
    public static final int NEXT_PAGE_BUTTON = 53;
    private final Int2BooleanOpenHashMap isSlotHighlighted = new Int2BooleanOpenHashMap(24);
    private SortWidget sortWidget;
    private AuctionTypeWidget auctionTypeWidget;
    private RarityWidget rarityWidget;
    private class_4185 resetFiltersButton;
    private final List<CategoryTabWidget> categoryTabWidgets = new ArrayList<CategoryTabWidget>(6);
    private String search = "";
    int currentPage = 0;
    int totalPages = 1;
    private boolean prevPageVisible = false;
    private boolean nextPageVisible = false;

    public AuctionBrowserScreen(AuctionHouseScreenHandler handler, class_1661 inventory) {
        super(handler, inventory, (class_2561)(ResourcePackCompatibility.options.renameAuctionBrowser().orElse(false) != false ? class_2561.method_43470((String)"AuctionBrowserSkyblocker") : class_2561.method_43470((String)"Auctions Browser")), 187);
        this.field_25267 = 999;
    }

    protected void method_25426() {
        super.method_25426();
        this.sortWidget = new SortWidget(this.field_2776 + 25, this.field_2800 + 81, (x$0, x$1) -> this.clickSlot(x$0, x$1));
        this.sortWidget.setSlotId(50);
        this.method_37063((class_364)this.sortWidget);
        this.auctionTypeWidget = new AuctionTypeWidget(this.field_2776 + 134, this.field_2800 + 77, (x$0, x$1) -> this.clickSlot(x$0, x$1));
        this.auctionTypeWidget.setSlotId(52);
        this.method_37063((class_364)this.auctionTypeWidget);
        this.rarityWidget = new RarityWidget(this.field_2776 + 73, this.field_2800 + 80, (x$0, x$1) -> this.clickSlot(x$0, x$1));
        this.rarityWidget.setSlotId(51);
        this.method_37063((class_364)this.rarityWidget);
        this.resetFiltersButton = new ScaledTextButtonWidget(this.field_2776 + 10, this.field_2800 + 77, 12, 12, (class_2561)class_2561.method_43470((String)"\u21bb"), this::onResetPressed);
        this.method_37063((class_364)this.resetFiltersButton);
        this.resetFiltersButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43470((String)"Reset Filters")));
        this.resetFiltersButton.method_47402(Duration.ofMillis(500L));
        this.method_37063((class_364)new class_4185.class_7840((class_2561)class_2561.method_43470((String)"<"), button -> this.clickSlot(49)).method_46433(this.field_2776 + 98, this.field_2800 + 4).method_46437(12, 12).method_46431());
        if (this.categoryTabWidgets.isEmpty()) {
            for (int i = 0; i < 6; ++i) {
                CategoryTabWidget categoryTabWidget = new CategoryTabWidget(new class_1799((class_1935)class_1802.field_8535), (x$0, x$1) -> this.clickSlot(x$0, x$1));
                this.categoryTabWidgets.add(categoryTabWidget);
                this.method_25429((class_364)categoryTabWidget);
                categoryTabWidget.method_48229(this.field_2776 - 30, this.field_2800 + 3 + i * 28);
            }
        } else {
            for (int i = 0; i < this.categoryTabWidgets.size(); ++i) {
                CategoryTabWidget categoryTabWidget = this.categoryTabWidgets.get(i);
                categoryTabWidget.method_48229(this.field_2776 - 30, this.field_2800 + 3 + i * 28);
                this.method_25429((class_364)categoryTabWidget);
            }
        }
    }

    private void onResetPressed(class_4185 buttonWidget) {
        buttonWidget.method_25365(false);
        this.clickSlot(47, 0);
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        context.method_25290(class_10799.field_56883, TEXTURE, this.field_2776, this.field_2800, 0.0f, 0.0f, this.field_2792, this.field_2779, 256, 256);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        for (CategoryTabWidget categoryTabWidget : this.categoryTabWidgets) {
            categoryTabWidget.method_25394(context, mouseX, mouseY, delta);
        }
        if (this.isWaitingForServer) {
            String waiting = "Waiting for server...";
            int n = this.field_22789 - this.field_22793.method_1727(waiting) - 5;
            Objects.requireNonNull(this.field_22793);
            context.method_51433(this.field_22793, waiting, n, this.field_22790 - 9 - 2, -1, true);
        }
        Matrix3x2fStack matrices = context.method_51448();
        matrices.pushMatrix();
        matrices.translate((float)this.field_2776, (float)this.field_2800);
        context.method_44379(7, 4, 97, 16);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)this.search).method_27696(class_2583.field_24360.method_30938(Boolean.valueOf(this.onSearchField(mouseX, mouseY)))), 9, 6, -1, true);
        context.method_44380();
        if (this.prevPageVisible) {
            if (this.onScrollbarTop(mouseX, mouseY)) {
                context.method_52709(class_10799.field_56883, UP_ARROW.get(), 159, 13, 6, 3);
            } else {
                context.method_52710(class_10799.field_56883, UP_ARROW.get(), 159, 13, 6, 3, class_9848.method_61323((int)137, (int)137, (int)137));
            }
        }
        if (this.nextPageVisible) {
            if (this.onScrollbarBottom(mouseX, mouseY)) {
                context.method_52709(class_10799.field_56883, DOWN_ARROW.get(), 159, 72, 6, 3);
            } else {
                context.method_52710(class_10799.field_56883, DOWN_ARROW.get(), 159, 72, 6, 3, class_9848.method_61323((int)137, (int)137, (int)137));
            }
        }
        context.method_51433(this.field_22793, String.format("%d/%d", this.currentPage, this.totalPages), 111, 6, -8355712, false);
        if (this.totalPages <= 1) {
            context.method_52706(class_10799.field_56883, SCROLLER_TEXTURE, 156, 18, 12, 15);
        } else {
            context.method_52706(class_10799.field_56883, SCROLLER_TEXTURE, 156, (int)(18.0f + (float)(Math.min(this.currentPage, this.totalPages) - 1) / (float)(this.totalPages - 1) * 37.0f), 12, 15);
        }
        matrices.popMatrix();
        this.method_2380(context, mouseX, mouseY);
    }

    protected void method_2385(class_332 context, class_1735 slot, int mouseX, int mouseY) {
        if (SkyblockerConfigManager.get().uiAndVisuals.fancyAuctionHouse.highlightCheapBIN && slot.method_7681() && this.isSlotHighlighted.getOrDefault(slot.field_7874, false)) {
            HudHelper.drawBorder(context, slot.field_7873, slot.field_7872, 16, 16, new Color(0, 255, 0, 100).getRGB());
        }
        super.method_2385(context, slot, mouseX, mouseY);
    }

    protected void method_2383(class_1735 slot, int slotId, int button, class_1713 actionType) {
        if (slotId >= ((AuctionHouseScreenHandler)this.field_2797).method_17388() * 9) {
            return;
        }
        super.method_2383(slot, slotId, button, actionType);
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        if (this.isWaitingForServer) {
            return super.method_25402(click, doubled);
        }
        if (this.onScrollbarTop((int)click.comp_4798(), (int)click.comp_4799()) && this.prevPageVisible) {
            this.clickSlot(46);
            return true;
        }
        if (this.onScrollbarBottom((int)click.comp_4798(), (int)click.comp_4799()) && this.nextPageVisible) {
            this.clickSlot(53);
            return true;
        }
        if (this.onSearchField((int)click.comp_4798(), (int)click.comp_4799())) {
            this.clickSlot(48);
            return true;
        }
        return super.method_25402(click, doubled);
    }

    private boolean onScrollbarTop(int mouseX, int mouseY) {
        int localX = mouseX - this.field_2776;
        int localY = mouseY - this.field_2800;
        return localX > 154 && localX < 169 && localY > 6 && localY < 44;
    }

    private boolean onScrollbarBottom(int mouseX, int mouseY) {
        int localX = mouseX - this.field_2776;
        int localY = mouseY - this.field_2800;
        return localX > 154 && localX < 169 && localY > 43 && localY < 80;
    }

    private boolean onSearchField(int mouseX, int mouseY) {
        int localX = mouseX - this.field_2776;
        int localY = mouseY - this.field_2800;
        return localX > 6 && localX < 97 && localY > 3 && localY < 16;
    }

    @Override
    public void onSlotChange(AuctionHouseScreenHandler handler, int slotId, class_1799 stack) {
        if (stack.method_7960()) {
            return;
        }
        this.isWaitingForServer = false;
        block0 : switch (slotId) {
            case 46: {
                this.prevPageVisible = false;
                if (!stack.method_31574(class_1802.field_8107)) break;
                this.prevPageVisible = true;
                this.parsePage(stack);
                break;
            }
            case 53: {
                this.nextPageVisible = false;
                if (!stack.method_31574(class_1802.field_8107)) break;
                this.nextPageVisible = true;
                this.parsePage(stack);
                break;
            }
            case 50: {
                this.sortWidget.setCurrent(SortWidget.Option.get(AuctionBrowserScreen.getOrdinal(stack.skyblocker$getLoreStrings())));
                break;
            }
            case 52: {
                this.auctionTypeWidget.setCurrent(AuctionTypeWidget.Option.get(AuctionBrowserScreen.getOrdinal(stack.skyblocker$getLoreStrings())));
                break;
            }
            case 51: {
                int ordinal = AuctionBrowserScreen.getOrdinal(stack.skyblocker$getLoreStrings());
                List<class_2561> tooltip = ItemUtils.getLore(stack);
                String split = tooltip.get(ordinal + 1).getString().substring(2);
                this.rarityWidget.setText(tooltip.subList(1, tooltip.size() - 3), split);
                break;
            }
            case 47: {
                this.resetFiltersButton.field_22763 = handler.method_7611(slotId).method_7677().method_31574(class_1802.field_8782);
                break;
            }
            case 48: {
                List tooltipSearch = stack.skyblocker$getLoreStrings();
                for (String string : tooltipSearch) {
                    if (!string.contains("Filtered:")) continue;
                    String[] splitSearch = string.split(":");
                    if (splitSearch.length < 2) {
                        this.search = "";
                        break block0;
                    }
                    this.search = splitSearch[1].trim();
                    break block0;
                }
                break;
            }
            default: {
                if (slotId < ((AuctionHouseScreenHandler)this.field_2797).method_17388() * 9 && slotId % 9 == 0) {
                    CategoryTabWidget categoryTabWidget = this.categoryTabWidgets.get(slotId / 9);
                    categoryTabWidget.setSlotId(slotId);
                    categoryTabWidget.setIcon(handler.method_7611(slotId).method_7677());
                    List tooltipDefault = handler.method_7611(slotId).method_7677().skyblocker$getLoreStrings();
                    for (int j = tooltipDefault.size() - 1; j >= 0; --j) {
                        String lowerCase = ((String)tooltipDefault.get(j)).toLowerCase(Locale.ENGLISH);
                        if (lowerCase.contains("currently")) {
                            categoryTabWidget.select();
                            break block0;
                        }
                        if (lowerCase.contains("click")) {
                            categoryTabWidget.unselect();
                            break block0;
                        }
                        categoryTabWidget.unselect();
                    }
                } else {
                    if (slotId <= 9 || slotId >= (handler.method_17388() - 1) * 9 || slotId % 9 <= 1 || slotId % 9 >= 8) break;
                    Object2DoubleMap<String> data = TooltipInfoType.THREE_DAY_AVERAGE.getData();
                    if (!SkyblockerConfigManager.get().uiAndVisuals.fancyAuctionHouse.highlightCheapBIN || data == null) {
                        return;
                    }
                    List tooltip = stack.skyblocker$getLoreStrings();
                    for (int k = tooltip.size() - 1; k >= 0; --k) {
                        String[] split;
                        String string = (String)tooltip.get(k);
                        if (!string.toLowerCase(Locale.ENGLISH).contains("buy it now:") || (split = string.split(":")).length < 2) continue;
                        String coins = split[1].replace(",", "").replace("coins", "").trim();
                        long parsed = NumberUtils.toLong((String)coins, (long)Long.MAX_VALUE);
                        double price = data.getDouble((Object)stack.getNeuName());
                        this.isSlotHighlighted.put(slotId, price > (double)parsed);
                    }
                }
                break;
            }
        }
    }

    public boolean method_25404(class_11908 input) {
        if (input.method_74234() && this.prevPageVisible) {
            this.clickSlot(46);
            return true;
        }
        if (input.method_74235() && this.nextPageVisible) {
            this.clickSlot(53);
            return true;
        }
        return super.method_25404(input);
    }

    private static int getOrdinal(List<String> tooltip) {
        int ordinal = 0;
        for (int j = 0; j < tooltip.size() - 4 && j + 1 < tooltip.size(); ++j) {
            if (!tooltip.get(j + 1).contains("\u25b6")) continue;
            ordinal = j;
            break;
        }
        return ordinal;
    }

    private void parsePage(class_1799 stack) {
        try {
            List tooltip = stack.skyblocker$getLoreStrings();
            String str = ((String)tooltip.getFirst()).trim();
            str = str.substring(1, str.length() - 1);
            String[] parts = str.split("/");
            this.currentPage = Integer.parseInt(parts[0].replace(",", ""));
            this.totalPages = Integer.parseInt(parts[1].replace(",", ""));
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker Fancy Auction House] Failed to parse page arrow", (Throwable)e);
        }
    }

    protected boolean method_2381(double mouseX, double mouseY, int left, int top) {
        return mouseX < (double)left - 32.0 || mouseY < (double)top || mouseX >= (double)(left + this.field_2792) || mouseY >= (double)(top + this.field_2779);
    }

    private static class ScaledTextButtonWidget
    extends class_4185 {
        protected ScaledTextButtonWidget(int x, int y, int width, int height, class_2561 message, class_4185.class_4241 onPress) {
            super(x, y, width, height, message, onPress, Supplier::get);
        }

        public void method_75752(class_332 context, int mouseX, int mouseY, float deltaTicks) {
            this.method_75794(context);
            class_327 font = class_310.method_1551().field_1772;
            Matrix3x2fStack matrices = context.method_51448();
            float textScale = 2.0f;
            matrices.pushMatrix();
            float f = (float)this.method_46426() + (float)this.field_22758 / 2.0f - (float)font.method_27525((class_5348)this.method_25369()) * textScale / 2.0f + 1.0f;
            float f2 = this.method_46427();
            float f3 = this.field_22759;
            Objects.requireNonNull(font);
            matrices.translate(f, f2 + (f3 - 9.0f * textScale) / 2.0f - 1.0f);
            matrices.scale(textScale, textScale);
            context.method_51439(font, this.method_25369(), 0, 0, 0xFFFFFFFF | class_3532.method_15386((float)(this.field_22765 * 255.0f)) << 24, true);
            matrices.popMatrix();
        }
    }
}

