/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.barn;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.events.ParticleEvents;
import de.hysky.skyblocker.utils.Area;
import de.hysky.skyblocker.utils.ColorUtils;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.render.RenderHelper;
import de.hysky.skyblocker.utils.render.WorldRenderExtractionCallback;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveCollector;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import de.hysky.skyblocker.utils.waypoint.SeenWaypoint;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.minecraft.class_1269;
import net.minecraft.class_1767;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_2675;
import net.minecraft.class_310;

public class GlowingMushrooms {
    private static final class_310 client = class_310.method_1551();
    private static final Map<class_2338, GlowingMushroom> glowingMushrooms = new HashMap<class_2338, GlowingMushroom>();

    @Init
    public static void init() {
        ParticleEvents.FROM_SERVER.register(GlowingMushrooms::onParticle);
        Scheduler.INSTANCE.scheduleCyclic(GlowingMushrooms::update, 1);
        WorldRenderExtractionCallback.EVENT.register(GlowingMushrooms::extractRendering);
        AttackBlockCallback.EVENT.register((player, world, hand, pos, direction) -> {
            if (GlowingMushrooms.shouldProcess()) {
                glowingMushrooms.remove(pos);
            }
            return class_1269.field_5811;
        });
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> GlowingMushrooms.reset());
    }

    public static void onParticle(class_2675 packet) {
        if (!GlowingMushrooms.shouldProcess() || GlowingMushrooms.client.field_1687 == null) {
            return;
        }
        if (!class_2398.field_11226.equals(packet.method_11551().method_10295())) {
            return;
        }
        class_2338 pos = class_2338.method_49637((double)packet.method_11544(), (double)packet.method_11547(), (double)packet.method_11546());
        class_2248 block = GlowingMushrooms.client.field_1687.method_8320(pos).method_26204();
        if (block != class_2246.field_10559 && block != class_2246.field_10251) {
            return;
        }
        GlowingMushroom mushroom = glowingMushrooms.computeIfAbsent(pos, GlowingMushroom::new);
        mushroom.addParticle();
    }

    private static void update() {
        if (!GlowingMushrooms.shouldProcess()) {
            return;
        }
        for (GlowingMushroom glowingMushroom : glowingMushrooms.values()) {
            glowingMushroom.updateWaypoint();
        }
    }

    private static void extractRendering(PrimitiveCollector collector) {
        if (!GlowingMushrooms.shouldProcess() || GlowingMushrooms.client.field_1687 == null) {
            return;
        }
        for (GlowingMushroom glowingMushroom : glowingMushrooms.values()) {
            class_2248 block;
            if (!glowingMushroom.shouldRender() || (block = GlowingMushrooms.client.field_1687.method_8320(glowingMushroom.pos).method_26204()) != class_2246.field_10559 && block != class_2246.field_10251) continue;
            class_238 boundingBox = RenderHelper.getBlockBoundingBox(GlowingMushrooms.client.field_1687, glowingMushroom.pos);
            collector.submitOutlinedBox(boundingBox, ColorUtils.getFloatComponents(class_1767.field_7947), 3.0f, glowingMushroom.shouldRenderThroughWalls());
        }
    }

    private static boolean shouldProcess() {
        return SkyblockerConfigManager.get().otherLocations.barn.enableGlowingMushroomHelper && Utils.isInFarm() && Utils.getArea() == Area.TheFarmingIslands.GLOWING_MUSHROOM_CAVE;
    }

    private static void reset() {
        glowingMushrooms.clear();
    }

    public static class GlowingMushroom
    extends SeenWaypoint {
        private int particleCount = 0;
        private long lastConfirmed;

        private GlowingMushroom(class_2338 pos) {
            super(pos, () -> SkyblockerConfigManager.get().uiAndVisuals.waypoints.waypointType, ColorUtils.getFloatComponents(class_1767.field_7955));
        }

        private void updateWaypoint() {
            super.tick(client);
            if (this.particleCount < 1) {
                return;
            }
            long now = System.currentTimeMillis();
            if (this.lastConfirmed + 2000L > now) {
                return;
            }
            this.lastConfirmed = now;
            this.particleCount = 0;
        }

        public void addParticle() {
            ++this.particleCount;
        }

        @Override
        public boolean shouldRender() {
            return super.shouldRender() && this.lastConfirmed + 5000L > System.currentTimeMillis();
        }
    }
}

