/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.calculators;

import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.utils.Calculator;
import de.hysky.skyblocker.utils.Formatters;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.jetbrains.annotations.VisibleForTesting;

public class SignCalculator {
    private static final class_310 CLIENT = class_310.method_1551();
    private static String lastInput;
    private static double output;
    private static class_2561 error;

    public static void renderCalculator(class_332 context, String message, int renderX, int renderY) {
        if (SkyblockerConfigManager.get().uiAndVisuals.inputCalculator.requiresEquals && !message.startsWith("=")) {
            output = -1.0;
            error = null;
            lastInput = message;
            return;
        }
        if (message.startsWith("=")) {
            message = message.substring(1);
        }
        SignCalculator.calculate(message);
        SignCalculator.render(context, message, renderX, renderY);
    }

    @VisibleForTesting
    public static void calculate(String message) {
        if (!message.equals(lastInput)) {
            lastInput = message;
            try {
                output = Calculator.calculate(message);
                error = null;
            }
            catch (Calculator.CalculatorException e) {
                output = -1.0;
                error = class_2561.method_43469((String)e.getMessage(), (Object[])e.args).method_27692(class_124.field_1061);
            }
        }
    }

    public static String getNewValue(boolean isPrice) {
        if (output == -1.0) {
            return lastInput;
        }
        if (isPrice) {
            return String.valueOf((double)Math.round(output * 100.0) / 100.0);
        }
        return Long.toString(Math.round(output));
    }

    private static void render(class_332 context, String input, int renderX, int renderY) {
        Object text = output == -1.0 ? (error != null ? error : class_2561.method_43471((String)"skyblocker.config.uiAndVisuals.inputCalculator.invalidEquation").method_27692(class_124.field_1061)) : class_2561.method_43470((String)(input + " = " + Formatters.DOUBLE_NUMBERS.format(output))).method_27692(class_124.field_1060);
        context.method_27534(SignCalculator.CLIENT.field_1772, text, renderX, renderY, -1);
    }
}

