/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.chat;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.utils.CollectionUtils;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.Location;
import de.hysky.skyblocker.utils.Utils;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;

public class ChatRule {
    @VisibleForTesting
    static final Codec<EnumSet<Location>> LOCATION_FIXING_CODEC = Codec.either(Location.SET_CODEC, (Codec)Codec.STRING).xmap(either -> (EnumSet)either.map(Function.identity(), ChatRule::encodeString), Either::left);
    private static final UnaryOperator<Optional<String>> REMOVE_BLANK = opt -> opt.flatMap(s -> s.isBlank() ? Optional.empty() : Optional.of(s));
    private static final Codec<ChatRule> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(ChatRule::getName), (App)Codec.BOOL.fieldOf("enabled").forGetter(ChatRule::getEnabled), (App)Codec.BOOL.fieldOf("partialMatch").forGetter(ChatRule::getPartialMatch), (App)Codec.BOOL.fieldOf("regex").forGetter(ChatRule::getRegex), (App)Codec.BOOL.fieldOf("ignoreCase").forGetter(ChatRule::getIgnoreCase), (App)Codec.STRING.fieldOf("filter").forGetter(ChatRule::getFilter), (App)LOCATION_FIXING_CODEC.fieldOf("locations").forGetter(ChatRule::getValidLocations), (App)Codec.BOOL.fieldOf("hideOriginalMessage").forGetter(ChatRule::getHideMessage), (App)Codec.STRING.optionalFieldOf("chatMessage").xmap(REMOVE_BLANK, REMOVE_BLANK).forGetter(ChatRule::getChatMessageOptional), (App)Codec.STRING.optionalFieldOf("actionbarMessage").xmap(REMOVE_BLANK, REMOVE_BLANK).forGetter(ChatRule::getActionBarMessageOptional), (App)AnnouncementMessage.CODEC.optionalFieldOf("announcementMessage").forGetter(ChatRule::getAnnouncementMessageOptional), (App)ToastMessage.CODEC.optionalFieldOf("toastMessage").forGetter(ChatRule::getToastMessageOptional), (App)class_3414.field_41698.optionalFieldOf("customSound").forGetter(ChatRule::getCustomSoundOptional)).apply((Applicative)instance, (s, aBoolean, aBoolean2, aBoolean3, aBoolean4, s2, locations, aBoolean5, s3, s4, s5, toastMessage1, soundEvent) -> new ChatRule((String)s, (boolean)aBoolean, (boolean)aBoolean2, (boolean)aBoolean3, (boolean)aBoolean4, (String)s2, (EnumSet<Location>)locations, (boolean)aBoolean5, s3.orElse(null), s4.orElse(null), s5.orElse(null), toastMessage1.orElse(null), soundEvent.orElse(null))));
    public static final Codec<List<ChatRule>> LIST_CODEC = CODEC.listOf();
    private String name;
    private @Nullable Pattern pattern;
    private boolean enabled;
    private boolean isPartialMatch;
    private boolean isRegex;
    private boolean isIgnoreCase;
    private String filter;
    private EnumSet<Location> validLocations;
    private boolean hideMessage;
    private @Nullable String chatMessage;
    private @Nullable String actionBarMessage;
    private @Nullable AnnouncementMessage announcementMessage;
    private @Nullable ToastMessage toastMessage;
    private @Nullable class_3414 customSound;

    protected ChatRule() {
        this.name = "New Rule";
        this.enabled = true;
        this.isPartialMatch = false;
        this.isRegex = false;
        this.isIgnoreCase = true;
        this.filter = "";
        this.validLocations = EnumSet.noneOf(Location.class);
        this.hideMessage = true;
        this.chatMessage = null;
        this.actionBarMessage = null;
        this.announcementMessage = null;
        this.toastMessage = null;
        this.customSound = null;
    }

    ChatRule(String name, boolean enabled, boolean isPartialMatch, boolean isRegex, boolean isIgnoreCase, String filter, EnumSet<Location> validLocations, boolean hideMessage, @Nullable String chatMessage, @Nullable String actionBarMessage, @Nullable AnnouncementMessage announcementMessage, @Nullable ToastMessage toastMessage, @Nullable class_3414 customSound) {
        this.name = name;
        this.enabled = enabled;
        this.isPartialMatch = isPartialMatch;
        this.isRegex = isRegex;
        this.isIgnoreCase = isIgnoreCase;
        this.filter = filter;
        this.validLocations = validLocations;
        this.hideMessage = hideMessage;
        this.chatMessage = chatMessage;
        this.actionBarMessage = actionBarMessage;
        this.announcementMessage = announcementMessage;
        this.toastMessage = toastMessage;
        this.customSound = customSound;
    }

    protected String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected boolean getEnabled() {
        return this.enabled;
    }

    protected void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    protected boolean getPartialMatch() {
        return this.isPartialMatch;
    }

    protected void setPartialMatch(boolean partialMatch) {
        this.isPartialMatch = partialMatch;
    }

    protected boolean getRegex() {
        return this.isRegex;
    }

    protected void setRegex(boolean regex) {
        this.isRegex = regex;
        this.pattern = null;
    }

    protected boolean getIgnoreCase() {
        return this.isIgnoreCase;
    }

    protected void setIgnoreCase(boolean ignoreCase) {
        this.isIgnoreCase = ignoreCase;
        this.pattern = null;
    }

    protected String getFilter() {
        return this.filter;
    }

    protected void setFilter(String filter) {
        this.filter = filter;
        this.pattern = null;
    }

    protected boolean getHideMessage() {
        return this.hideMessage;
    }

    protected void setHideMessage(boolean hideMessage) {
        this.hideMessage = hideMessage;
    }

    @Nullable String getActionBarMessage() {
        return this.actionBarMessage;
    }

    private Optional<String> getActionBarMessageOptional() {
        return Optional.ofNullable(this.getActionBarMessage());
    }

    void setActionBarMessage(@Nullable String actionBarMessage) {
        if (actionBarMessage != null && actionBarMessage.isBlank()) {
            actionBarMessage = null;
        }
        this.actionBarMessage = actionBarMessage;
    }

    @Nullable String getChatMessage() {
        return this.chatMessage;
    }

    private Optional<String> getChatMessageOptional() {
        return Optional.ofNullable(this.getChatMessage());
    }

    void setChatMessage(@Nullable String chatMessage) {
        if (chatMessage != null && chatMessage.isBlank()) {
            chatMessage = null;
        }
        this.chatMessage = chatMessage;
    }

    @Nullable AnnouncementMessage getAnnouncementMessage() {
        return this.announcementMessage;
    }

    private Optional<AnnouncementMessage> getAnnouncementMessageOptional() {
        return Optional.ofNullable(this.getAnnouncementMessage());
    }

    void setAnnouncementMessage(@Nullable AnnouncementMessage announcementMessage) {
        this.announcementMessage = announcementMessage;
    }

    @Nullable ToastMessage getToastMessage() {
        return this.toastMessage;
    }

    private Optional<ToastMessage> getToastMessageOptional() {
        return Optional.ofNullable(this.getToastMessage());
    }

    void setToastMessage(@Nullable ToastMessage toastMessage) {
        this.toastMessage = toastMessage;
    }

    protected @Nullable class_3414 getCustomSound() {
        return this.customSound;
    }

    private Optional<class_3414> getCustomSoundOptional() {
        return Optional.ofNullable(this.getCustomSound());
    }

    protected void setCustomSound(@Nullable class_3414 customSound) {
        this.customSound = customSound;
    }

    protected EnumSet<Location> getValidLocations() {
        return this.validLocations;
    }

    protected void setValidLocations(EnumSet<Location> validLocations) {
        this.validLocations = validLocations;
    }

    private void compilePattern(String filterText) {
        if (this.pattern != null) {
            return;
        }
        try {
            this.pattern = Pattern.compile(filterText);
        }
        catch (PatternSyntaxException ex) {
            this.enabled = false;
            class_310 client = class_310.method_1551();
            if (client.field_1724 == null) {
                return;
            }
            client.field_1724.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43469((String)"skyblocker.config.chat.chatRules.invalidRegex", (Object[])new Object[]{this.name})), false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Match isMatch(String inputString) {
        Match match;
        String testFilter;
        if (!this.enabled) {
            return Match.noMatch();
        }
        String testString = this.isIgnoreCase ? inputString.toLowerCase(Locale.ENGLISH) : inputString;
        String string = testFilter = this.isIgnoreCase ? this.filter.toLowerCase(Locale.ENGLISH) : this.filter;
        if (testFilter.isBlank()) {
            return Match.noMatch();
        }
        if (this.isRegex) {
            this.compilePattern(testFilter);
            if (this.pattern == null) {
                return Match.noMatch();
            }
            Matcher matcher = this.pattern.matcher(testString);
            if (this.isPartialMatch) {
                if (!matcher.find()) return Match.noMatch();
                match = Match.ofRegex(matcher);
            } else {
                if (!matcher.matches()) return Match.noMatch();
                match = Match.ofRegex(matcher);
            }
        } else if (this.isPartialMatch) {
            if (!testString.contains(testFilter)) return Match.noMatch();
            match = Match.ofString();
        } else {
            if (!testFilter.equals(testString)) return Match.noMatch();
            match = Match.ofString();
        }
        if (this.validLocations.isEmpty()) {
            return match;
        }
        if (this.validLocations.size() != 1 || !this.validLocations.contains((Object)Location.UNKNOWN)) return this.validLocations.contains((Object)Utils.getLocation()) ? match : Match.noMatch();
        return match;
    }

    private static EnumSet<Location> encodeString(String string) {
        if (string.isEmpty()) {
            return EnumSet.noneOf(Location.class);
        }
        if (string.contains("!")) {
            return EnumSet.complementOf(Arrays.stream(string.split(", ?")).filter(s1 -> s1.startsWith("!")).map(s -> s.substring(1)).map(Location::fromFriendlyName).collect(CollectionUtils.enumSetCollector(Location.class)));
        }
        return Arrays.stream(string.split(", ?")).map(Location::fromFriendlyName).collect(CollectionUtils.enumSetCollector(Location.class));
    }

    public final boolean equals(Object o) {
        if (!(o instanceof ChatRule)) {
            return false;
        }
        ChatRule chatRule = (ChatRule)o;
        return this.getEnabled() == chatRule.getEnabled() && this.getPartialMatch() == chatRule.getPartialMatch() && this.getRegex() == chatRule.getRegex() && this.getIgnoreCase() == chatRule.getIgnoreCase() && this.getHideMessage() == chatRule.getHideMessage() && this.getName().equals(chatRule.getName()) && this.getFilter().equals(chatRule.getFilter()) && this.getValidLocations().equals(chatRule.getValidLocations()) && Objects.equals(this.getChatMessage(), chatRule.getChatMessage()) && Objects.equals(this.getActionBarMessage(), chatRule.getActionBarMessage()) && Objects.equals(this.getAnnouncementMessage(), chatRule.getAnnouncementMessage()) && Objects.equals(this.getToastMessage(), chatRule.getToastMessage()) && Objects.equals(this.getCustomSound(), chatRule.getCustomSound());
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.getEnabled(), this.getPartialMatch(), this.getRegex(), this.getIgnoreCase(), this.getFilter(), this.getValidLocations(), this.getHideMessage(), this.getChatMessage(), this.getActionBarMessage(), this.getActionBarMessage(), this.getAnnouncementMessage(), this.getToastMessage(), this.getCustomSound());
    }

    public String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{ChatRule.class, "name;pattern;enabled;isPartialMatch;isRegex;isIgnoreCase;filter;validLocations;hideMessage;chatMessage;actionBarMessage;announcementMessage;toastMessage;customSound", "name", "pattern", "enabled", "isPartialMatch", "isRegex", "isIgnoreCase", "filter", "validLocations", "hideMessage", "chatMessage", "actionBarMessage", "announcementMessage", "toastMessage", "customSound"}, this);
    }

    static class AnnouncementMessage {
        static final Codec<AnnouncementMessage> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("message").forGetter(o -> o.message), (App)Codec.LONG.fieldOf("displayDuration").forGetter(o -> o.displayDuration)).apply((Applicative)instance, AnnouncementMessage::new));
        String message;
        long displayDuration;

        AnnouncementMessage(String message, long displayDuration) {
            this.message = message;
            this.displayDuration = displayDuration;
        }

        AnnouncementMessage() {
            this("", (long)SkyblockerConfigManager.get().chat.chatRuleConfig.announcementLength * 50L);
        }

        public String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{AnnouncementMessage.class, "message;displayDuration", "message", "displayDuration"}, this);
        }

        public boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{AnnouncementMessage.class, "message;displayDuration", "message", "displayDuration"}, this, object);
        }

        public int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{AnnouncementMessage.class, "message;displayDuration", "message", "displayDuration"}, this);
        }
    }

    static class ToastMessage {
        static final Codec<ToastMessage> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1799.field_49266.optionalFieldOf("icon", (Object)class_1799.field_8037).forGetter(o -> o.icon), (App)Codec.STRING.fieldOf("message").forGetter(o -> o.message), (App)Codec.LONG.fieldOf("displayDuration").forGetter(o -> o.displayDuration)).apply((Applicative)instance, ToastMessage::new));
        class_1799 icon;
        String message;
        long displayDuration;

        ToastMessage(class_1799 icon, String message, long displayDuration) {
            this.message = message;
            this.icon = icon;
            this.displayDuration = displayDuration;
        }

        ToastMessage() {
            this(new class_1799((class_1935)class_1802.field_8892), "", 1000L);
        }

        public String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ToastMessage.class, "icon;message;displayDuration", "icon", "message", "displayDuration"}, this);
        }

        public boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ToastMessage.class, "icon;message;displayDuration", "icon", "message", "displayDuration"}, this, object);
        }

        public int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ToastMessage.class, "icon;message;displayDuration", "icon", "message", "displayDuration"}, this);
        }
    }

    protected record Match(boolean matches, Optional<Matcher> matcher) {
        protected static Match noMatch() {
            return new Match(false, Optional.empty());
        }

        protected static Match ofString() {
            return new Match(true, Optional.empty());
        }

        protected static Match ofRegex(Matcher matcher) {
            return new Match(true, Optional.of(matcher));
        }

        protected String insertCaptureGroups(String replaceMessage) {
            if (!this.matches || this.matcher.isEmpty()) {
                return replaceMessage;
            }
            StringBuilder sb = new StringBuilder();
            Matcher m = this.matcher.get();
            m.reset();
            if (!m.find()) {
                return replaceMessage;
            }
            m.appendReplacement(sb, replaceMessage);
            return sb.substring(m.start());
        }
    }
}

