/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.chat;

import de.hysky.skyblocker.skyblock.chat.ChatRule;
import de.hysky.skyblocker.skyblock.chat.ChatRuleConfigScreen;
import de.hysky.skyblocker.skyblock.chat.ChatRulesConfigScreen;
import de.hysky.skyblocker.skyblock.chat.ChatRulesHandler;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import java.awt.Color;
import java.util.List;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_6379;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.minecraft.class_8667;

public class ChatRulesConfigListWidget
extends class_4265<AbstractChatRuleEntry> {
    private static final int ROW_HEIGHT = 26;
    private final ChatRulesConfigScreen screen;
    private boolean hasChanged;

    public ChatRulesConfigListWidget(class_310 client, ChatRulesConfigScreen screen, int width, int height, int y) {
        super(client, width, height, y, 26);
        this.screen = screen;
        this.hasChanged = false;
        this.updateEntries();
    }

    public void updateEntries() {
        this.method_25339();
        this.method_25321((class_350.class_351)new LabelsEntry());
        for (int i = 0; i < ChatRulesHandler.CHAT_RULE_LIST.getData().size(); ++i) {
            this.method_25321((class_350.class_351)new ChatRuleEntry(i));
        }
    }

    public int method_25322() {
        return 320;
    }

    protected boolean method_73379() {
        return true;
    }

    protected void addRuleAfterSelected() {
        this.hasChanged = true;
        int newIndex = Math.max(this.method_25396().indexOf(this.method_25334()), 0);
        ChatRulesHandler.CHAT_RULE_LIST.getData().add(newIndex, new ChatRule());
        this.updateEntries();
        if (newIndex + 1 >= this.method_25396().size()) {
            return;
        }
        AbstractChatRuleEntry entry = (AbstractChatRuleEntry)((Object)this.method_25396().get(newIndex + 1));
        Scheduler.INSTANCE.schedule(() -> this.method_25313((class_350.class_351)entry), 0);
    }

    protected void removeEntry(AbstractChatRuleEntry entry) {
        super.method_25330((class_350.class_351)entry);
        this.hasChanged = true;
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        if (super.method_25402(click, doubled)) {
            return true;
        }
        this.method_25313(null);
        return false;
    }

    protected void saveRules() {
        this.hasChanged = false;
        ChatRulesHandler.saveChatRules();
    }

    protected boolean hasChanges() {
        return this.hasChanged || this.method_25396().stream().anyMatch(AbstractChatRuleEntry::hasChanged);
    }

    private class LabelsEntry
    extends AbstractChatRuleEntry {
        private LabelsEntry() {
        }

        public List<? extends class_6379> method_37025() {
            return List.of();
        }

        public List<? extends class_364> method_25396() {
            return List.of();
        }

        public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
            context.method_27534(((ChatRulesConfigListWidget)ChatRulesConfigListWidget.this).field_22740.field_1772, (class_2561)class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.ruleName"), ChatRulesConfigListWidget.this.method_25368() / 2 - 100, this.method_46427() + 5, -1);
            context.method_27534(((ChatRulesConfigListWidget)ChatRulesConfigListWidget.this).field_22740.field_1772, (class_2561)class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.ruleEnabled"), ChatRulesConfigListWidget.this.method_25368() / 2 - 10, this.method_46427() + 5, -1);
            context.method_27534(((ChatRulesConfigListWidget)ChatRulesConfigListWidget.this).field_22740.field_1772, (class_2561)class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.modify"), ChatRulesConfigListWidget.this.method_25368() / 2 + 77, this.method_46427() + 5, -1);
            context.method_25294(ChatRulesConfigListWidget.this.method_25342(), this.method_46427() + 15, ChatRulesConfigListWidget.this.method_31383(), this.method_46427() + 16, -6250336);
        }
    }

    private class ChatRuleEntry
    extends AbstractChatRuleEntry {
        private final int chatRuleIndex;
        private final ChatRule chatRule;
        private final List<? extends class_364> children;
        private final class_8667 layout;

        public void method_46421(int x) {
            super.method_46421(x);
            this.layout.method_46421(x + 125);
            this.layout.method_48222();
        }

        public void method_46419(int y) {
            super.method_46419(y);
            this.layout.method_46419(y);
            this.layout.method_48222();
        }

        public boolean method_25402(class_11909 click, boolean doubled) {
            super.method_25402(click, doubled);
            ChatRulesConfigListWidget.this.method_25313((class_350.class_351)this);
            return true;
        }

        private ChatRuleEntry(int chatRuleIndex) {
            this.chatRuleIndex = chatRuleIndex;
            this.chatRule = ChatRulesHandler.CHAT_RULE_LIST.getData().get(chatRuleIndex);
            this.layout = new class_8667(0, 0, class_8667.class_8668.field_45403);
            this.layout.method_52740().method_46473(10);
            this.layout.method_52740().method_46471(3);
            class_4185 enabledButton = (class_4185)this.layout.method_52736((class_8021)class_4185.method_46430((class_2561)this.enabledButtonText(), this::toggleEnabled).method_46437(50, 20).method_46431());
            class_4185 openConfigButton = (class_4185)this.layout.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.editRule"), a -> ChatRulesConfigListWidget.this.field_22740.method_1507((class_437)new ChatRuleConfigScreen(ChatRulesConfigListWidget.this.screen, chatRuleIndex))).method_46437(50, 20).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.editRule.@Tooltip"))).method_46431());
            class_4185 deleteButton = (class_4185)this.layout.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"selectServer.delete"), a -> ChatRulesConfigListWidget.this.field_22740.method_1507((class_437)new class_410(this::deleteEntry, (class_2561)class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.deleteQuestion"), (class_2561)class_2561.method_43469((String)"skyblocker.config.chat.chatRules.screen.deleteWarning", (Object[])new Object[]{this.chatRule.getName()}), (class_2561)class_2561.method_43471((String)"selectServer.deleteButton"), class_5244.field_24335))).method_46437(50, 20).method_46431());
            this.children = List.of(enabledButton, openConfigButton, deleteButton);
        }

        private class_2561 enabledButtonText() {
            if (this.chatRule.getEnabled()) {
                return class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.ruleScreen.true").method_54663(Color.GREEN.getRGB());
            }
            return class_2561.method_43471((String)"skyblocker.config.chat.chatRules.screen.ruleScreen.false").method_54663(Color.RED.getRGB());
        }

        private void toggleEnabled(class_4185 button) {
            ChatRulesConfigListWidget.this.hasChanged = true;
            this.chatRule.setEnabled(!this.chatRule.getEnabled());
            button.method_25355(this.enabledButtonText());
        }

        private void deleteEntry(boolean confirmedAction) {
            if (confirmedAction) {
                ChatRulesHandler.CHAT_RULE_LIST.getData().remove(this.chatRuleIndex);
                ChatRulesConfigListWidget.this.removeEntry(this);
            }
            ChatRulesConfigListWidget.this.field_22740.method_1507((class_437)ChatRulesConfigListWidget.this.screen);
            ChatRulesConfigListWidget.this.updateEntries();
        }

        public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
            this.layout.method_48206(child -> child.method_25394(context, mouseX, mouseY, deltaTicks));
            context.method_25300(((ChatRulesConfigListWidget)ChatRulesConfigListWidget.this).field_22740.field_1772, this.chatRule.getName(), this.method_46426() + 60, this.method_46427() + 8, -1);
        }

        @Override
        public boolean hasChanged() {
            return this.chatRule.getEnabled() != ChatRulesHandler.CHAT_RULE_LIST.getData().get(this.chatRuleIndex).getEnabled();
        }

        public List<? extends class_364> method_25396() {
            return this.children;
        }

        public List<? extends class_6379> method_37025() {
            return List.of();
        }
    }

    protected static abstract class AbstractChatRuleEntry
    extends class_4265.class_4266<AbstractChatRuleEntry> {
        protected AbstractChatRuleEntry() {
        }

        public boolean hasChanged() {
            return false;
        }
    }
}

