/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.chat;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.serialization.Codec;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.datafixer.ConfigDataFixer;
import de.hysky.skyblocker.skyblock.chat.ChatRule;
import de.hysky.skyblocker.skyblock.chat.ChatRulesConfigScreen;
import de.hysky.skyblocker.utils.CodecUtils;
import de.hysky.skyblocker.utils.Location;
import de.hysky.skyblocker.utils.TextTransformer;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.data.JsonData;
import de.hysky.skyblocker.utils.render.gui.BasicToast;
import de.hysky.skyblocker.utils.render.title.Title;
import de.hysky.skyblocker.utils.render.title.TitleContainer;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_368;
import net.minecraft.class_5250;
import org.jetbrains.annotations.VisibleForTesting;

public class ChatRulesHandler {
    private static final class_310 CLIENT = class_310.method_1551();
    private static final Path CHAT_RULE_FILE = SkyblockerMod.CONFIG_DIR.resolve("chat_rules.json");
    @VisibleForTesting
    static final Codec<List<ChatRule>> UNBOXING_CODEC = ConfigDataFixer.createDataFixingCodec(ConfigDataFixer.CHAT_RULES_TYPE, CodecUtils.mutableOptional(ChatRule.LIST_CODEC.fieldOf("rules"), ArrayList::new).codec());
    protected static final JsonData<List<ChatRule>> CHAT_RULE_LIST = new JsonData<List<ChatRule>>(CHAT_RULE_FILE, UNBOXING_CODEC, ChatRulesHandler.getDefaultChatRules());

    @Init
    public static void init() {
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> CHAT_RULE_LIST.init());
        ClientReceiveMessageEvents.ALLOW_GAME.register(ChatRulesHandler::checkMessage);
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, dedicated) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblocker").then(ClientCommandManager.literal((String)"chatRules").executes(Scheduler.queueOpenScreenCommand(() -> new ChatRulesConfigScreen(null))))));
    }

    @VisibleForTesting
    static List<ChatRule> getDefaultChatRules() {
        return new ArrayList<ChatRule>(List.of(new ChatRule("Clean Hub Chat", false, true, true, true, "(selling)|(buying)|(lowb)|(visit)|(/p)|(/ah)|(my ah)", EnumSet.of(Location.HUB), true, null, null, null, null, null), new ChatRule("Mining Ability Alert", false, true, false, true, "is now available!", EnumSet.of(Location.DWARVEN_MINES, Location.CRYSTAL_HOLLOWS), false, "&1Ability", null, new ChatRule.AnnouncementMessage("&1Ability", 3000L), null, class_3417.field_15224)));
    }

    private static boolean checkMessage(class_2561 message, boolean overlay) {
        if (overlay || !Utils.isOnSkyblock()) {
            return true;
        }
        List<ChatRule> rules = CHAT_RULE_LIST.getData();
        if (!CHAT_RULE_LIST.isLoaded() || rules.isEmpty()) {
            return true;
        }
        String plain = class_124.method_539((String)message.getString());
        for (ChatRule rule : rules) {
            boolean sendOriginal;
            ChatRule.Match match = rule.isMatch(plain);
            if (!match.matches()) continue;
            boolean bl = sendOriginal = !rule.getHideMessage();
            if (sendOriginal && rule.getChatMessage() != null) {
                sendOriginal = false;
                Utils.sendMessageToBypassEvents((class_2561)ChatRulesHandler.formatText(match.insertCaptureGroups(rule.getChatMessage())));
            }
            if (rule.getAnnouncementMessage() != null) {
                ChatRule.AnnouncementMessage announcementMessage = rule.getAnnouncementMessage();
                TitleContainer.addTitle(new Title(ChatRulesHandler.formatText(match.insertCaptureGroups(announcementMessage.message))), (int)(announcementMessage.displayDuration / 50L));
            }
            if (rule.getActionBarMessage() != null && ChatRulesHandler.CLIENT.field_1724 != null) {
                ChatRulesHandler.CLIENT.field_1724.method_7353((class_2561)ChatRulesHandler.formatText(match.insertCaptureGroups(rule.getActionBarMessage())), true);
            }
            if (rule.getToastMessage() != null) {
                ChatRule.ToastMessage toastMessage = rule.getToastMessage();
                CLIENT.method_1566().method_1999((class_368)new BasicToast((class_2561)ChatRulesHandler.formatText(match.insertCaptureGroups(toastMessage.message)), toastMessage.displayDuration, toastMessage.icon));
            }
            if (rule.getCustomSound() != null && ChatRulesHandler.CLIENT.field_1724 != null) {
                ChatRulesHandler.CLIENT.field_1724.method_5783(rule.getCustomSound(), 100.0f, 0.1f);
            }
            if (sendOriginal) continue;
            return false;
        }
        return true;
    }

    protected static class_5250 formatText(String codedString) {
        if (codedString.contains("\u00a7")) {
            return TextTransformer.fromLegacy(codedString, '\u00a7', false);
        }
        if (codedString.contains("&")) {
            return TextTransformer.fromLegacy(codedString, '&', false);
        }
        return class_2561.method_43470((String)codedString);
    }

    public static void saveChatRules() {
        if (CHAT_RULE_LIST.isLoaded()) {
            CHAT_RULE_LIST.save();
        }
    }
}

