/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.chat;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.scheduler.MessageScheduler;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenMouseEvents;
import net.minecraft.class_12225;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_408;
import net.minecraft.class_437;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfirmationPromptHelper {
    public static final Logger LOGGER = LoggerFactory.getLogger(ConfirmationPromptHelper.class);
    private static final List<String> CONFIRMATION_PHRASES = List.of("[Aye sure do!]", "[You guessed it!]", "[Sure thing, partner!]", "YES", "Yes");
    private static final List<String> CONFIRMATION_PHRASES_FORMATTING = List.of("\u00a7e \u279c \u00a7a[Aye sure do!]", "\u00a7e \u279c \u00a7a[You guessed it!]", "\u00a7e \u279c \u00a7a[Sure thing, partner!]", "\u00a7a\u00a7l[YES]", "\u00a7a[Yes]");
    private static String command;
    private static long commandFoundAt;

    @Init
    public static void init() {
        ClientReceiveMessageEvents.ALLOW_GAME.register(ConfirmationPromptHelper::onMessage);
        ScreenEvents.AFTER_INIT.register((_client, screen, _scaledWidth, _scaledHeight) -> {
            if (Utils.isOnSkyblock() && screen instanceof class_408 && SkyblockerConfigManager.get().chat.confirmationPromptHelper) {
                ScreenMouseEvents.beforeMouseClick((class_437)screen).register((_screen1, click) -> {
                    if (ConfirmationPromptHelper.hasCommand()) {
                        class_12225.class_12226 clickHandler;
                        class_2583 clickedStyle;
                        class_310 client = class_310.method_1551();
                        if (client.field_1755 instanceof class_408 && (clickedStyle = (clickHandler = new class_12225.class_12226(screen.method_64506(), (int)click.comp_4798(), (int)click.comp_4799()).method_76756(false)).method_75777()) != null && clickedStyle.method_10970() != null) {
                            return;
                        }
                        MessageScheduler.INSTANCE.sendMessageAfterCooldown(command, true);
                        command = null;
                        commandFoundAt = 0L;
                    }
                });
            }
        });
        ClientPlayConnectionEvents.JOIN.register((_handler, _sender, _client) -> {
            command = null;
            commandFoundAt = 0L;
        });
    }

    private static boolean hasCommand() {
        return command != null && commandFoundAt + 60000L > System.currentTimeMillis();
    }

    private static boolean containsConfirmationPhrase(class_2561 message) {
        String messageStr = message.getString();
        for (String phrase : CONFIRMATION_PHRASES) {
            if (!messageStr.contains(phrase)) continue;
            return true;
        }
        return false;
    }

    private static boolean onMessage(class_2561 message, boolean overlay) {
        Optional confirmationCommand;
        if (Utils.isOnSkyblock() && !overlay && SkyblockerConfigManager.get().chat.confirmationPromptHelper && ConfirmationPromptHelper.containsConfirmationPhrase(message) && (confirmationCommand = message.method_27658((style, asString) -> {
            String command;
            class_2558 event = style.method_10970();
            if (!CONFIRMATION_PHRASES_FORMATTING.contains(asString = asString.replaceAll("\\s+", " ").trim()) || !(event instanceof class_2558.class_10609)) return Optional.empty();
            class_2558.class_10609 $b$0 = (class_2558.class_10609)event;
            try {
                String patt1$temp;
                command = patt1$temp = $b$0.comp_3506();
                if (!command.startsWith("/chatprompt") && !command.startsWith("/selectnpcoption")) return Optional.empty();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            return Optional.of(command);
        }, class_2583.field_24360)).isPresent()) {
            command = (String)confirmationCommand.get();
            commandFoundAt = System.currentTimeMillis();
            class_310.method_1551().field_1724.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.chat.confirmationPromptNotification")), false);
        }
        return true;
    }
}

