/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.chat;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.skyblock.item.tooltip.ItemTooltip;
import de.hysky.skyblocker.skyblock.item.tooltip.adders.LineSmoothener;
import de.hysky.skyblocker.skyblock.item.tooltip.info.TooltipInfoType;
import de.hysky.skyblocker.utils.BazaarProduct;
import de.hysky.skyblocker.utils.NEURepoManager;
import de.hysky.skyblocker.utils.RegexUtils;
import io.github.moulberry.repo.data.NEUItem;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_7417;
import net.minecraft.class_8828;
import org.apache.commons.lang3.Strings;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SackMessagePrice {
    private static final Pattern ITEM_COUNT_PATTERN = Pattern.compile("([-+][\\d,]+)");
    private static final Logger LOGGER = LoggerFactory.getLogger(SackMessagePrice.class);

    @Init
    public static void init() {
        ClientReceiveMessageEvents.MODIFY_GAME.register(SackMessagePrice::onMessage);
    }

    private static class_2561 onMessage(class_2561 original, boolean overlay) {
        if (overlay) {
            return original;
        }
        String string = original.getString();
        if (!string.startsWith("[Sacks] ")) {
            return original;
        }
        class_5250 copy = SackMessagePrice.deepCopy(original);
        ObjectArrayList<List<class_2561>> listList = SackMessagePrice.getHoverEventSiblings((class_2561)copy);
        if (listList.isEmpty()) {
            return original;
        }
        for (List textList : listList) {
            Object2IntArrayMap<String> items = SackMessagePrice.parseItems(textList);
            if (items.isEmpty()) {
                LOGGER.warn("No items found in sack message: `{}`", (Object)original.getString());
                return original;
            }
            double npcPrice = 0.0;
            double bazaarBuyPrice = 0.0;
            double bazaarSellPrice = 0.0;
            for (Object2IntMap.Entry entry : items.object2IntEntrySet()) {
                Object2ObjectMap<String, BazaarProduct> bazaarData;
                String itemName = (String)entry.getKey();
                int count = entry.getIntValue();
                String neuId = SackMessagePrice.getNeuId(itemName);
                if (neuId == null) {
                    LOGGER.warn("Failed to find NEU ID for item: `{}`. This item will not be priced.", (Object)itemName);
                    continue;
                }
                Object2DoubleMap<String> npcData = TooltipInfoType.NPC.getData();
                if (npcData != null) {
                    npcPrice += npcData.getOrDefault((Object)neuId, 0.0) * (double)count;
                } else {
                    LOGGER.warn("No NPC data found for item: `{}`", (Object)neuId);
                }
                if ((bazaarData = TooltipInfoType.BAZAAR.getData()) == null) continue;
                BazaarProduct itemData = (BazaarProduct)bazaarData.get((Object)neuId);
                if (itemData != null) {
                    OptionalDouble sellPrice;
                    OptionalDouble buyPrice = itemData.buyPrice();
                    if (buyPrice.isPresent()) {
                        bazaarBuyPrice += buyPrice.getAsDouble() * (double)count;
                    }
                    if (!(sellPrice = itemData.sellPrice()).isPresent()) continue;
                    bazaarSellPrice += sellPrice.getAsDouble() * (double)count;
                    continue;
                }
                LOGGER.warn("No item data found for item `{}` in bazaar price data.", (Object)neuId);
            }
            textList.add(class_5244.field_33849);
            textList.add(LineSmoothener.createSmoothLine());
            textList.add(class_5244.field_33849);
            textList.add(class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"NPC Sell Price: ").method_27692(class_124.field_1054)).method_10852((class_2561)(npcPrice > 0.0 ? ItemTooltip.getCoinsMessage(npcPrice, 1) : class_2561.method_43470((String)"No data").method_27692(class_124.field_1061))));
            textList.add(class_5244.field_33849);
            textList.add(class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Bazaar Buy Price: ").method_27692(class_124.field_1065)).method_10852((class_2561)(bazaarBuyPrice > 0.0 ? ItemTooltip.getCoinsMessage(bazaarBuyPrice, 1) : class_2561.method_43470((String)"No data").method_27692(class_124.field_1061))));
            textList.add(class_5244.field_33849);
            textList.add(class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"Bazaar Sell Price: ").method_27692(class_124.field_1065)).method_10852((class_2561)(bazaarSellPrice > 0.0 ? ItemTooltip.getCoinsMessage(bazaarSellPrice, 1) : class_2561.method_43470((String)"No data").method_27692(class_124.field_1061))));
        }
        return copy;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static class_5250 deepCopy(class_2561 text) {
        Object class_106132;
        class_5250 copy = text.method_27662();
        class_2568 class_25682 = text.method_10866().method_10969();
        if (class_25682 instanceof class_2568.class_10613) {
            class_2561 showText;
            class_106132 = (class_2568.class_10613)class_25682;
            try {
                class_2561 class_25612;
                showText = class_25612 = class_106132.comp_3510();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            copy.method_10862(class_2583.field_24360.method_10949((class_2568)new class_2568.class_10613((class_2561)SackMessagePrice.deepCopy(showText))).method_27702(text.method_10866()));
        } else {
            copy.method_10862(text.method_10866());
        }
        class_106132 = text.method_10855().iterator();
        while (class_106132.hasNext()) {
            class_2561 sibling = (class_2561)class_106132.next();
            copy.method_10852((class_2561)SackMessagePrice.deepCopy(sibling));
        }
        return copy;
    }

    private static @Nullable String getNeuId(String itemName) {
        return NEURepoManager.getItemByName(itemName).stream().findFirst().map(NEUItem::getSkyblockItemId).orElseGet(() -> {
            LOGGER.warn("Failed to find the NEU item ID for item: {}", (Object)itemName);
            return null;
        });
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ObjectArrayList<List<class_2561>> getHoverEventSiblings(class_2561 text) {
        ObjectArrayList listList = new ObjectArrayList();
        Iterator iterator = text.method_10855().iterator();
        while (iterator.hasNext()) {
            String string;
            class_2561 sibling = (class_2561)iterator.next();
            class_2568 class_25682 = sibling.method_10866().method_10969();
            if (!(class_25682 instanceof class_2568.class_10613)) continue;
            class_2568.class_10613 class_106132 = (class_2568.class_10613)class_25682;
            try {
                // empty try
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            class_2561 class_25612 = class_106132.comp_3510();
            class_2561 hoverText = class_25612;
            class_25682 = hoverText.method_10851();
            if (!(class_25682 instanceof class_8828.class_2585)) continue;
            class_8828.class_2585 class_25852 = (class_8828.class_2585)class_25682;
            {
                String string2;
                string = string2 = class_25852.comp_737();
            }
            if (!Strings.CS.startsWithAny((CharSequence)string, new CharSequence[]{"Added items:", "Removed items:"})) continue;
            listList.add((Object)hoverText.method_10855());
        }
        return listList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Object2IntArrayMap<String> parseItems(List<class_2561> texts) {
        Object2IntArrayMap items = new Object2IntArrayMap();
        Integer lastCount = null;
        String lastItemName = null;
        Iterator<class_2561> iterator = texts.iterator();
        while (iterator.hasNext()) {
            String trimmed;
            block6: {
                class_2561 text = iterator.next();
                class_7417 class_74172 = text.method_10851();
                if (!(class_74172 instanceof class_8828.class_2585)) continue;
                class_8828.class_2585 class_25852 = (class_8828.class_2585)class_74172;
                try {
                    String string;
                    String content = string = class_25852.comp_737();
                    if (content.equals("\n\n")) {
                        return items;
                    }
                    if (content.isBlank()) continue;
                    trimmed = content.trim();
                    if (lastCount != null || lastItemName != null) break block6;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                Matcher matcher = ITEM_COUNT_PATTERN.matcher(trimmed);
                OptionalInt count = RegexUtils.findIntFromMatcher(matcher);
                if (count.isEmpty()) {
                    LOGGER.error("Failed to parse item count from text content: `{}`", (Object)trimmed);
                    return new Object2IntArrayMap();
                }
                lastCount = count.getAsInt();
                continue;
            }
            if (lastCount != null && lastItemName == null) {
                lastItemName = trimmed;
                continue;
            }
            if (lastCount == null || lastItemName == null) continue;
            items.put((Object)lastItemName, lastCount.intValue());
            lastCount = null;
            lastItemName = null;
        }
        return items;
    }
}

