/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.chocolatefactory;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.serialization.Codec;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.debug.Debug;
import de.hysky.skyblocker.events.SkyblockEvents;
import de.hysky.skyblocker.utils.ColorUtils;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.Location;
import de.hysky.skyblocker.utils.SkyblockTime;
import de.hysky.skyblocker.utils.command.argumenttypes.EggTypeArgumentType;
import de.hysky.skyblocker.utils.render.WorldRenderExtractionCallback;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveCollector;
import de.hysky.skyblocker.utils.scheduler.MessageScheduler;
import de.hysky.skyblocker.utils.waypoint.Waypoint;
import de.hysky.skyblocker.utils.ws.Service;
import de.hysky.skyblocker.utils.ws.WsMessageHandler;
import de.hysky.skyblocker.utils.ws.WsStateManager;
import de.hysky.skyblocker.utils.ws.message.EggWaypointMessage;
import it.unimi.dsi.fastutil.objects.ObjectImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_310;
import net.minecraft.class_3542;
import net.minecraft.class_5250;
import org.apache.commons.text.WordUtils;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EggFinder {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Skyblocker Egg Finder");
    private static final Pattern EGG_FOUND_PATTERN = Pattern.compile("^(?:HOPPITY'S HUNT You found a Chocolate|You have already collected this Chocolate) (Breakfast|Lunch|Dinner|Brunch|D\u00e9jeuner|Supper) Egg");
    private static final Set<Location> LOCATIONS = Set.of(Location.BACKWATER_BAYOU, Location.CRIMSON_ISLE, Location.CRYSTAL_HOLLOWS, Location.DEEP_CAVERNS, Location.DUNGEON_HUB, Location.DWARVEN_MINES, Location.GALATEA, Location.GOLD_MINE, Location.HUB, Location.THE_END, Location.THE_FARMING_ISLAND, Location.THE_PARK, Location.SPIDERS_DEN);
    private static boolean isSpring = SkyblockTime.skyblockSeason.get() == SkyblockTime.Season.SPRING;

    @Init
    public static void init() {
        ClientPlayConnectionEvents.JOIN.register((ignored, ignored2, ignored3) -> EggFinder.clearEggs());
        SkyblockEvents.LOCATION_CHANGE.register(EggFinder::handleLocationChange);
        ClientReceiveMessageEvents.ALLOW_GAME.register(EggFinder::onChatMessage);
        WorldRenderExtractionCallback.EVENT.register(EggFinder::extractRendering);
        SkyblockTime.HOUR_CHANGE.register(hour -> {
            if (!isSpring) {
                return;
            }
            int dayNumber = SkyblockTime.skyblockMonth.get().ordinal() * 31 + SkyblockTime.skyblockDay.get();
            boolean isOdd = dayNumber % 2 == 1;
            for (EggType type : EggType.entries) {
                if (hour != type.resetHour || isOdd != type.oddDay) continue;
                type.collected = false;
                type.prevEgg = type.egg;
                type.egg = null;
            }
        });
        SkyblockTime.SEASON_CHANGE.register(season -> {
            boolean bl = isSpring = season == SkyblockTime.Season.SPRING;
            if (!isSpring) {
                EggFinder.clearEggs();
            }
        });
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblocker").then(ClientCommandManager.literal((String)"eggFinder").then(ClientCommandManager.literal((String)"shareLocation").then(ClientCommandManager.argument((String)"eggType", (ArgumentType)EggTypeArgumentType.eggType()).executes(context -> {
                EggType eggType = (EggType)((Object)((Object)((Object)context.getArgument("eggType", EggType.class))));
                if (eggType == null || eggType.egg == null) {
                    ((FabricClientCommandSource)context.getSource()).sendError((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43471((String)"skyblocker.helpers.hoppitysHunt.unableToShareEgg").method_27694(style -> style.method_10977(class_124.field_1061))));
                    return 1;
                }
                MessageScheduler.INSTANCE.sendMessageAfterCooldown("[Skyblocker] Chocolate %s Egg found at %s".formatted(eggType.name, eggType.egg.pos.method_23854()), false);
                return 1;
            })))));
            if (!Debug.debugEnabled()) {
                return;
            }
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblocker").then(ClientCommandManager.literal((String)"eggFinder").then(ClientCommandManager.literal((String)"resetFoundStatus").executes(context -> {
                for (EggType type : EggType.entries) {
                    type.collected = false;
                    if (type.egg == null) continue;
                    type.egg.setMissing();
                }
                return 1;
            }))));
            dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblocker").then(ClientCommandManager.literal((String)"eggFinder").then(ClientCommandManager.literal((String)"clearWaypoints").executes(context -> {
                EggFinder.clearEggs();
                return 1;
            }))));
        });
    }

    public static void onWebsocketMessage(EggWaypointMessage message) {
        EggType eggType = message.eggType();
        eggType.egg = new Egg(message.coordinates(), eggType);
        eggType.onEggReceived();
    }

    private static void clearEggs() {
        for (EggType type : EggType.entries) {
            type.egg = null;
            type.prevEgg = null;
        }
    }

    private static void handleLocationChange(Location location) {
        EggFinder.clearEggs();
        if (!(isSpring && LOCATIONS.contains((Object)location) && SkyblockerConfigManager.get().helpers.chocolateFactory.enableEggFinder)) {
            return;
        }
        WsStateManager.subscribeIsland(Service.EGG_WAYPOINTS, Optional.empty());
    }

    public static boolean checkIfEgg(class_1531 armorStand, EggType eggType) {
        if (armorStand.method_16914() || !armorStand.method_5767() || armorStand.method_61489()) {
            return false;
        }
        return EggFinder.handleArmorStand(armorStand, eggType);
    }

    private static boolean handleArmorStand(class_1531 armorStand, EggType eggType) {
        for (class_1799 itemStack : ItemUtils.getArmor((class_1309)armorStand)) {
            Optional<String> texture = ItemUtils.getHeadTextureOptional(itemStack);
            if (texture.isEmpty() || !texture.get().equals(eggType.texture)) continue;
            return true;
        }
        return false;
    }

    private static void extractRendering(PrimitiveCollector collector) {
        if (!isSpring || !SkyblockerConfigManager.get().helpers.chocolateFactory.enableEggFinder) {
            return;
        }
        for (EggType type : EggType.entries) {
            Egg egg = type.egg;
            if (egg == null) continue;
            egg.extractRendering(collector);
        }
    }

    private static boolean onChatMessage(class_2561 text, boolean overlay) {
        if (overlay || !isSpring || !SkyblockerConfigManager.get().helpers.chocolateFactory.enableEggFinder) {
            return true;
        }
        Matcher matcher = EGG_FOUND_PATTERN.matcher(text.getString());
        if (!matcher.find()) {
            return true;
        }
        try {
            EggType eggType = EggType.getTypeByName(matcher.group(1));
            if (eggType == null) {
                return true;
            }
            eggType.collected = true;
            if (eggType.egg != null) {
                eggType.egg.setFound();
                return true;
            }
            LOGGER.info("[Skyblocker Egg Finder] Discovered a new egg!");
            class_310 client = class_310.method_1551();
            if (client.field_1724 == null || client.field_1687 == null) {
                return true;
            }
            List entities = client.field_1687.method_8390(class_1531.class, class_238.method_30048((class_243)client.field_1724.method_73189(), (double)4.0, (double)4.0, (double)4.0), entity -> EggFinder.checkIfEgg(entity, eggType));
            if (entities.size() != 1) {
                return true;
            }
            eggType.egg = new Egg(((class_1531)entities.getFirst()).method_24515().method_10086(2), eggType);
            eggType.egg.setFound();
            eggType.sendEggMessage();
            if (eggType.egg.equals(eggType.prevEgg)) {
                LOGGER.info("[Skyblocker Egg Finder] Not sharing this egg to the WebSocket - matches previous location");
                return true;
            }
            WsMessageHandler.sendLocationMessage(Service.EGG_WAYPOINTS, new EggWaypointMessage(eggType, eggType.egg.pos));
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("[Skyblocker Egg Finder] Failed to process an egg!", (Throwable)e);
        }
        return true;
    }

    public static enum EggType implements class_3542
    {
        BREAKFAST("Breakfast", class_124.field_1065.method_532(), 7, "ewogICJ0aW1lc3RhbXAiIDogMTcxMTQ2MjY3MzE0OSwKICAicHJvZmlsZUlkIiA6ICJiN2I4ZTlhZjEwZGE0NjFmOTY2YTQxM2RmOWJiM2U4OCIsCiAgInByb2ZpbGVOYW1lIiA6ICJBbmFiYW5hbmFZZzciLAogICJzaWduYXR1cmVSZXF1aXJlZCIgOiB0cnVlLAogICJ0ZXh0dXJlcyIgOiB7CiAgICAiU0tJTiIgOiB7CiAgICAgICJ1cmwiIDogImh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYTQ5MzMzZDg1YjhhMzE1ZDAzMzZlYjJkZjM3ZDhhNzE0Y2EyNGM1MWI4YzYwNzRmMWI1YjkyN2RlYjUxNmMyNCIKICAgIH0KICB9Cn0", true),
        LUNCH("Lunch", class_124.field_1078.method_532(), 14, "ewogICJ0aW1lc3RhbXAiIDogMTcxMTQ2MjU2ODExMiwKICAicHJvZmlsZUlkIiA6ICI3NzUwYzFhNTM5M2Q0ZWQ0Yjc2NmQ4ZGUwOWY4MjU0NiIsCiAgInByb2ZpbGVOYW1lIiA6ICJSZWVkcmVsIiwKICAic2lnbmF0dXJlUmVxdWlyZWQiIDogdHJ1ZSwKICAidGV4dHVyZXMiIDogewogICAgIlNLSU4iIDogewogICAgICAidXJsIiA6ICJodHRwOi8vdGV4dHVyZXMubWluZWNyYWZ0Lm5ldC90ZXh0dXJlLzdhZTZkMmQzMWQ4MTY3YmNhZjk1MjkzYjY4YTRhY2Q4NzJkNjZlNzUxZGI1YTM0ZjJjYmM2NzY2YTAzNTZkMGEiCiAgICB9CiAgfQp9", true),
        DINNER("Dinner", class_124.field_1060.method_532(), 21, "ewogICJ0aW1lc3RhbXAiIDogMTcxMTQ2MjY0OTcwMSwKICAicHJvZmlsZUlkIiA6ICI3NGEwMzQxNWY1OTI0ZTA4YjMyMGM2MmU1NGE3ZjJhYiIsCiAgInByb2ZpbGVOYW1lIiA6ICJNZXp6aXIiLAogICJzaWduYXR1cmVSZXF1aXJlZCIgOiB0cnVlLAogICJ0ZXh0dXJlcyIgOiB7CiAgICAiU0tJTiIgOiB7CiAgICAgICJ1cmwiIDogImh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZTVlMzYxNjU4MTlmZDI4NTBmOTg1NTJlZGNkNzYzZmY5ODYzMTMxMTkyODNjMTI2YWNlMGM0Y2M0OTVlNzZhOCIKICAgIH0KICB9Cn0", true),
        BRUNCH("Brunch", EggType.BREAKFAST.color, EggType.BREAKFAST.resetHour, EggType.BREAKFAST.texture, false),
        DEJEUNER("D\u00e9jeuner", EggType.LUNCH.color, EggType.LUNCH.resetHour, EggType.LUNCH.texture, false),
        SUPPER("Supper", EggType.DINNER.color, EggType.DINNER.resetHour, EggType.DINNER.texture, false);

        public static final Codec<EggType> CODEC;
        public static final ObjectImmutableList<EggType> entries;
        public final String name;
        public final int color;
        public final int resetHour;
        public final String texture;
        public final boolean oddDay;
        boolean collected = false;
        private @Nullable Egg egg = null;
        private @Nullable Egg prevEgg = null;

        private EggType(String name, int color, int resetHour, String texture, Boolean oddDay) {
            this.name = name;
            this.color = color;
            this.resetHour = resetHour;
            this.texture = texture;
            this.oddDay = oddDay;
        }

        public void onEggReceived() {
            if (!SkyblockerConfigManager.get().helpers.chocolateFactory.sendEggFoundMessages) {
                return;
            }
            if (this.collected) {
                this.egg.setFound();
                return;
            }
            this.sendEggMessage();
        }

        public void sendEggMessage() {
            class_5250 eggName = class_2561.method_43469((String)"skyblocker.helpers.hoppitysHunt.chocolateEgg", (Object[])new Object[]{this.name}).method_54663(this.color);
            class_310.method_1551().field_1724.method_7353((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43469((String)"skyblocker.helpers.hoppitysHunt.newEggDiscovered", (Object[])new Object[]{eggName, this.egg.pos.method_23854()})).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609("/skyblocker eggFinder shareLocation " + String.valueOf((Object)this))).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43471((String)"skyblocker.helpers.hoppitysHunt.shareEggPrompt").method_27692(class_124.field_1060)))), false);
        }

        public String toString() {
            return WordUtils.capitalizeFully((String)this.name());
        }

        public String method_15434() {
            return this.name;
        }

        public static @Nullable EggType getTypeByName(String eggType) {
            for (EggType type : entries) {
                if (!type.name.equals(eggType)) continue;
                return type;
            }
            LOGGER.info("[Skyblocker Egg Finder] Failed to get egg type for egg '{}'", (Object)eggType);
            return null;
        }

        static {
            CODEC = class_3542.method_53955(EggType::values);
            entries = ObjectImmutableList.of((Object[])EggType.values());
        }
    }

    static class Egg
    extends Waypoint {
        Egg(class_2338 pos, EggType eggType) {
            super(pos, SkyblockerConfigManager.get().helpers.chocolateFactory.waypointType, ColorUtils.getFloatComponents(eggType.color), SkyblockerConfigManager.get().helpers.chocolateFactory.showThroughWalls);
        }
    }
}

