/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.crimson.dojo;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.events.ParticleEvents;
import de.hysky.skyblocker.events.WorldEvents;
import de.hysky.skyblocker.skyblock.crimson.dojo.ControlTestHelper;
import de.hysky.skyblocker.skyblock.crimson.dojo.DisciplineTestHelper;
import de.hysky.skyblocker.skyblock.crimson.dojo.ForceTestHelper;
import de.hysky.skyblocker.skyblock.crimson.dojo.MasteryTestHelper;
import de.hysky.skyblocker.skyblock.crimson.dojo.StaminaTestHelper;
import de.hysky.skyblocker.skyblock.crimson.dojo.SwiftnessTestHelper;
import de.hysky.skyblocker.skyblock.crimson.dojo.TenacityTestHelper;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.render.WorldRenderExtractionCallback;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveCollector;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import it.unimi.dsi.fastutil.booleans.BooleanPredicate;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientEntityEvents;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2675;
import net.minecraft.class_2680;
import net.minecraft.class_2935;
import net.minecraft.class_310;
import net.minecraft.class_3966;
import net.minecraft.class_634;
import net.minecraft.class_638;

public class DojoManager {
    private static final class_310 CLIENT = class_310.method_1551();
    private static final String START_MESSAGE = "[NPC] Master Tao: Ahhh, here we go! Let's get you into the Arena.";
    private static final Pattern TEST_OF_PATTERN = Pattern.compile("\\s+Test of (\\w+) OBJECTIVES");
    private static final String CHALLENGE_FINISHED_REGEX = "\\s+CHALLENGE ((COMPLETED)|(FAILED))";
    protected static DojoChallenges currentChallenge = DojoChallenges.NONE;
    public static boolean inArena = false;
    protected static long ping = -1L;

    @Init
    public static void init() {
        ClientReceiveMessageEvents.ALLOW_GAME.register(DojoManager::onMessage);
        WorldRenderExtractionCallback.EVENT.register(DojoManager::extractRendering);
        ClientPlayConnectionEvents.JOIN.register((_handler, _sender, _client) -> DojoManager.reset());
        ClientEntityEvents.ENTITY_LOAD.register(DojoManager::onEntitySpawn);
        ClientEntityEvents.ENTITY_UNLOAD.register(DojoManager::onEntityDespawn);
        AttackEntityCallback.EVENT.register(DojoManager::onEntityAttacked);
        Scheduler.INSTANCE.scheduleCyclic(DojoManager::update, 3);
        WorldEvents.BLOCK_STATE_UPDATE.register(DojoManager::onBlockUpdate);
        ParticleEvents.FROM_SERVER.register(DojoManager::onParticle);
    }

    private static void reset() {
        inArena = false;
        currentChallenge = DojoChallenges.NONE;
        ForceTestHelper.reset();
        StaminaTestHelper.reset();
        MasteryTestHelper.reset();
        SwiftnessTestHelper.reset();
        ControlTestHelper.reset();
        TenacityTestHelper.reset();
    }

    private static boolean onMessage(class_2561 text, Boolean overlay) {
        if (!Utils.isInCrimson() || overlay.booleanValue()) {
            return true;
        }
        if (Objects.equals(class_124.method_539((String)text.getString()), START_MESSAGE)) {
            inArena = true;
            DojoManager.getPing();
            return true;
        }
        if (!inArena) {
            return true;
        }
        if (text.getString().matches(CHALLENGE_FINISHED_REGEX)) {
            DojoManager.reset();
            return true;
        }
        if (currentChallenge != DojoChallenges.NONE) {
            return true;
        }
        Matcher nextChallenge = TEST_OF_PATTERN.matcher(text.getString());
        if (nextChallenge.matches()) {
            currentChallenge = DojoChallenges.from(nextChallenge.group(1));
            if (!DojoManager.currentChallenge.enabled.test(true)) {
                currentChallenge = DojoChallenges.NONE;
            }
        }
        return true;
    }

    private static void getPing() {
        class_634 networkHandler = CLIENT.method_1562();
        if (networkHandler != null) {
            networkHandler.method_52787((class_2596)new class_2935(class_156.method_658()));
        }
    }

    public static void onPingResult(long ping) {
        DojoManager.ping = ping;
    }

    private static void update() {
        if (!Utils.isInCrimson() || !inArena) {
            return;
        }
        switch (currentChallenge.ordinal()) {
            case 2: {
                StaminaTestHelper.update();
                break;
            }
            case 6: {
                ControlTestHelper.update();
            }
        }
    }

    public static boolean shouldGlow(String name) {
        if (!Utils.isInCrimson() || !inArena) {
            return false;
        }
        return switch (currentChallenge.ordinal()) {
            case 1 -> ForceTestHelper.shouldGlow(name);
            case 4 -> DisciplineTestHelper.shouldGlow(name);
            default -> false;
        };
    }

    public static int getColor() {
        if (!Utils.isInCrimson() || !inArena) {
            return 16086840;
        }
        return switch (currentChallenge.ordinal()) {
            case 1 -> ForceTestHelper.getColor();
            case 4 -> DisciplineTestHelper.getColor();
            default -> 16086840;
        };
    }

    private static void onBlockUpdate(class_2338 pos, class_2680 oldStatem, class_2680 newState) {
        if (!Utils.isInCrimson() || !inArena) {
            return;
        }
        switch (currentChallenge.ordinal()) {
            case 3: {
                MasteryTestHelper.onBlockUpdate(pos.method_10062(), newState);
                break;
            }
            case 5: {
                SwiftnessTestHelper.onBlockUpdate(pos.method_10062(), newState);
            }
        }
    }

    private static void onEntitySpawn(class_1297 entity, class_638 clientWorld) {
        if (!Utils.isInCrimson() || !inArena || CLIENT == null || DojoManager.CLIENT.field_1724 == null) {
            return;
        }
        if (!entity.method_43259((class_1297)DojoManager.CLIENT.field_1724, 50.0, 5.0)) {
            return;
        }
        switch (currentChallenge.ordinal()) {
            case 1: {
                ForceTestHelper.onEntitySpawn(entity);
                break;
            }
            case 6: {
                ControlTestHelper.onEntitySpawn(entity);
                break;
            }
            case 7: {
                TenacityTestHelper.onEntitySpawn(entity);
            }
        }
    }

    private static void onEntityDespawn(class_1297 entity, class_638 clientWorld) {
        if (!Utils.isInCrimson() || !inArena) {
            return;
        }
        switch (currentChallenge.ordinal()) {
            case 1: {
                ForceTestHelper.onEntityDespawn(entity);
                break;
            }
            case 7: {
                TenacityTestHelper.onEntityDespawn(entity);
            }
        }
    }

    private static class_1269 onEntityAttacked(class_1657 playerEntity, class_1937 world, class_1268 hand, class_1297 entity, class_3966 entityHitResult) {
        if (!Utils.isInCrimson() || !inArena) {
            return class_1269.field_5811;
        }
        if (currentChallenge == DojoChallenges.FORCE) {
            ForceTestHelper.onEntityAttacked(entity);
        }
        return class_1269.field_5811;
    }

    private static void onParticle(class_2675 packet) {
        if (!Utils.isInCrimson() || !inArena) {
            return;
        }
        if (currentChallenge == DojoChallenges.TENACITY) {
            TenacityTestHelper.onParticle(packet);
        }
    }

    private static void extractRendering(PrimitiveCollector collector) {
        if (!Utils.isInCrimson() || !inArena) {
            return;
        }
        switch (currentChallenge.ordinal()) {
            case 1: {
                ForceTestHelper.extractRendering(collector);
                break;
            }
            case 2: {
                StaminaTestHelper.extractRendering(collector);
                break;
            }
            case 3: {
                MasteryTestHelper.extractRendering(collector);
                break;
            }
            case 5: {
                SwiftnessTestHelper.extractRendering(collector);
                break;
            }
            case 6: {
                ControlTestHelper.extractRendering(collector);
                break;
            }
            case 7: {
                TenacityTestHelper.extractRendering(collector);
            }
        }
    }

    protected static enum DojoChallenges {
        NONE("none", enabled -> false),
        FORCE("Force", enabled -> SkyblockerConfigManager.get().crimsonIsle.dojo.enableForceHelper),
        STAMINA("Stamina", enabled -> SkyblockerConfigManager.get().crimsonIsle.dojo.enableStaminaHelper),
        MASTERY("Mastery", enabled -> SkyblockerConfigManager.get().crimsonIsle.dojo.enableMasteryHelper),
        DISCIPLINE("Discipline", enabled -> SkyblockerConfigManager.get().crimsonIsle.dojo.enableDisciplineHelper),
        SWIFTNESS("Swiftness", enabled -> SkyblockerConfigManager.get().crimsonIsle.dojo.enableSwiftnessHelper),
        CONTROL("Control", enabled -> SkyblockerConfigManager.get().crimsonIsle.dojo.enableControlHelper),
        TENACITY("Tenacity", enabled -> SkyblockerConfigManager.get().crimsonIsle.dojo.enableTenacityHelper);

        private final String name;
        private final BooleanPredicate enabled;

        private DojoChallenges(String name, BooleanPredicate enabled) {
            this.name = name;
            this.enabled = enabled;
        }

        public static DojoChallenges from(String name) {
            return Arrays.stream(DojoChallenges.values()).filter(n -> name.equals(n.name)).findFirst().orElse(NONE);
        }
    }
}

