/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.crimson.kuudra;

import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.skyblock.ChestValue;
import de.hysky.skyblocker.skyblock.crimson.CrimsonFaction;
import de.hysky.skyblocker.skyblock.crimson.kuudra.KuudraPhase;
import de.hysky.skyblocker.skyblock.crimson.kuudra.KuudraProfileData;
import de.hysky.skyblocker.skyblock.item.PetInfo;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.data.ProfiledData;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.minecraft.class_124;
import net.minecraft.class_1707;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_476;
import org.apache.commons.lang3.math.NumberUtils;

public class Kuudra {
    public static final int KUUDRA_MAGMA_CUBE_SIZE = 30;
    private static final Path FILE = SkyblockerMod.CONFIG_DIR.resolve("kuudra.json");
    private static final ProfiledData<KuudraProfileData> DATA = new ProfiledData<KuudraProfileData>(FILE, KuudraProfileData.CODEC);
    private static final Pattern FACTION_SHOP_PATTERN = Pattern.compile("^(?<faction>Mage|Barbarian) Shop$");
    protected static KuudraPhase phase = KuudraPhase.OTHER;

    @Init
    public static void init() {
        DATA.load();
        ScreenEvents.AFTER_INIT.register((_client, screen, _scaledWidth, _scaledHeight) -> {
            if (Utils.isOnSkyblock() && screen instanceof class_476) {
                class_476 genericContainerScreen = (class_476)screen;
                String title = screen.method_25440().getString();
                Matcher factionShopMatcher = FACTION_SHOP_PATTERN.matcher(title);
                String string = title;
                Objects.requireNonNull(string);
                String selector0$temp = string;
                int index$1 = 0;
                block4: while (true) {
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, String.class}, (Object)selector0$temp, index$1)) {
                        case 0: {
                            String s = selector0$temp;
                            if (!factionShopMatcher.matches()) {
                                index$1 = 1;
                                continue block4;
                            }
                            ScreenEvents.afterTick((class_437)screen).register(_screen -> Kuudra.checkKuudraKeyShop(genericContainerScreen, factionShopMatcher));
                            break block4;
                        }
                        case 1: {
                            String s = selector0$temp;
                            if (!s.startsWith("Pets")) {
                                index$1 = 2;
                                continue block4;
                            }
                            ScreenEvents.afterTick((class_437)screen).register(_screen -> Kuudra.checkForKuudraPet(genericContainerScreen));
                            break block4;
                        }
                    }
                    break;
                }
            }
        });
        ClientPlayConnectionEvents.JOIN.register((_handler, _sender, _client) -> Kuudra.reset());
        ClientReceiveMessageEvents.ALLOW_GAME.register(Kuudra::onMessage);
    }

    public static KuudraProfileData getKuudraProfileData() {
        return DATA.containsKey() ? DATA.get() : KuudraProfileData.EMPTY;
    }

    private static void checkKuudraKeyShop(class_476 screen, Matcher factionShopMatcher) {
        CrimsonFaction faction = CrimsonFaction.valueOf(factionShopMatcher.group("faction").toUpperCase(Locale.ENGLISH));
        List<class_1799> kuudraKeyItems = ((class_1707)screen.method_17577()).field_7761.stream().filter(class_1735::method_7681).map(class_1735::method_7677).filter(stack -> KuudraProfileData.EMPTY.kuudraKeyPrices().containsKey(stack.getSkyblockId())).toList();
        Object2IntOpenHashMap kuudraKeyPrices = new Object2IntOpenHashMap();
        kuudraKeyPrices.putAll(KuudraProfileData.EMPTY.kuudraKeyPrices());
        for (class_1799 kuudraKey : kuudraKeyItems) {
            String foundString;
            Matcher matcher = ItemUtils.getLoreLineIfMatch(kuudraKey, ChestValue.DUNGEON_CHEST_COIN_COST_PATTERN);
            if (matcher == null || !NumberUtils.isCreatable((String)(foundString = matcher.group(1).replaceAll("\\D", "")))) continue;
            int amount = Integer.parseInt(foundString);
            kuudraKeyPrices.put((Object)kuudraKey.getSkyblockId(), amount);
        }
        KuudraProfileData storedData = Kuudra.getKuudraProfileData();
        if (faction != storedData.faction() || !kuudraKeyPrices.equals(storedData.kuudraKeyPrices())) {
            KuudraProfileData newData = new KuudraProfileData(faction, storedData.kuudraPet(), (Map<String, Integer>)kuudraKeyPrices);
            DATA.put(newData);
            DATA.save();
        }
    }

    private static void checkForKuudraPet(class_476 screen) {
        for (class_1735 slot : ((class_1707)screen.method_17577()).field_7761) {
            if (!slot.method_7681()) continue;
            PetInfo currentPet = slot.method_7677().getPetInfo();
            KuudraProfileData storedData = Kuudra.getKuudraProfileData();
            if (currentPet.isEmpty() || !currentPet.type().equals("KUUDRA") || !(currentPet.tierIndex() >= storedData.kuudraPet().tierIndex() && currentPet.exp() >= storedData.kuudraPet().exp()) && !storedData.kuudraPet().isEmpty()) continue;
            KuudraProfileData newData = new KuudraProfileData(storedData.faction(), currentPet, storedData.kuudraKeyPrices());
            DATA.put(newData);
            DATA.save();
            return;
        }
    }

    private static boolean onMessage(class_2561 text, boolean overlay) {
        if (Utils.isInKuudra() && !overlay) {
            String message = class_124.method_539((String)text.getString());
            if (message.equals("[NPC] Elle: ARGH! All of the supplies fell into the lava! You need to retrieve them quickly!")) {
                phase = KuudraPhase.RETRIEVE_SUPPLIES;
            }
            if (message.equals("[NPC] Elle: Phew! The Ballista is finally ready! It should be strong enough to tank Kuudra's blows now!")) {
                phase = KuudraPhase.DPS;
            }
            if (message.equals("[NPC] Elle: POW! SURELY THAT'S IT! I don't think he has any more in him!")) {
                phase = KuudraPhase.OTHER;
            }
            if (message.equals("[NPC] Elle: What just happened!? Is this Kuudra's real lair?")) {
                phase = KuudraPhase.KUUDRA_LAIR;
            }
        }
        return true;
    }

    private static void reset() {
        phase = KuudraPhase.OTHER;
    }
}

