/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon;

import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.ChestValue;
import de.hysky.skyblocker.skyblock.hunting.Attribute;
import de.hysky.skyblocker.skyblock.hunting.Attributes;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.Formatters;
import de.hysky.skyblocker.utils.ItemUtils;
import de.hysky.skyblocker.utils.RegexUtils;
import de.hysky.skyblocker.utils.container.SimpleContainerSolver;
import de.hysky.skyblocker.utils.container.TooltipAdder;
import de.hysky.skyblocker.utils.render.gui.ColorHighlight;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_124;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_5251;
import org.apache.commons.lang3.math.NumberUtils;
import org.jspecify.annotations.Nullable;

public class CroesusProfit
extends SimpleContainerSolver
implements TooltipAdder {
    public static final CroesusProfit INSTANCE = new CroesusProfit();
    private static final Pattern DUNGEON_CHEST_PATTERN = Pattern.compile("^(?:Wood|Gold|Diamond|Emerald|Obsidian|Bedrock)$");
    private static final Pattern KUUDRA_CHEST_PATTERN = Pattern.compile("^(?:Free|Paid) Chest$");
    private static final Map<String, String> DUNGEON_DROPS_NAME_TO_API_ID = Map.ofEntries(Map.entry("Enchanted Book (Ultimate Jerry I)", "ENCHANTMENT_ULTIMATE_JERRY_1"), Map.entry("Enchanted Book (Ultimate Jerry II)", "ENCHANTMENT_ULTIMATE_JERRY_2"), Map.entry("Enchanted Book (Ultimate Jerry III)", "ENCHANTMENT_ULTIMATE_JERRY_3"), Map.entry("Enchanted Book (Bank I)", "ENCHANTMENT_ULTIMATE_BANK_1"), Map.entry("Enchanted Book (Bank II)", "ENCHANTMENT_ULTIMATE_BANK_2"), Map.entry("Enchanted Book (Bank III)", "ENCHANTMENT_ULTIMATE_BANK_3"), Map.entry("Enchanted Book (Combo I)", "ENCHANTMENT_ULTIMATE_COMBO_1"), Map.entry("Enchanted Book (Combo II)", "ENCHANTMENT_ULTIMATE_COMBO_2"), Map.entry("Enchanted Book (No Pain No Gain I)", "ENCHANTMENT_ULTIMATE_NO_PAIN_NO_GAIN_1"), Map.entry("Enchanted Book (No Pain No Gain II)", "ENCHANTMENT_ULTIMATE_NO_PAIN_NO_GAIN_2"), Map.entry("Enchanted Book (Ultimate Wise I)", "ENCHANTMENT_ULTIMATE_WISE_1"), Map.entry("Enchanted Book (Ultimate Wise II)", "ENCHANTMENT_ULTIMATE_WISE_2"), Map.entry("Enchanted Book (Wisdom I)", "ENCHANTMENT_ULTIMATE_WISDOM_1"), Map.entry("Enchanted Book (Wisdom II)", "ENCHANTMENT_ULTIMATE_WISDOM_2"), Map.entry("Enchanted Book (Last Stand I)", "ENCHANTMENT_ULTIMATE_LAST_STAND_1"), Map.entry("Enchanted Book (Last Stand II)", "ENCHANTMENT_ULTIMATE_LAST_STAND_2"), Map.entry("Enchanted Book (Rend I)", "ENCHANTMENT_ULTIMATE_REND_1"), Map.entry("Enchanted Book (Rend II)", "ENCHANTMENT_ULTIMATE_REND_2"), Map.entry("Enchanted Book (Legion I)", "ENCHANTMENT_ULTIMATE_LEGION_1"), Map.entry("Enchanted Book (Swarm I)", "ENCHANTMENT_ULTIMATE_SWARM_1"), Map.entry("Enchanted Book (One For All I)", "ENCHANTMENT_ULTIMATE_ONE_FOR_ALL_1"), Map.entry("Enchanted Book (Soul Eater I)", "ENCHANTMENT_ULTIMATE_SOUL_EATER_1"), Map.entry("Enchanted Book (Infinite Quiver VI)", "ENCHANTMENT_INFINITE_QUIVER_6"), Map.entry("Enchanted Book (Infinite Quiver VII)", "ENCHANTMENT_INFINITE_QUIVER_7"), Map.entry("Enchanted Book (Feather Falling VI)", "ENCHANTMENT_FEATHER_FALLING_6"), Map.entry("Enchanted Book (Feather Falling VII)", "ENCHANTMENT_FEATHER_FALLING_7"), Map.entry("Enchanted Book (Rejuvenate I)", "ENCHANTMENT_REJUVENATE_1"), Map.entry("Enchanted Book (Rejuvenate II)", "ENCHANTMENT_REJUVENATE_2"), Map.entry("Enchanted Book (Rejuvenate III)", "ENCHANTMENT_REJUVENATE_3"), Map.entry("Enchanted Book (Overload I)", "ENCHANTMENT_OVERLOAD_1"), Map.entry("Enchanted Book (Lethality VI)", "ENCHANTMENT_LETHALITY_6"), Map.entry("Enchanted Book (Thunderlord VII)", "ENCHANTMENT_THUNDERLORD_7"), Map.entry("Hot Potato Book", "HOT_POTATO_BOOK"), Map.entry("Fuming Potato Book", "FUMING_POTATO_BOOK"), Map.entry("Recombobulator 3000", "RECOMBOBULATOR_3000"), Map.entry("Necromancer's Brooch", "NECROMANCER_BROOCH"), Map.entry("Bonzo's Staff", "BONZO_STAFF"), Map.entry("Master Skull - Tier 1", "MASTER_SKULL_TIER_1"), Map.entry("Bonzo's Mask", "BONZO_MASK"), Map.entry("Balloon Snake", "BALLOON_SNAKE"), Map.entry("Red Nose", "RED_NOSE"), Map.entry("Red Scarf", "RED_SCARF"), Map.entry("Adaptive Blade", "STONE_BLADE"), Map.entry("Master Skull - Tier 2", "MASTER_SKULL_TIER_2"), Map.entry("Adaptive Belt", "ADAPTIVE_BELT"), Map.entry("Scarf's Studies", "SCARF_STUDIES"), Map.entry("First Master Star", "FIRST_MASTER_STAR"), Map.entry("Adaptive Helmet", "ADAPTIVE_HELMET"), Map.entry("Adaptive Chestplate", "ADAPTIVE_CHESTPLATE"), Map.entry("Adaptive Leggings", "ADAPTIVE_LEGGINGS"), Map.entry("Adaptive Boots", "ADAPTIVE_BOOTS"), Map.entry("Master Skull - Tier 3", "MASTER_SKULL_TIER_3"), Map.entry("Suspicious Vial", "SUSPICIOUS_VIAL"), Map.entry("Spirit Sword", "SPIRIT_SWORD"), Map.entry("Spirit Shortbow", "ITEM_SPIRIT_BOW"), Map.entry("Spirit Boots", "THORNS_BOOTS"), Map.entry("Spirit Legendary", "LVL_1_LEGENDARY_SPIRIT"), Map.entry("Spirit Epic", "LVL_1_EPIC_SPIRIT"), Map.entry("Spirit Mask", "SPIRIT_MASK"), Map.entry("Second Master Star", "SECOND_MASTER_STAR"), Map.entry("Spirit Wing", "SPIRIT_WING"), Map.entry("Spirit Bone", "SPIRIT_BONE"), Map.entry("Spirit Stone", "SPIRIT_DECOY"), Map.entry("Shadow Fury", "SHADOW_FURY"), Map.entry("Last Breath", "LAST_BREATH"), Map.entry("Third Master Star", "THIRD_MASTER_STAR"), Map.entry("Warped Stone", "AOTE_STONE"), Map.entry("Livid Dagger", "LIVID_DAGGER"), Map.entry("Shadow Assassin Helmet", "SHADOW_ASSASSIN_HELMET"), Map.entry("Shadow Assassin Chestplate", "SHADOW_ASSASSIN_CHESTPLATE"), Map.entry("Shadow Assassin Leggings", "SHADOW_ASSASSIN_LEGGINGS"), Map.entry("Shadow Assassin Boots", "SHADOW_ASSASSIN_BOOTS"), Map.entry("Shadow Assassin Cloak", "SHADOW_ASSASSIN_CLOAK"), Map.entry("Master Skull - Tier 4", "MASTER_SKULL_TIER_4"), Map.entry("Dark Orb", "DARK_ORB"), Map.entry("Precursor Eye", "PRECURSOR_EYE"), Map.entry("Giant's Sword", "GIANTS_SWORD"), Map.entry("Necromancer Lord Helmet", "NECROMANCER_LORD_HELMET"), Map.entry("Necromancer Lord Chestplate", "NECROMANCER_LORD_CHESTPLATE"), Map.entry("Necromancer Lord Leggings", "NECROMANCER_LORD_LEGGINGS"), Map.entry("Necromancer Lord Boots", "NECROMANCER_LORD_BOOTS"), Map.entry("Fourth Master Star", "FOURTH_MASTER_STAR"), Map.entry("Summoning Ring", "SUMMONING_RING"), Map.entry("Fel Skull", "FEL_SKULL"), Map.entry("Necromancer Sword", "NECROMANCER_SWORD"), Map.entry("Soulweaver Gloves", "SOULWEAVER_GLOVES"), Map.entry("Sadan's Brooch", "SADAN_BROOCH"), Map.entry("Giant Tooth", "GIANT_TOOTH"), Map.entry("Precursor Gear", "PRECURSOR_GEAR"), Map.entry("Necron Dye", "DYE_NECRON"), Map.entry("Storm the Fish", "STORM_THE_FISH"), Map.entry("Maxor the Fish", "MAXOR_THE_FISH"), Map.entry("Goldor the Fish", "GOLDOR_THE_FISH"), Map.entry("Dark Claymore", "DARK_CLAYMORE"), Map.entry("Necron's Handle", "NECRON_HANDLE"), Map.entry("Master Skull - Tier 5", "MASTER_SKULL_TIER_5"), Map.entry("Shadow Warp", "SHADOW_WARP_SCROLL"), Map.entry("Wither Shield", "WITHER_SHIELD_SCROLL"), Map.entry("Implosion", "IMPLOSION_SCROLL"), Map.entry("Fifth Master Star", "FIFTH_MASTER_STAR"), Map.entry("Auto Recombobulator", "AUTO_RECOMBOBULATOR"), Map.entry("Wither Helmet", "WITHER_HELMET"), Map.entry("Wither Chestplate", "WITHER_CHESTPLATE"), Map.entry("Wither Leggings", "WITHER_LEGGINGS"), Map.entry("Wither Boots", "WITHER_BOOTS"), Map.entry("Wither Catalyst", "WITHER_CATALYST"), Map.entry("Wither Cloak Sword", "WITHER_CLOAK"), Map.entry("Wither Blood", "WITHER_BLOOD"), Map.entry("Shiny Wither Helmet", "SHINY_WITHER_HELMET"), Map.entry("Shiny Wither Chestplate", "SHINY_WITHER_CHESTPLATE"), Map.entry("Shiny Wither Leggings", "SHINY_WITHER_LEGGINGS"), Map.entry("Shiny Wither Boots", "SHINY_WITHER_BOOTS"), Map.entry("Shiny Necron's Handle", "SHINY_NECRON_HANDLE"), Map.entry("Dungeon Disc", "DUNGEON_DISC_1"), Map.entry("Clown Disc", "DUNGEON_DISC_2"), Map.entry("Watcher Disc", "DUNGEON_DISC_3"), Map.entry("Old Disc", "DUNGEON_DISC_4"), Map.entry("Necron Disc", "DUNGEON_DISC_5"), Map.entry("Scarf Shard", "SHARD_SCARF"), Map.entry("Thorn Shard", "SHARD_THORN"), Map.entry("Wither Shard", "SHARD_WITHER"), Map.entry("Apex Dragon Shard", "SHARD_APEX_DRAGON"), Map.entry("Power Dragon Shard", "SHARD_POWER_DRAGON"));
    private static final Map<String, String> KUUDRA_DROPS_NAME_TO_API_ID = Map.ofEntries(Map.entry("Crimson Helmet", "CRIMSON_HELMET"), Map.entry("Crimson Chestplate", "CRIMSON_CHESTPLATE"), Map.entry("Crimson Leggings", "CRIMSON_LEGGINGS"), Map.entry("Crimson Boots", "CRIMSON_BOOTS"), Map.entry("Aurora Helmet", "AURORA_HELMET"), Map.entry("Aurora Chestplate", "AURORA_CHESTPLATE"), Map.entry("Aurora Leggings", "AURORA_LEGGINGS"), Map.entry("Aurora Boots", "AURORA_BOOTS"), Map.entry("Terror Helmet", "TERROR_HELMET"), Map.entry("Terror Chestplate", "TERROR_CHESTPLATE"), Map.entry("Terror Leggings", "TERROR_LEGGINGS"), Map.entry("Terror Boots", "TERROR_BOOTS"), Map.entry("Hollow Helmet", "HOLLOW_HELMET"), Map.entry("Hollow Chestplate", "HOLLOW_CHESTPLATE"), Map.entry("Hollow Leggings", "HOLLOW_LEGGINGS"), Map.entry("Hollow Boots", "HOLLOW_BOOTS"), Map.entry("Fervor Helmet", "FERVOR_HELMET"), Map.entry("Fervor Chestplate", "FERVOR_CHESTPLATE"), Map.entry("Fervor Leggings", "FERVOR_LEGGINGS"), Map.entry("Fervor Boots", "FERVOR_BOOTS"), Map.entry("Molten Necklace", "MOLTEN_NECKLACE"), Map.entry("Molten Cloak", "MOLTEN_CLOAK"), Map.entry("Molten Belt", "MOLTEN_BELT"), Map.entry("Molten Bracelet", "MOLTEN_BRACELET"), Map.entry("Aurora Staff", "RUNIC_STAFF"), Map.entry("Hollow Wand", "HOLLOW_WAND"), Map.entry("Tormentor", "TORMENTOR"), Map.entry("Hellstorm Wand", "HELLSTORM_STAFF"), Map.entry("Enrager", "ENRAGER"), Map.entry("Enchanted Book (Fatal Tempo I)", "ENCHANTMENT_ULTIMATE_FATAL_TEMPO_1"), Map.entry("Enchanted Book (Inferno I)", "ENCHANTMENT_ULTIMATE_INFERNO_1"), Map.entry("Enchanted Book (Strong Mana I)", "ENCHANTMENT_STRONG_MANA_1"), Map.entry("Enchanted Book (Strong Mana II)", "ENCHANTMENT_STRONG_MANA_2"), Map.entry("Enchanted Book (Strong Mana III)", "ENCHANTMENT_STRONG_MANA_3"), Map.entry("Enchanted Book (Strong Mana IV)", "ENCHANTMENT_STRONG_MANA_4"), Map.entry("Enchanted Book (Strong Mana V)", "ENCHANTMENT_STRONG_MANA_5"), Map.entry("Enchanted Book (Ferocious Mana I)", "ENCHANTMENT_FEROCIOUS_MANA_1"), Map.entry("Enchanted Book (Ferocious Mana II)", "ENCHANTMENT_FEROCIOUS_MANA_2"), Map.entry("Enchanted Book (Ferocious Mana III)", "ENCHANTMENT_FEROCIOUS_MANA_3"), Map.entry("Enchanted Book (Ferocious Mana IV)", "ENCHANTMENT_FEROCIOUS_MANA_4"), Map.entry("Enchanted Book (Ferocious Mana V)", "ENCHANTMENT_FEROCIOUS_MANA_5"), Map.entry("Enchanted Book (Hardened Mana I)", "ENCHANTMENT_HARDENED_MANA_1"), Map.entry("Enchanted Book (Hardened Mana II)", "ENCHANTMENT_HARDENED_MANA_2"), Map.entry("Enchanted Book (Hardened Mana III)", "ENCHANTMENT_HARDENED_MANA_3"), Map.entry("Enchanted Book (Hardened Mana IV)", "ENCHANTMENT_HARDENED_MANA_4"), Map.entry("Enchanted Book (Hardened Mana V)", "ENCHANTMENT_HARDENED_MANA_5"), Map.entry("Enchanted Book (Mana Vampire I)", "ENCHANTMENT_MANA_VAMPIRE_1"), Map.entry("Enchanted Book (Mana Vampire II)", "ENCHANTMENT_MANA_VAMPIRE_2"), Map.entry("Enchanted Book (Mana Vampire III)", "ENCHANTMENT_MANA_VAMPIRE_3"), Map.entry("Enchanted Book (Mana Vampire IV)", "ENCHANTMENT_MANA_VAMPIRE_4"), Map.entry("Enchanted Book (Mana Vampire V)", "ENCHANTMENT_MANA_VAMPIRE_5"), Map.entry("Dusty Travel Scroll to the Kuudra Skull", "NETHER_FORTRESS_BOSS_TRAVEL_SCROLL"), Map.entry("Mandraa", "MANDRAA"), Map.entry("Kuudra Mandible", "KUUDRA_MANDIBLE"), Map.entry("Kuudra Tentacle", "KUUDRA_TENTACLE"), Map.entry("Burning Kuudra Core", "BURNING_KUUDRA_CORE"), Map.entry("Wheel of Fate", "WHEEL_OF_FATE"), Map.entry("Ananke Feather", "ANANKE_FEATHER"), Map.entry("Tentacle Dye", "TENTACLE_DYE"));

    private CroesusProfit() {
        super("(?:(?:Master )?Catacombs - Flo.*)|(?:Kuudra - .*)");
    }

    @Override
    public boolean isEnabled() {
        return SkyblockerConfigManager.get().dungeons.dungeonChestProfit.croesusProfit;
    }

    @Override
    public List<ColorHighlight> getColors(Int2ObjectMap<class_1799> slots) {
        class_1799 stack;
        ArrayList<ColorHighlight> highlights = new ArrayList<ColorHighlight>();
        class_1799 bestChest = null;
        class_1799 secondBestChest = null;
        double bestValue = 0.0;
        double secondBestValue = 0.0;
        double dungeonKeyPriceData = this.getItemPrice("DUNGEON_CHEST_KEY") * 2.0;
        for (Int2ObjectMap.Entry entry : slots.int2ObjectEntrySet()) {
            double value;
            stack = (class_1799)entry.getValue();
            String name = stack.method_7964().getString();
            if (DUNGEON_CHEST_PATTERN.matcher(name).matches()) {
                value = this.getChestValue(stack);
                if (value <= 0.0) continue;
                if (value > bestValue) {
                    secondBestChest = bestChest;
                    secondBestValue = bestValue;
                    bestChest = stack;
                    bestValue = value;
                    continue;
                }
                if (!(value > secondBestValue)) continue;
                secondBestChest = stack;
                secondBestValue = value;
                continue;
            }
            if (!KUUDRA_CHEST_PATTERN.matcher(name).matches() || (value = this.getChestValue(stack)) <= 0.0 || !(value > bestValue)) continue;
            bestChest = stack;
            bestValue = value;
        }
        for (Int2ObjectMap.Entry entry : slots.int2ObjectEntrySet()) {
            stack = (class_1799)entry.getValue();
            if (stack == null) continue;
            if (stack.equals(bestChest)) {
                highlights.add(ColorHighlight.green(entry.getIntKey()));
                continue;
            }
            if (!stack.equals(secondBestChest) || !(secondBestValue > dungeonKeyPriceData)) continue;
            highlights.add(ColorHighlight.yellow(entry.getIntKey()));
        }
        return highlights;
    }

    @Override
    public void addToTooltip(@Nullable class_1735 focusedSlot, class_1799 stack, List<class_2561> lines) {
        if (focusedSlot == null || !focusedSlot.method_7681()) {
            return;
        }
        if (!focusedSlot.method_7677().method_31574(class_1802.field_8575)) {
            return;
        }
        double value = this.getChestValue(focusedSlot.method_7677());
        lines.add((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43469((String)"skyblocker.dungeons.croesusHelper.chestValue", (Object[])new Object[]{Formatters.INTEGER_NUMBERS.format(value)})));
    }

    @Override
    public int getPriority() {
        return 16;
    }

    private double getChestValue(class_1799 chest) {
        double chestValue = 0.0;
        int chestPrice = 0;
        boolean processingContents = false;
        block13: for (class_2561 line : ItemUtils.getLore(chest)) {
            String s;
            String s2;
            String s3;
            String s4;
            String string;
            String lineString = line.getString();
            Objects.requireNonNull(lineString);
            int n = 0;
            block14: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, String.class, String.class, String.class}, (Object)string, n)) {
                    case 0: {
                        s4 = string;
                        if (!s4.contains("Contents")) {
                            n = 1;
                            continue block14;
                        }
                        processingContents = true;
                        continue block13;
                    }
                    case 1: {
                        s3 = string;
                        if (!s3.isEmpty()) {
                            n = 2;
                            continue block14;
                        }
                        processingContents = false;
                        break block14;
                    }
                    case 2: {
                        s2 = string;
                        if (!s2.endsWith("Coins")) {
                            n = 3;
                            continue block14;
                        }
                        if (processingContents) break block14;
                        String chestCost = lineString.replace(",", "").replaceAll("\\D", "");
                        if (!NumberUtils.isCreatable((String)chestCost)) continue block13;
                        chestPrice = Integer.parseInt(chestCost);
                        break block14;
                    }
                    case 3: {
                        s = string;
                        if (!s.endsWith("Kuudra Key")) {
                            n = 4;
                            continue block14;
                        }
                        if (processingContents) break block14;
                        String trimmed = lineString.trim();
                        chestPrice = (int)ChestValue.computeKuudraKeyPrice(trimmed).leftDouble();
                        break block14;
                    }
                }
                break;
            }
            if (!processingContents) continue;
            String string2 = lineString;
            Objects.requireNonNull(string2);
            string = string2;
            n = 0;
            block15: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, String.class, String.class, String.class, String.class}, (Object)string, n)) {
                    case 0: {
                        s4 = string;
                        if (!s4.contains("Essence") || !SkyblockerConfigManager.get().dungeons.dungeonChestProfit.includeEssence) {
                            n = 1;
                            continue block15;
                        }
                        Matcher matcher = ChestValue.ESSENCE_PATTERN.matcher(lineString);
                        if (!matcher.matches()) continue block13;
                        String type = matcher.group("type").toUpperCase(Locale.ENGLISH);
                        int amount = RegexUtils.parseOptionalIntFromMatcher((MatchResult)matcher, "amount").orElse(1);
                        if (type.equals("CRIMSON")) {
                            amount = (int)((float)amount * ChestValue.computeCrimsonEssenceMultiplier());
                        }
                        chestValue += this.getItemPrice("ESSENCE_" + type) * (double)amount;
                        break block15;
                    }
                    case 1: {
                        s3 = string;
                        if (!s3.contains("Shard")) {
                            n = 2;
                            continue block15;
                        }
                        Matcher matcher = ChestValue.SHARD_PATTERN.matcher(lineString);
                        if (!matcher.matches()) continue block13;
                        int shards = RegexUtils.parseOptionalIntFromMatcher((MatchResult)matcher, "amount").orElse(1);
                        Attribute attribute = Attributes.getAttributeFromItemName(lineString);
                        if (attribute == null) continue block13;
                        chestValue += this.getItemPrice(attribute.apiId()) * (double)shards;
                        break block15;
                    }
                    case 2: {
                        s2 = string;
                        if (!s2.contains("Kuudra Teeth")) {
                            n = 3;
                            continue block15;
                        }
                        Matcher matcher = ChestValue.KUUDRA_TEETH_PATTERN.matcher(lineString);
                        if (!matcher.matches()) continue block13;
                        int amount = RegexUtils.parseOptionalIntFromMatcher((MatchResult)matcher, "amount").orElse(1);
                        chestValue += this.getItemPrice("KUUDRA_TEETH") * (double)amount;
                        break block15;
                    }
                    case 3: {
                        s = string;
                        if (!s.contains("Heavy Pearl")) {
                            n = 4;
                            continue block15;
                        }
                        Matcher matcher = ChestValue.HEAVY_PEARL_PATTERN.matcher(lineString);
                        if (!matcher.matches()) continue block13;
                        int amount = RegexUtils.parseOptionalIntFromMatcher((MatchResult)matcher, "amount").orElse(1);
                        chestValue += this.getItemPrice("HEAVY_PEARL") * (double)amount;
                        break block15;
                    }
                    case 4: {
                        String s5 = string;
                        if (!s5.equals("[Lvl 1] Spirit")) {
                            n = 5;
                            continue block15;
                        }
                        if (line.method_10866().method_10973().equals((Object)class_5251.method_27718((class_124)class_124.field_1064))) {
                            chestValue += this.getItemPrice("Spirit Epic");
                            break block15;
                        }
                        chestValue += this.getItemPrice("Spirit Legendary");
                        break block15;
                    }
                    default: {
                        String adjusted = lineString.replace("\u272a", "").trim();
                        chestValue += this.getItemPrice(adjusted);
                        break block15;
                    }
                }
                break;
            }
        }
        return chestValue - (double)chestPrice;
    }

    private double getItemPrice(String itemName) {
        String dungeonApiId = DUNGEON_DROPS_NAME_TO_API_ID.get(itemName);
        String kuudraApiId = KUUDRA_DROPS_NAME_TO_API_ID.get(itemName);
        String apiIdToUse = dungeonApiId != null ? dungeonApiId : (kuudraApiId != null ? kuudraApiId : itemName);
        return ItemUtils.getItemPrice(apiIdToUse).leftDouble();
    }
}

