/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon;

import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.config.configs.DungeonsConfig;
import de.hysky.skyblocker.events.DungeonEvents;
import de.hysky.skyblocker.mixins.accessors.MapRendererInvoker;
import de.hysky.skyblocker.skyblock.dungeon.DungeonMap;
import de.hysky.skyblocker.skyblock.dungeon.secrets.DungeonManager;
import de.hysky.skyblocker.skyblock.dungeon.secrets.DungeonMapUtils;
import de.hysky.skyblocker.skyblock.dungeon.secrets.Room;
import de.hysky.skyblocker.utils.Utils;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.rendering.v1.world.WorldRenderEvents;
import net.fabricmc.fabric.api.client.rendering.v1.world.WorldTerrainRenderContext;
import net.minecraft.class_10090;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_156;
import net.minecraft.class_1806;
import net.minecraft.class_1937;
import net.minecraft.class_20;
import net.minecraft.class_22;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_330;
import net.minecraft.class_332;
import net.minecraft.class_3620;
import net.minecraft.class_9209;
import net.minecraft.class_9848;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import org.jspecify.annotations.Nullable;

public class DungeonMapTexture {
    private static final int MAP_TEXTURE_SIZE = 128;
    private static final class_2960 ID = SkyblockerMod.id("dungeon_map_tex");
    private static @Nullable class_1043 dungeonMapTexture = null;
    private static boolean requiresUpload = true;
    private static final class_10090 MAP_RENDER_STATE = (class_10090)class_156.method_654((Object)new class_10090(), state -> {
        state.field_53638 = ID;
    });
    private static final Set<Room.Type> IGNORED_ROOMS_FOR_CHECKMARK_HIDING = Set.of(Room.Type.ENTRANCE, Room.Type.BLOOD, Room.Type.FAIRY, Room.Type.UNKNOWN);
    private static final Vector2ic[] NEIGHBOUR_OFFSETS = new Vector2ic[]{new Vector2i(0, 1), new Vector2i(0, -1), new Vector2i(1, 0), new Vector2i(-1, 0)};

    @Init
    public static void init() {
        ClientLifecycleEvents.CLIENT_STARTED.register(minecraft -> {
            dungeonMapTexture = new class_1043(() -> "Skyblocker Dungeon Map", 128, 128, true);
            minecraft.method_1531().method_4616(ID, (class_1044)dungeonMapTexture);
        });
        ClientPlayConnectionEvents.JOIN.register((_handler, _sender, _client) -> DungeonMapTexture.clearMapImage());
        DungeonEvents.ROOM_MATCHED.register(_room -> DungeonMapTexture.onMapItemDataUpdate(DungeonMap.getMapIdComponent(null), true));
        WorldRenderEvents.START_MAIN.register(DungeonMapTexture::uploadMapTexture);
    }

    public static void onMapItemDataUpdate(class_9209 mapId, boolean updateMapTexture) {
        if (Utils.isInDungeons() && !DungeonManager.isInBoss() && mapId.equals((Object)DungeonMap.getMapIdComponent(null))) {
            class_22 state = class_1806.method_7997((class_9209)mapId, (class_1937)class_310.method_1551().field_1687);
            if (updateMapTexture) {
                DungeonMapTexture.updateMapImage(state);
                DungeonMapTexture.hideCheckmarks(state);
            }
            DungeonMapTexture.updateMapDecorations(state);
        }
    }

    private static void updateMapImage(class_22 mapData) {
        if (dungeonMapTexture == null) {
            return;
        }
        class_1011 pixels = dungeonMapTexture.method_4525();
        if (pixels != null) {
            for (int y = 0; y < 128; ++y) {
                for (int x = 0; x < 128; ++x) {
                    int i = x + y * 128;
                    pixels.method_61941(x, y, class_3620.method_38480((int)mapData.field_122[i]));
                }
            }
        }
        requiresUpload = true;
    }

    private static void updateMapDecorations(class_22 mapData) {
        class_330 mapRenderer = class_310.method_1551().method_61965();
        DungeonMapTexture.MAP_RENDER_STATE.field_53639.clear();
        for (class_20 decoration : mapData.method_32373()) {
            DungeonMapTexture.MAP_RENDER_STATE.field_53639.add(((MapRendererInvoker)mapRenderer).invokeExtractDecorationRenderState(decoration));
        }
    }

    private static void hideCheckmarks(class_22 mapData) {
        DungeonsConfig.DungeonMap mapConfig = SkyblockerConfigManager.get().dungeons.dungeonMap;
        if (!mapConfig.showRoomLabels || !mapConfig.hideCheckmarks) {
            return;
        }
        DungeonManager.getRoomsStream().filter(Room::isMatched).filter(room -> !IGNORED_ROOMS_FOR_CHECKMARK_HIDING.contains((Object)room.getType())).forEach(room -> DungeonManager.getRoomCheckmarkColour(mapData, room, checkmarkPixel -> {
            HashSet<Vector2ic> checkmarkPixels = new HashSet<Vector2ic>();
            HashSet<Vector2i> visited = new HashSet<Vector2i>();
            ArrayDeque<Object> queue = new ArrayDeque<Object>();
            queue.add(checkmarkPixel);
            while (!queue.isEmpty()) {
                Vector2ic current = (Vector2ic)queue.remove();
                checkmarkPixels.add(current);
                for (Vector2ic offset : NEIGHBOUR_OFFSETS) {
                    Vector2i neighbour = new Vector2i(current).add(offset);
                    if (visited.contains(neighbour) || queue.contains(neighbour) || neighbour.x() < 0 || neighbour.x() >= 128 || neighbour.y() < 0 || neighbour.y() >= 128 || !DungeonManager.matchesCheckmarkColour(DungeonMapUtils.getColor(mapData, (Vector2ic)neighbour))) continue;
                    visited.add(neighbour);
                    queue.add(neighbour);
                }
            }
            DungeonMapTexture.setPixels(checkmarkPixels, class_3620.method_38480((int)room.getType().color));
        }));
    }

    private static void setPixels(Set<Vector2ic> checkmarkPixels, int colour) {
        if (dungeonMapTexture == null) {
            return;
        }
        class_1011 pixels = dungeonMapTexture.method_4525();
        if (pixels != null) {
            for (Vector2ic pixel : checkmarkPixels) {
                pixels.method_61941(pixel.x(), pixel.y(), colour);
            }
        }
        requiresUpload = true;
    }

    private static void clearMapImage() {
        if (dungeonMapTexture == null) {
            return;
        }
        class_1011 pixels = dungeonMapTexture.method_4525();
        if (pixels != null) {
            for (int y = 0; y < 128; ++y) {
                for (int x = 0; x < 128; ++x) {
                    pixels.method_61941(x, y, class_9848.method_61335((int)-16777216));
                }
            }
        }
        requiresUpload = true;
    }

    private static void uploadMapTexture(WorldTerrainRenderContext context) {
        if (dungeonMapTexture != null && requiresUpload) {
            dungeonMapTexture.method_4524();
            requiresUpload = false;
        }
    }

    protected static void blitMap(class_332 graphics) {
        graphics.method_70857(MAP_RENDER_STATE);
    }

    public static void close() {
        if (dungeonMapTexture != null) {
            dungeonMapTexture.close();
        }
    }
}

