/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon;

import de.hysky.skyblocker.annotations.RegisterWidget;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.config.configs.DungeonsConfig;
import de.hysky.skyblocker.skyblock.dungeon.GoldorWaypointsManager;
import de.hysky.skyblocker.skyblock.tabhud.config.WidgetsConfigurationScreen;
import de.hysky.skyblocker.skyblock.tabhud.widget.ComponentBasedWidget;
import de.hysky.skyblocker.skyblock.tabhud.widget.component.PlainTextComponent;
import de.hysky.skyblocker.utils.FunUtils;
import de.hysky.skyblocker.utils.Location;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_742;

@RegisterWidget
public class TerminalHud
extends ComponentBasedWidget {
    private static final Set<Location> AVAILABLE_LOCATIONS = Set.of(Location.DUNGEON);
    private static final Supplier<DungeonsConfig.TerminalHud> CONFIG = () -> SkyblockerConfigManager.get().dungeons.terminalHud;
    private static final class_310 CLIENT = class_310.method_1551();
    public static TerminalHud INSTANCE;

    public TerminalHud() {
        super(FunUtils.shouldEnableFun() ? class_2561.method_43470((String)"P3 Guide") : class_2561.method_43470((String)"Goldor Tasks"), -65536, "terminal_hud");
        INSTANCE = this;
        Scheduler.INSTANCE.scheduleCyclic(this::updateFromScheduler, 50);
    }

    @Override
    public Set<Location> availableLocations() {
        return AVAILABLE_LOCATIONS;
    }

    @Override
    public void setEnabledIn(Location location, boolean enabled) {
        if (!AVAILABLE_LOCATIONS.contains((Object)location)) {
            return;
        }
        TerminalHud.CONFIG.get().enableTerminalHud = enabled;
    }

    @Override
    public boolean isEnabledIn(Location location) {
        if (!AVAILABLE_LOCATIONS.contains((Object)location)) {
            return false;
        }
        return TerminalHud.CONFIG.get().enableTerminalHud;
    }

    @Override
    public boolean shouldRender(Location location) {
        if (!super.shouldRender(location)) {
            return false;
        }
        return GoldorWaypointsManager.isActive();
    }

    private boolean playerIsNearTerminal(class_742 player, GoldorWaypointsManager.GoldorWaypoint waypoint) {
        return player.method_5707(waypoint.centerPos) < 25.0;
    }

    private class_2561 getStatusText(GoldorWaypointsManager.GoldorWaypoint waypoint) {
        if (waypoint.isEnabled()) {
            Optional<class_742> player;
            if (TerminalHud.CONFIG.get().showPlayerAtTerminal && TerminalHud.CLIENT.field_1687 != null && (player = TerminalHud.CLIENT.field_1687.method_18456().stream().filter(pl -> this.playerIsNearTerminal((class_742)pl, waypoint)).findFirst()).isPresent()) {
                String playerName = player.get().method_74861();
                return class_2561.method_43470((String)playerName.substring(0, Math.min(12, playerName.length()))).method_27692(class_124.field_1054);
            }
            return class_2561.method_43471((String)"skyblocker.dungeons.terminalHud.incompleteStatus").method_27692(class_124.field_1061);
        }
        return class_2561.method_43471((String)"skyblocker.dungeons.terminalHud.completeStatus").method_27692(class_124.field_1060);
    }

    public void updateFromScheduler() {
        if (TerminalHud.CLIENT.field_1755 instanceof WidgetsConfigurationScreen && !GoldorWaypointsManager.isActive()) {
            this.update();
        }
        if (!GoldorWaypointsManager.isActive() || !this.shouldRender(Utils.getLocation())) {
            return;
        }
        this.update();
    }

    @Override
    public void updateContent() {
        if (TerminalHud.CLIENT.field_1755 instanceof WidgetsConfigurationScreen && !GoldorWaypointsManager.isActive()) {
            class_5250 status = class_2561.method_43473();
            if (TerminalHud.CONFIG.get().showTerminalStatus) {
                status = class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43471((String)"skyblocker.dungeons.terminalHud.incompleteStatus").method_27692(class_124.field_1061));
            }
            if (TerminalHud.CONFIG.get().showTerminals) {
                for (int i = 0; i < 5; ++i) {
                    this.addComponent(new PlainTextComponent((class_2561)class_2561.method_43470((String)("Terminal #" + (i + 1))).method_10852((class_2561)status)));
                }
            }
            if (TerminalHud.CONFIG.get().showDevice) {
                this.addComponent(new PlainTextComponent((class_2561)class_2561.method_43470((String)"Device").method_10852((class_2561)status)));
            }
            if (TerminalHud.CONFIG.get().showLevers) {
                this.addComponent(new PlainTextComponent((class_2561)class_2561.method_43470((String)"Lever").method_10852((class_2561)status)));
                this.addComponent(new PlainTextComponent((class_2561)class_2561.method_43470((String)"Lever").method_10852((class_2561)status)));
            }
            if (TerminalHud.CONFIG.get().showGate) {
                this.addComponent(new PlainTextComponent((class_2561)class_2561.method_43470((String)"Gate").method_10852((class_2561)status)));
            }
            return;
        }
        List<GoldorWaypointsManager.GoldorWaypoint> waypoints = GoldorWaypointsManager.getPhaseWaypoints();
        if (waypoints.isEmpty()) {
            return;
        }
        block6: for (GoldorWaypointsManager.GoldorWaypoint waypoint : waypoints) {
            if (!waypoint.isEnabled() && !TerminalHud.CONFIG.get().showTerminalStatus) continue;
            switch (waypoint.kind) {
                case TERMINAL: {
                    if (TerminalHud.CONFIG.get().showTerminals) break;
                    continue block6;
                }
                case DEVICE: {
                    if (TerminalHud.CONFIG.get().showDevice) break;
                    continue block6;
                }
                case LEVER: {
                    if (TerminalHud.CONFIG.get().showGate) break;
                    continue block6;
                }
            }
            Object displayText = TerminalHud.CONFIG.get().showTerminalStatus ? waypoint.name.method_27661().method_27693(" ").method_10852(this.getStatusText(waypoint)) : waypoint.name;
            this.addComponent(new PlainTextComponent((class_2561)displayText));
        }
        if (TerminalHud.CONFIG.get().showGate && GoldorWaypointsManager.getCurrentPhase() < 3) {
            if (GoldorWaypointsManager.isGateDestroyed() && !TerminalHud.CONFIG.get().showTerminalStatus) {
                return;
            }
            class_5250 displayText = class_2561.method_43470((String)"Gate");
            if (TerminalHud.CONFIG.get().showTerminalStatus) {
                if (GoldorWaypointsManager.isGateDestroyed()) {
                    displayText.method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"skyblocker.dungeons.terminalHud.destroyedStatus").method_27692(class_124.field_1060));
                } else {
                    displayText.method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"skyblocker.dungeons.terminalHud.incompleteStatus").method_27692(class_124.field_1061));
                }
            }
            this.addComponent(new PlainTextComponent((class_2561)displayText));
        }
    }

    @Override
    public class_2561 getDisplayName() {
        return class_2561.method_43470((String)"Goldor Tasks");
    }
}

