/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon.device;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.dungeon.DungeonBoss;
import de.hysky.skyblocker.skyblock.dungeon.secrets.DungeonManager;
import de.hysky.skyblocker.utils.ColorUtils;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.render.WorldRenderExtractionCallback;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveCollector;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_1533;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrowAlign {
    private static final class_2338 LEFT_TOP = new class_2338(-2, 124, 79);
    private static final class_238 FRAMES_AREA = class_238.method_54784((class_2338)LEFT_TOP, (class_2338)new class_2338(-3, 120, 75));
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Skyblocker Arrow Align Solver");
    private static int[] currentSolution = null;
    private static boolean noSolution = false;

    @Init
    public static void init() {
        ClientPlayConnectionEvents.JOIN.register((_handler, _sender, _client) -> ArrowAlign.reset());
        WorldRenderExtractionCallback.EVENT.register(ArrowAlign::extractRendering);
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblocker").then(ClientCommandManager.literal((String)"dungeons").then(ClientCommandManager.literal((String)"device").then(ClientCommandManager.literal((String)"arrow-align").then(ClientCommandManager.literal((String)"solve").executes(context -> {
            ArrowAlign.findSolution();
            return 1;
        })))))));
    }

    private static void extractRendering(PrimitiveCollector collector) {
        if (ArrowAlign.shouldProcess() && class_310.method_1551().field_1724.method_73189().method_1025(FRAMES_AREA.method_1005()) < 64.0) {
            if (currentSolution == null && !noSolution) {
                ArrowAlign.findSolution();
            }
            if (!noSolution) {
                List<class_1533> frameEntitiesList = ArrowAlign.getFrameEntitiesList();
                for (class_1533 frameEntity : frameEntitiesList) {
                    int remaining;
                    int now = frameEntity.method_6934();
                    int expect = currentSolution[ArrowAlign.getSolutionIndex(frameEntity.method_24515())];
                    if (expect < 0 || (remaining = (expect + 8 - now) % 8) <= 0) continue;
                    collector.submitText((class_2561)class_2561.method_43470((String)String.valueOf(remaining)).method_54663(ColorUtils.interpolate(-16711936, -65536, (double)remaining / 7.0)), frameEntity.method_73189().method_1031(0.3, 0.0, 0.0), false);
                }
            }
        }
    }

    private static List<class_1533> getFrameEntitiesList() {
        return class_310.method_1551().field_1687.method_8390(class_1533.class, FRAMES_AREA, frame -> true);
    }

    private static int getSolutionIndex(class_2338 pos) {
        return (LEFT_TOP.method_10264() - pos.method_10264()) * 5 + LEFT_TOP.method_10260() - pos.method_10260();
    }

    private static void findSolution() {
        List<class_1533> frameEntitiesList = ArrowAlign.getFrameEntitiesList();
        Optional<int[]> solution = Align.SOLUTIONS.stream().filter(rotations -> {
            block5: for (class_1533 itemFrame : frameEntitiesList) {
                switch (rotations[ArrowAlign.getSolutionIndex(itemFrame.method_24515())]) {
                    case -1: {
                        return false;
                    }
                    case -2: {
                        if (itemFrame.method_6940().method_31574(class_1802.field_19049)) continue block5;
                        return false;
                    }
                    case -3: {
                        if (itemFrame.method_6940().method_31574(class_1802.field_19058)) continue block5;
                        return false;
                    }
                }
                if (itemFrame.method_6940().method_31574(class_1802.field_8107)) continue;
                return false;
            }
            return true;
        }).findAny();
        currentSolution = solution.orElse(null);
        noSolution = solution.isEmpty();
        if (noSolution) {
            LOGGER.error("[Skyblocker Arrow Align] Failed to find a solution for Arrow Align device!");
        }
    }

    private static boolean shouldProcess() {
        return SkyblockerConfigManager.get().dungeons.devices.solveArrowAlign && Utils.isInDungeons() && DungeonManager.isInBoss() && DungeonManager.getBoss() == DungeonBoss.MAXOR;
    }

    private static void reset() {
        currentSolution = null;
        noSolution = false;
    }

    private static class Align {
        private static final int X = -1;
        private static final int S = -2;
        private static final int E = -3;
        private static final int U = 7;
        private static final int D = 3;
        private static final int L = 5;
        private static final int R = 1;
        private static final List<int[]> SOLUTIONS = List.of(new int[]{1, 1, 3, -1, -1, 7, -1, 3, -1, -1, -2, -1, 3, -1, -3, -1, -1, 3, -1, 7, -1, -1, 1, 1, 7}, new int[]{1, 1, -3, 5, 5, 7, -1, -1, -1, 7, 7, 5, -1, 1, 7, -1, 7, -1, 7, -1, -1, -2, -1, -2, -1}, new int[]{3, 5, 5, -1, -1, 3, -1, 7, -1, -1, -3, -1, -2, -1, -3, -1, -1, 3, -1, 7, -1, -1, 1, 1, 7}, new int[]{-2, -1, -1, -1, -2, 3, -1, -1, -1, 3, 3, -1, -3, -1, 3, 3, -1, 7, -1, 3, 1, 1, 7, 5, 5}, new int[]{1, 1, 1, 1, 3, 7, -1, -1, -1, 3, 7, -1, -3, -1, 3, 7, -1, 7, -1, 3, -2, -1, 7, 5, 5}, new int[]{1, 1, 3, -1, -3, 7, -1, 3, -1, 7, 7, -1, 3, -1, 7, 7, -1, 3, -1, 7, -2, -1, 1, 1, 7}, new int[]{-2, 1, 1, 1, -3, -1, -1, -1, -1, -1, -2, 1, 1, 1, -3, -1, -1, -1, -1, -1, -2, 1, 1, 1, -3}, new int[]{-1, 1, 1, 3, -1, -1, 7, -1, 3, -1, -1, 7, -1, 3, -1, -1, 7, -1, 3, -1, -2, 7, -1, 1, -3}, new int[]{-2, 1, 3, -1, -1, -1, -1, 1, 1, -3, -2, 1, 7, -1, -1, -1, -1, 1, 1, -3, -2, 1, 7, -1, -1});

        private Align() {
        }
    }
}

