/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon.partyfinder;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.PropertyMap;
import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.skyblock.dungeon.partyfinder.PartyFinderScreen;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1068;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4265;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_7532;
import net.minecraft.class_9296;
import net.minecraft.class_9334;
import org.joml.Matrix3x2fStack;

public class PartyEntry
extends class_4265.class_4266<PartyEntry> {
    private static final class_2960 PARTY_CARD_TEXTURE = SkyblockerMod.id("textures/gui/party_card.png");
    private static final class_2960 PARTY_CARD_TEXTURE_HOVER = SkyblockerMod.id("textures/gui/party_card_hover.png");
    private static final Map<String, class_9296> SKULL_CACHE = new Object2ObjectOpenHashMap();
    private static final Pattern NUMBERS_PATTERN = Pattern.compile("\\d+$");
    public static final class_2561 JOIN_TEXT = class_2561.method_43471((String)"skyblocker.partyFinder.join");
    protected final PartyFinderScreen screen;
    protected final int slotID;
    Player partyLeader;
    String floor = "???";
    String dungeon = "???";
    String note = "";
    PropertyMap floorSkullProperties = PropertyMap.EMPTY;
    class_2960 partyLeaderSkin = class_1068.method_4649();
    Player[] partyMembers = new Player[4];
    int minClassLevel = -1;
    int minCatacombsLevel = -1;
    boolean isLocked = false;
    class_2561 lockReason = class_2561.method_43473();

    public boolean isLocked() {
        return this.isLocked;
    }

    public PartyEntry(class_2561 title, List<class_2561> tooltips, PartyFinderScreen screen, int slotID) {
        int i;
        this.screen = screen;
        this.slotID = slotID;
        Arrays.fill(this.partyMembers, null);
        if (tooltips.isEmpty()) {
            return;
        }
        class_310 client = class_310.method_1551();
        String partyHost = title.getString().split("'s")[0];
        int membersIndex = -1;
        for (i = 0; i < tooltips.size(); ++i) {
            Matcher matcher;
            class_2561 text = tooltips.get(i);
            String tooltipText = class_124.method_539((String)text.getString());
            assert (tooltipText != null);
            String lowerCase = tooltipText.toLowerCase(Locale.ENGLISH);
            if (lowerCase.contains("members:") && membersIndex == -1) {
                membersIndex = i + 1;
                continue;
            }
            if (lowerCase.contains("class level")) {
                matcher = NUMBERS_PATTERN.matcher(lowerCase);
                if (!matcher.find()) continue;
                this.minClassLevel = Integer.parseInt(matcher.group());
                continue;
            }
            if (lowerCase.contains("dungeon level")) {
                matcher = NUMBERS_PATTERN.matcher(lowerCase);
                if (!matcher.find()) continue;
                this.minCatacombsLevel = Integer.parseInt(matcher.group());
                continue;
            }
            if (lowerCase.contains("floor:")) {
                this.floor = tooltipText.split(":")[1].trim();
                if (this.dungeon.equals("???") || PartyFinderScreen.floorIconsMaster == null || PartyFinderScreen.floorIconsNormal == null) continue;
                if (this.dungeon.contains("Master Mode")) {
                    try {
                        this.floorSkullProperties = PartyFinderScreen.floorIconsMaster.getOrDefault(this.floor.toLowerCase(Locale.ENGLISH), PropertyMap.EMPTY);
                        continue;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                try {
                    this.floorSkullProperties = PartyFinderScreen.floorIconsNormal.getOrDefault(this.floor.toLowerCase(Locale.ENGLISH), PropertyMap.EMPTY);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (lowerCase.contains("dungeon:")) {
                this.dungeon = tooltipText.split(":")[1].trim();
                continue;
            }
            if (!text.method_10855().isEmpty() && Objects.equals(((class_2561)text.method_10855().getFirst()).method_10866().method_10973(), class_5251.method_27717((int)class_124.field_1061.method_532())) && !lowerCase.startsWith(" ")) {
                this.isLocked = true;
                this.lockReason = text;
                continue;
            }
            if (!lowerCase.contains("note:")) continue;
            String[] split = tooltipText.split(":", 2);
            this.note = split.length == 2 ? split[1].trim() : "???";
        }
        if (membersIndex != -1) {
            i = membersIndex;
            int j = 0;
            while (i < membersIndex + 5) {
                String[] parts;
                String playerNameTrim;
                class_2561 text;
                String memberText;
                if (i < tooltips.size() && (memberText = (text = tooltips.get(i)).getString()).startsWith(" ") && !(playerNameTrim = (parts = memberText.split(":", 2))[0].trim()).equals("Empty")) {
                    List siblings = text.method_10855();
                    class_2583 nameStyle = !siblings.isEmpty() ? ((class_2561)siblings.get(Math.min(1, siblings.size() - 1))).method_10866() : text.method_10866();
                    class_5250 playerName = class_2561.method_43470((String)playerNameTrim).method_10862(nameStyle);
                    String className = parts[1].trim().split(" ")[0];
                    int classLevel = -1;
                    Matcher matcher = Pattern.compile("\\((\\d+)\\)").matcher(parts[1]);
                    if (matcher.find()) {
                        classLevel = Integer.parseInt(matcher.group(1));
                    }
                    Player player = new Player((class_2561)playerName, className, classLevel);
                    client.method_73362().method_74320(class_9296.method_74889((String)playerNameTrim)).thenAccept(gameProfile -> gameProfile.ifPresent(entry -> {
                        player.skinTexture = entry.method_73503().comp_1626().comp_3627();
                    }));
                    if (playerNameTrim.equals(partyHost)) {
                        this.partyLeader = player;
                        --j;
                    } else if (j > 3) {
                        this.partyLeader = player;
                    } else {
                        this.partyMembers[j] = player;
                    }
                }
                ++i;
                ++j;
            }
        }
        if (this.partyLeader == null) {
            for (i = this.partyMembers.length - 1; i >= 0; --i) {
                if (this.partyMembers[i] == null) continue;
                this.partyLeader = this.partyMembers[i];
                this.partyMembers[i] = null;
                break;
            }
        }
        if (this.partyLeader == null) {
            this.partyLeader = new Player((class_2561)class_2561.method_43470((String)"Error"), "Error", -1);
        }
        client.method_73362().method_74320(class_9296.method_74889((String)this.partyLeader.name.getString())).thenAccept(gameProfile -> gameProfile.ifPresent(entry -> {
            this.partyLeaderSkin = entry.method_73503().comp_1626().comp_3627();
        }));
    }

    public List<? extends class_6379> method_37025() {
        return List.of();
    }

    public List<? extends class_364> method_25396() {
        return List.of();
    }

    public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
        int x = this.method_46426();
        int y = this.method_46427();
        int entryWidth = this.method_25368();
        int entryHeight = this.method_25364();
        Matrix3x2fStack matrices = context.method_51448();
        matrices.pushMatrix();
        matrices.translate((float)x, (float)y);
        class_327 textRenderer = class_310.method_1551().field_1772;
        if (hovered && !this.isLocked) {
            context.method_25290(class_10799.field_56883, PARTY_CARD_TEXTURE_HOVER, 0, 0, 0.0f, 0.0f, 336, 64, 336, 64);
            if (!(this instanceof YourParty)) {
                context.method_51439(textRenderer, JOIN_TEXT, 148, 6, -1, false);
            }
        } else {
            context.method_25290(class_10799.field_56883, PARTY_CARD_TEXTURE, 0, 0, 0.0f, 0.0f, 336, 64, 336, 64);
        }
        int mouseXLocal = mouseX - x;
        int mouseYLocal = mouseY - y;
        context.method_51439(textRenderer, this.partyLeader.toText(), 18, 6, -1, true);
        if (PartyFinderScreen.DEBUG) {
            context.method_51433(textRenderer, String.valueOf(this.slotID), 166, 6, -1, true);
            if (hovered) {
                context.method_51433(textRenderer, "H", 160, 6, -1, true);
            }
        }
        class_7532.method_44445((class_332)context, (class_2960)this.partyLeaderSkin, (int)6, (int)6, (int)8, (boolean)true, (boolean)false, (int)-1);
        for (int i = 0; i < this.partyMembers.length; ++i) {
            Player partyMember = this.partyMembers[i];
            if (partyMember == null) continue;
            context.method_27535(textRenderer, partyMember.toText(), 17 + 136 * (i % 2), 24 + 14 * (i / 2), -1);
            class_7532.method_44445((class_332)context, (class_2960)partyMember.skinTexture, (int)(6 + 136 * (i % 2)), (int)(24 + 14 * (i / 2)), (int)8, (boolean)true, (boolean)false, (int)-1);
        }
        if (this.minClassLevel > 0) {
            context.method_27535(textRenderer, class_2561.method_30163((String)("Class " + this.minClassLevel)), 278, 25, -1);
            if (!this.isLocked && hovered && mouseXLocal >= 276 && mouseXLocal <= 331 && mouseYLocal >= 22 && mouseYLocal <= 35) {
                context.method_51438(textRenderer, (class_2561)class_2561.method_43469((String)"skyblocker.partyFinder.partyCard.minClassLevel", (Object[])new Object[]{this.minClassLevel}), mouseX, mouseY);
            }
        }
        if (this.minCatacombsLevel > 0) {
            context.method_27535(textRenderer, class_2561.method_30163((String)("Cata " + this.minCatacombsLevel)), 278, 43, -1);
            if (!this.isLocked && hovered && mouseXLocal >= 276 && mouseXLocal <= 331 && mouseYLocal >= 40 && mouseYLocal <= 53) {
                context.method_51438(textRenderer, (class_2561)class_2561.method_43469((String)"skyblocker.partyFinder.partyCard.minDungeonLevel", (Object[])new Object[]{this.minCatacombsLevel}), mouseX, mouseY);
            }
        }
        class_1799 stack = new class_1799((class_1935)class_1802.field_8575);
        stack.method_57379(class_9334.field_49617, (Object)SKULL_CACHE.computeIfAbsent("SkyblockerCustomPFSkull" + this.dungeon + this.floor, name -> class_9296.method_73307((GameProfile)new GameProfile(UUID.randomUUID(), name, this.floorSkullProperties))));
        context.method_51427(stack, 317, 3);
        int textWidth = textRenderer.method_1727(this.floor);
        context.method_51433(textRenderer, this.floor, 314 - textWidth, 7, -1610612736, false);
        context.method_51433(textRenderer, this.note, 5, 52, -1, true);
        if (this.isLocked) {
            context.method_25294(0, 0, entryWidth, entryHeight, -1879048192);
            matrices.pushMatrix();
            matrices.translate((float)entryWidth / 2.0f, (float)entryHeight / 2.0f);
            int lockWidth = textRenderer.method_27525((class_5348)this.lockReason) + 6;
            Objects.requireNonNull(textRenderer);
            int textHeight = 9;
            context.method_25294(-lockWidth / 2, -2, lockWidth / 2, textHeight, 0x7F000000);
            context.method_27534(textRenderer, this.lockReason, 0, 0, -2142128);
            matrices.popMatrix();
        }
        matrices.popMatrix();
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        if (this.slotID == -1) {
            PartyFinderScreen.LOGGER.error("[Skyblocker] Slot ID is null for " + this.partyLeader.name.getString() + "'s party");
        }
        if (click.method_74245() == 0 && !this.screen.isWaitingForServer() && this.slotID != -1) {
            this.screen.clickAndWaitForServer(this.slotID);
            return true;
        }
        return super.method_25402(click, doubled);
    }

    public static class Player {
        public final class_2561 name;
        public final String dungeonClass;
        public final int classLevel;
        public class_2960 skinTexture = class_1068.method_4649();

        Player(class_2561 name, String dungeonClass, int classLevel) {
            this.name = name;
            this.dungeonClass = dungeonClass;
            this.classLevel = classLevel;
        }

        public class_2561 toText() {
            char dClass = this.dungeonClass.isEmpty() ? (char)'?' : (char)this.dungeonClass.charAt(0);
            return this.name.method_27661().method_10852((class_2561)class_2561.method_43470((String)(" " + dClass + " " + this.classLevel)).method_27692(class_124.field_1054));
        }
    }

    public static class YourParty
    extends PartyEntry {
        public static final class_2561 DE_LIST_TEXT = class_2561.method_43471((String)"skyblocker.partyFinder.deList");
        public static final class_2561 YOUR_PARTY_TEXT = class_2561.method_43471((String)"skyblocker.partyFinder.yourParty");

        public YourParty(class_2561 title, List<class_2561> tooltips, PartyFinderScreen screen, int deListSlotId) {
            super(title, tooltips, screen, deListSlotId);
        }

        @Override
        public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
            super.method_25343(context, mouseX, mouseY, hovered, deltaTicks);
            Matrix3x2fStack matrices = context.method_51448();
            matrices.pushMatrix();
            matrices.translate((float)this.method_46426(), (float)this.method_46427());
            boolean bl = this.slotID != -1;
            class_327 textRenderer = class_310.method_1551().field_1772;
            context.method_51439(textRenderer, (hovered &= bl) ? DE_LIST_TEXT : YOUR_PARTY_TEXT, 148, 6, -1, false);
            matrices.popMatrix();
        }
    }

    public static class NoParties
    extends PartyEntry {
        public NoParties() {
            super((class_2561)class_2561.method_43473(), List.of(), null, -1);
        }

        @Override
        public boolean method_25402(class_11909 click, boolean doubled) {
            return false;
        }

        @Override
        public void method_25343(class_332 context, int mouseX, int mouseY, boolean hovered, float deltaTicks) {
            class_327 textRenderer = class_310.method_1551().field_1772;
            class_5250 class_52502 = class_2561.method_43471((String)"skyblocker.partyFinder.noParties");
            int n = this.method_46426() + this.method_25368() / 2;
            int n2 = this.method_46427() + this.method_25364() / 2;
            Objects.requireNonNull(textRenderer);
            context.method_27534(textRenderer, (class_2561)class_52502, n, n2 - 9 / 2, -1);
        }
    }
}

