/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon.preview;

import de.hysky.skyblocker.skyblock.dungeon.preview.RoomPreviewServer;
import de.hysky.skyblocker.skyblock.dungeon.secrets.DungeonManager;
import de.hysky.skyblocker.skyblock.dungeon.secrets.DungeonMapUtils;
import de.hysky.skyblocker.skyblock.dungeon.secrets.Room;
import de.hysky.skyblocker.skyblock.dungeon.secrets.SecretWaypoint;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import net.minecraft.class_1132;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import org.joml.Vector2i;
import org.joml.Vector2ic;

public class PreviewRoom
extends Room {
    private static final Vector2ic ORIGIN = new Vector2i(0, 0);

    public PreviewRoom(String name) {
        super(Room.Type.ROOM, ORIGIN);
        this.direction = Room.Direction.NW;
        this.matchState = Room.MatchState.MATCHED;
        this.name = name;
        this.physicalCornerPos = ORIGIN;
        this.loadSecrets();
    }

    @Override
    protected Room.Direction[] getPossibleDirections(IntSortedSet segmentsX, IntSortedSet segmentsY) {
        return new Room.Direction[]{Room.Direction.NW};
    }

    @Override
    protected void onUseBlock(class_1937 level, class_2338 pos) {
        if (!level.method_8608()) {
            return;
        }
        super.onUseBlock(level, pos);
    }

    protected void loadSecrets() {
        List<DungeonManager.RoomWaypoint> roomWaypoints = DungeonManager.getRoomWaypoints(RoomPreviewServer.selectedRoom);
        if (roomWaypoints != null) {
            roomWaypoints.forEach(waypoint -> {
                String secretName = waypoint.secretName();
                Matcher secretIndexMatcher = SECRET_INDEX.matcher(secretName);
                int secretIndex = secretIndexMatcher.find() ? Integer.parseInt(secretIndexMatcher.group(1)) : 0;
                class_2338 pos = DungeonMapUtils.relativeToActual(this.getDirection(), this.getPhysicalCornerPos(), waypoint);
                SecretWaypoint secretWaypoint = new SecretWaypoint(secretIndex, waypoint.category(), secretName, pos);
                this.secretWaypoints.put((Object)secretIndex, (Object)pos, (Object)secretWaypoint);
                this.showSecretInLevel(secretWaypoint);
            });
        }
        Map<class_2338, SecretWaypoint> customWaypoints = DungeonManager.getCustomWaypoints(RoomPreviewServer.selectedRoom);
        customWaypoints.forEach((pos, secretWaypoint) -> this.secretWaypoints.put((Object)secretWaypoint.secretIndex, pos, secretWaypoint));
    }

    protected void showSecretInLevel(SecretWaypoint waypoint) {
        class_2248 block;
        class_1132 server = class_310.method_1551().method_1576();
        if (server == null) {
            return;
        }
        class_3218 level = server.method_30002();
        switch (waypoint.category) {
            default: {
                throw new MatchException(null, null);
            }
            case ENTRANCE: 
            case STONK: 
            case AOTV: 
            case PEARL: 
            case PRINCE: 
            case DEFAULT: {
                class_2248 class_22482 = null;
                break;
            }
            case BAT: {
                class_2248 class_22482 = class_2246.field_10357;
                break;
            }
            case CHEST: {
                class_2248 class_22482 = class_2246.field_10034;
                break;
            }
            case FAIRYSOUL: {
                class_2248 class_22482 = class_2246.field_10317;
                break;
            }
            case ITEM: {
                class_2248 class_22482 = class_2246.field_10060;
                break;
            }
            case LEVER: {
                class_2248 class_22482 = class_2246.field_10363;
                break;
            }
            case SUPERBOOM: {
                class_2248 class_22482 = class_2246.field_10375;
                break;
            }
            case WITHER: 
            case REDSTONE_KEY: {
                class_2248 class_22482 = block = class_2246.field_10432;
            }
        }
        if (block == null) {
            return;
        }
        class_2680 state = block.method_9564();
        server.execute(() -> {
            level.method_8501(waypoint.pos, state);
            level.method_70635(waypoint.pos, state);
        });
    }
}

