/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon.preview;

import de.hysky.skyblocker.SkyblockerMod;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.skyblock.dungeon.preview.RoomPreview;
import de.hysky.skyblocker.skyblock.dungeon.preview.RoomStructure;
import de.hysky.skyblocker.skyblock.dungeon.secrets.DungeonManager;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1132;
import net.minecraft.class_124;
import net.minecraft.class_1267;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1928;
import net.minecraft.class_1934;
import net.minecraft.class_1940;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2784;
import net.minecraft.class_2794;
import net.minecraft.class_2897;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3232;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_5285;
import net.minecraft.class_5317;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7712;
import net.minecraft.class_7723;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.FileUtils;
import org.jspecify.annotations.Nullable;

public class RoomPreviewServer {
    private static final class_310 CLIENT = class_310.method_1551();
    private static final String SAVE_NAME = "skyblocker-room-preview";
    public static boolean isActive = false;
    static String selectedRoom = "";
    static List<class_2561> errorMessages = new ArrayList<class_2561>();

    @Init
    public static void init() {
        ServerPlayerEvents.JOIN.register(RoomPreviewServer::onPlayerJoin);
        ServerPlayerEvents.AFTER_RESPAWN.register((_oldP, newP, _alive) -> RoomPreviewServer.applyNightVision(newP));
        ServerLifecycleEvents.SERVER_STARTED.register(RoomPreviewServer::checkServer);
        ServerLifecycleEvents.SERVER_STOPPING.register(_server -> RoomPreviewServer.reset());
    }

    public static void onPlayerJoin(class_3222 player) {
        if (!isActive) {
            return;
        }
        RoomPreviewServer.applyNightVision(player);
        player.method_64398((class_2561)Constants.PREFIX.get().method_27693(class_2561.method_43469((String)"skyblocker.dungeons.roomPreview.joinMessage", (Object[])new Object[]{selectedRoom}).getString()));
        if (player.method_5667().equals(CLIENT.method_1548().method_44717())) {
            CLIENT.execute(() -> Scheduler.INSTANCE.schedule(RoomPreview::onJoin, 5));
            for (class_2561 msg : errorMessages) {
                player.method_64398(msg);
            }
            errorMessages.clear();
        }
    }

    public static void applyNightVision(class_3222 player) {
        if (!isActive) {
            return;
        }
        player.method_6092(new class_1293(class_1294.field_5925, -1, 1, false, false));
    }

    private static void checkServer(MinecraftServer server) {
        if (isActive) {
            return;
        }
        if (!server.method_27728().method_150().equals(SAVE_NAME)) {
            return;
        }
        class_2487 previewData = server.method_22827().method_22546(SkyblockerMod.id(SAVE_NAME));
        if (previewData.method_33133()) {
            return;
        }
        isActive = server.method_22827().method_22546(SkyblockerMod.id(SAVE_NAME)).method_68566("isActive", false);
        selectedRoom = server.method_22827().method_22546(SkyblockerMod.id(SAVE_NAME)).method_68564("selectedRoom", "");
    }

    private static void reset() {
        isActive = false;
        selectedRoom = "";
        errorMessages.clear();
    }

    public static void createServer() {
        File previousSave = CLIENT.method_1586().method_52238(SAVE_NAME).toFile();
        FileUtils.deleteQuietly((File)previousSave);
        class_1928 gameRules = new class_1928(class_7712.field_40260.comp_1011());
        gameRules.method_76186(class_1928.field_19396, (Object)false, null);
        gameRules.method_76186(class_1928.field_19399, (Object)0, null);
        isActive = true;
        CLIENT.method_41735().method_41895(SAVE_NAME, new class_1940(SAVE_NAME, class_1934.field_9219, false, class_1267.field_5801, true, gameRules, class_7712.field_40260), new class_5285((long)SAVE_NAME.hashCode(), false, false), lookup -> {
            class_7723 preset = class_5317.method_64225((class_7225.class_7874)lookup);
            class_3232 config = new class_3232(Optional.empty(), (class_6880)lookup.method_46762(class_7924.field_41236).method_46747(class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)class_2960.method_60656((String)"the_void"))), List.of());
            return preset.method_45522(lookup, (class_2794)new class_2897(config));
        }, (class_437)new class_442());
        class_1132 server = CLIENT.method_1576();
        if (server == null) {
            RoomPreviewServer.reset();
        }
    }

    public static void addErrorMessage(class_2561 errorText) {
        errorMessages.add((class_2561)Constants.PREFIX.get().method_27693(errorText.getString()));
    }

    public static @Nullable class_3499 getStructureTemplate(String type, String roomName) {
        Optional<int[]> blockData = DungeonManager.getRoomBlockData(type, roomName);
        return blockData.map(blocks -> {
            class_3499 template = new class_3499();
            template.method_15183((class_7871)class_7923.field_41175, RoomStructure.getCompound(blocks));
            return template;
        }).orElse(null);
    }

    public static void loadRoom(String type, String roomName) {
        class_1132 server = CLIENT.method_1576();
        if (server == null) {
            return;
        }
        selectedRoom = roomName;
        class_3499 template = RoomPreviewServer.getStructureTemplate(type, roomName);
        if (template == null) {
            RoomPreviewServer.addErrorMessage((class_2561)class_2561.method_43469((String)"skyblocker.dungeons.roomPreview.failedToLoad", (Object[])new Object[]{class_2561.method_43471((String)"skyblocker.dungeons.roomPreview.invalidRoom")}).method_27692(class_124.field_1061));
            return;
        }
        server.execute(() -> template.method_15172((class_5425)server.method_30002(), class_2338.field_10980, class_2338.field_10980, new class_3492(), server.method_30002().method_8409(), 0));
        server.execute(() -> {
            class_2784 border = server.method_30002().method_8621();
            border.method_11978(((double)template.method_15160().method_10263() + 1.0) / 2.0, ((double)template.method_15160().method_10260() + 1.0) / 2.0);
            border.method_11969((double)Math.max(template.method_15160().method_10263(), template.method_15160().method_10260()));
        });
        server.execute(() -> {
            class_2487 previewData = new class_2487();
            previewData.method_10556("isActive", true);
            previewData.method_10582("selectedRoom", roomName);
            server.method_22827().method_22547(SkyblockerMod.id(SAVE_NAME), previewData);
        });
    }
}

