/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon.preview;

import de.hysky.skyblocker.skyblock.dungeon.preview.SkeletonBlock;
import de.hysky.skyblocker.skyblock.dungeon.secrets.DungeonManager;
import it.unimi.dsi.fastutil.objects.Object2ByteMap;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

public class RoomStructure {
    static class_2487 getCompound(int[] blocks) {
        return RoomStructure.createCompound(RoomStructure.createBlockList(blocks));
    }

    public static List<SkeletonBlock> createBlockList(int[] blocks) {
        return Arrays.stream(blocks).mapToObj(SkeletonBlock::from).toList();
    }

    public static class_2487 createCompound(List<SkeletonBlock> blockData) {
        class_2487 structure = new class_2487();
        structure.method_10566("size", (class_2520)RoomStructure.getSize(blockData));
        class_2487[] sortedPalette = new class_2487[DungeonManager.NUMERIC_ID.size()];
        for (Object2ByteMap.Entry entry : DungeonManager.NUMERIC_ID.object2ByteEntrySet()) {
            class_2487 paletteBlock = new class_2487();
            paletteBlock.method_10566("Name", (class_2520)class_2519.method_23256((String)((String)entry.getKey())));
            sortedPalette[entry.getByteValue() - 1] = paletteBlock;
        }
        class_2499 palette = new class_2499();
        palette.addAll(Arrays.asList(sortedPalette));
        structure.method_10566("palette", (class_2520)palette);
        class_2499 blocks = new class_2499();
        for (SkeletonBlock block : blockData) {
            class_2487 nbtBlock = new class_2487();
            class_2499 posList = new class_2499();
            posList.add((Object)class_2497.method_23247((int)block.x()));
            posList.add((Object)class_2497.method_23247((int)block.y()));
            posList.add((Object)class_2497.method_23247((int)block.z()));
            nbtBlock.method_10566("pos", (class_2520)posList);
            nbtBlock.method_10566("state", (class_2520)class_2497.method_23247((int)(block.blockType() - 1)));
            blocks.add((Object)nbtBlock);
        }
        structure.method_10566("blocks", (class_2520)blocks);
        return structure;
    }

    static class_2499 getSize(List<SkeletonBlock> blockData) {
        int minX = blockData.getFirst().x();
        int minY = 0;
        int minZ = blockData.getFirst().z();
        int maxX = blockData.getLast().x();
        int maxY = blockData.getLast().y();
        int maxZ = blockData.getLast().z();
        for (SkeletonBlock block : blockData) {
            if (block.x() > maxX) {
                maxX = block.x();
            }
            if (block.x() < minX) {
                minX = block.x();
            }
            if (block.y() > maxY) {
                maxY = block.y();
            }
            if (block.y() < minY) {
                minY = block.y();
            }
            if (block.z() > maxZ) {
                maxZ = block.z();
            }
            if (block.z() >= minZ) continue;
            minZ = block.z();
        }
        class_2499 sizeList = new class_2499();
        sizeList.add((Object)class_2497.method_23247((int)(maxX - minX)));
        sizeList.add((Object)class_2497.method_23247((int)(maxY - minY)));
        sizeList.add((Object)class_2497.method_23247((int)(maxZ - minZ)));
        return sizeList;
    }
}

