/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon.puzzle;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.dungeon.puzzle.DungeonPuzzle;
import de.hysky.skyblocker.utils.ColorUtils;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveCollector;
import it.unimi.dsi.fastutil.objects.ObjectDoublePair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_1301;
import net.minecraft.class_1548;
import net.minecraft.class_1767;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.joml.Intersectiond;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreeperBeams
extends DungeonPuzzle {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)CreeperBeams.class.getName());
    private static final float[][] COLORS = new float[][]{ColorUtils.getFloatComponents(class_1767.field_7951), ColorUtils.getFloatComponents(class_1767.field_7961), ColorUtils.getFloatComponents(class_1767.field_7947), ColorUtils.getFloatComponents(class_1767.field_7958), ColorUtils.getFloatComponents(class_1767.field_7954)};
    private static final float[] GREEN_COLOR_COMPONENTS = ColorUtils.getFloatComponents(class_1767.field_7942);
    private static final int FLOOR_Y = 68;
    private static final int BASE_Y = 74;
    private static final CreeperBeams INSTANCE = new CreeperBeams();
    private static ArrayList<Beam> beams = new ArrayList();
    private static @Nullable class_2338 base = null;

    private CreeperBeams() {
        super("creeper", "creeper-room");
    }

    @Init
    public static void init() {
    }

    @Override
    public void reset() {
        super.reset();
        beams.clear();
        base = null;
    }

    @Override
    public void tick(class_310 client) {
        if (!this.shouldSolve()) {
            return;
        }
        if (client.field_1687 == null || client.field_1724 == null || !Utils.isInDungeons()) {
            return;
        }
        if (base == null) {
            base = CreeperBeams.findCreeperBase(client.field_1724, client.field_1687);
            if (base == null) {
                return;
            }
            class_243 creeperPos = new class_243((double)base.method_10263() + 0.5, 75.75, (double)base.method_10260() + 0.5);
            ArrayList<class_2338> targets = CreeperBeams.findTargets(client.field_1687, base);
            beams = CreeperBeams.findLines(creeperPos, targets);
        }
        beams.forEach(b -> b.updateState(client.field_1687));
        if (!CreeperBeams.isTarget(client.field_1687, base)) {
            this.reset();
        }
    }

    private static @Nullable class_2338 findCreeperBase(class_746 player, class_638 world) {
        List creepers = world.method_8390(class_1548.class, player.method_5829().method_1014(50.0), class_1301.field_6154);
        if (creepers.isEmpty()) {
            return null;
        }
        for (class_1548 ce : creepers) {
            class_243 creeperPos = ce.method_73189();
            class_2338 potentialBase = class_2338.method_49637((double)creeperPos.field_1352, (double)74.0, (double)creeperPos.field_1350);
            if (!CreeperBeams.isTarget(world, potentialBase)) continue;
            return potentialBase;
        }
        return null;
    }

    private static ArrayList<class_2338> findTargets(class_638 world, class_2338 basePos) {
        ArrayList<class_2338> targets = new ArrayList<class_2338>();
        class_2338 start = new class_2338(basePos.method_10263() - 15, 86, basePos.method_10260() - 15);
        class_2338 end = new class_2338(basePos.method_10263() + 16, 68, basePos.method_10260() + 16);
        for (class_2338 pos : class_2338.method_10097((class_2338)start, (class_2338)end)) {
            if (!CreeperBeams.isTarget(world, pos)) continue;
            targets.add(new class_2338((class_2382)pos));
        }
        return targets;
    }

    private static ArrayList<Beam> findLines(class_243 creeperPos, ArrayList<class_2338> targets) {
        ArrayList<ObjectDoublePair> allLines = new ArrayList<ObjectDoublePair>();
        for (int i = 0; i < targets.size(); ++i) {
            for (int j = i + 1; j < targets.size(); ++j) {
                Beam beam2 = new Beam(targets.get(i), targets.get(j));
                double dist = Intersectiond.distancePointLine((double)creeperPos.field_1352, (double)creeperPos.field_1351, (double)creeperPos.field_1350, (double)beam2.line[0].field_1352, (double)beam2.line[0].field_1351, (double)beam2.line[0].field_1350, (double)beam2.line[1].field_1352, (double)beam2.line[1].field_1351, (double)beam2.line[1].field_1350);
                allLines.add(ObjectDoublePair.of((Object)beam2, (double)dist));
            }
        }
        ArrayList<Beam> result = new ArrayList<Beam>();
        allLines.sort(Comparator.comparingDouble(ObjectDoublePair::rightDouble));
        while (result.size() < 5 && !allLines.isEmpty()) {
            Beam solution = (Beam)((ObjectDoublePair)allLines.getFirst()).left();
            result.add(solution);
            allLines.removeFirst();
            allLines.removeIf(beam -> solution.containsComponentOf((Beam)beam.left()));
        }
        if (result.size() < 5) {
            LOGGER.error("Not enough solutions found. This is bad...");
        }
        return result;
    }

    @Override
    public void extractRendering(PrimitiveCollector collector) {
        if (!this.shouldSolve() || !SkyblockerConfigManager.get().dungeons.puzzleSolvers.creeperSolver) {
            return;
        }
        for (int i = 0; i < beams.size(); ++i) {
            beams.get(i).extractRendering(collector, COLORS[i]);
        }
    }

    private static boolean isTarget(class_638 world, class_2338 pos) {
        class_2248 block = world.method_8320(pos).method_26204();
        return block == class_2246.field_10174 || block == class_2246.field_10135;
    }

    private static class Beam {
        private final class_2338 blockOne;
        private final class_2338 blockTwo;
        private final class_243[] line = new class_243[2];
        private final class_238 outlineOne;
        private final class_238 outlineTwo;
        private boolean toDo = true;

        private Beam(class_2338 a, class_2338 b) {
            this.blockOne = a;
            this.blockTwo = b;
            this.line[0] = new class_243((double)a.method_10263() + 0.5, (double)a.method_10264() + 0.5, (double)a.method_10260() + 0.5);
            this.line[1] = new class_243((double)b.method_10263() + 0.5, (double)b.method_10264() + 0.5, (double)b.method_10260() + 0.5);
            this.outlineOne = new class_238(a);
            this.outlineTwo = new class_238(b);
        }

        private boolean containsComponentOf(Beam other) {
            return this.blockOne.equals((Object)other.blockOne) || this.blockOne.equals((Object)other.blockTwo) || this.blockTwo.equals((Object)other.blockOne) || this.blockTwo.equals((Object)other.blockTwo);
        }

        private void updateState(class_638 world) {
            this.toDo = world.method_8320(this.blockOne).method_26204() != class_2246.field_10135 || world.method_8320(this.blockTwo).method_26204() != class_2246.field_10135;
        }

        private void extractRendering(PrimitiveCollector collector, float[] color) {
            if (this.toDo) {
                collector.submitOutlinedBox(this.outlineOne, color, 3.0f, false);
                collector.submitOutlinedBox(this.outlineTwo, color, 3.0f, false);
                collector.submitLinesFromPoints(this.line, color, 1.0f, 2.0f, false);
            } else {
                collector.submitOutlinedBox(this.outlineOne, GREEN_COLOR_COMPONENTS, 1.0f, false);
                collector.submitOutlinedBox(this.outlineTwo, GREEN_COLOR_COMPONENTS, 1.0f, false);
                collector.submitLinesFromPoints(this.line, GREEN_COLOR_COMPONENTS, 0.75f, 1.0f, false);
            }
        }
    }
}

