/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon.puzzle;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.dungeon.puzzle.DungeonPuzzle;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveCollector;
import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_1301;
import net.minecraft.class_1531;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DungeonBlaze
extends DungeonPuzzle {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)DungeonBlaze.class.getName());
    private static final float[] GREEN_COLOR_COMPONENTS = new float[]{0.0f, 1.0f, 0.0f};
    private static final float[] WHITE_COLOR_COMPONENTS = new float[]{1.0f, 1.0f, 1.0f};
    private static final DungeonBlaze INSTANCE = new DungeonBlaze();
    private static @Nullable class_1531 highestBlaze = null;
    private static @Nullable class_1531 lowestBlaze = null;
    private static @Nullable class_1531 nextHighestBlaze = null;
    private static @Nullable class_1531 nextLowestBlaze = null;

    private DungeonBlaze() {
        super("blaze", "blaze-room-1-high", "blaze-room-1-low");
    }

    @Init
    public static void init() {
    }

    @Override
    public void tick(class_310 client) {
        if (!this.shouldSolve()) {
            return;
        }
        if (client.field_1687 == null || client.field_1724 == null || !Utils.isInDungeons()) {
            return;
        }
        List<ObjectIntPair<class_1531>> blazes = DungeonBlaze.getBlazesInWorld(client.field_1687, client.field_1724);
        DungeonBlaze.sortBlazes(blazes);
        DungeonBlaze.updateBlazeEntities(blazes);
    }

    private static List<ObjectIntPair<class_1531>> getBlazesInWorld(class_638 world, class_746 player) {
        ArrayList<ObjectIntPair<class_1531>> blazes = new ArrayList<ObjectIntPair<class_1531>>();
        for (class_1531 blaze : world.method_8390(class_1531.class, player.method_5829().method_1014(500.0), class_1301.field_6153)) {
            String blazeName = blaze.method_5477().getString();
            if (!blazeName.contains("Blaze") || !blazeName.contains("/")) continue;
            try {
                int health = Integer.parseInt(blazeName.substring(blazeName.indexOf("/") + 1, blazeName.length() - 1).replaceAll(",", ""));
                blazes.add((ObjectIntPair<class_1531>)ObjectIntPair.of((Object)blaze, (int)health));
            }
            catch (NumberFormatException e) {
                DungeonBlaze.handleException(e);
            }
        }
        return blazes;
    }

    private static void sortBlazes(List<ObjectIntPair<class_1531>> blazes) {
        blazes.sort(Comparator.comparingInt(ObjectIntPair::rightInt));
    }

    private static void updateBlazeEntities(List<ObjectIntPair<class_1531>> blazes) {
        if (!blazes.isEmpty()) {
            lowestBlaze = (class_1531)blazes.getFirst().left();
            int highestIndex = blazes.size() - 1;
            highestBlaze = (class_1531)blazes.get(highestIndex).left();
            if (blazes.size() > 1) {
                nextLowestBlaze = (class_1531)blazes.get(1).left();
                nextHighestBlaze = (class_1531)blazes.get(highestIndex - 1).left();
            }
        }
    }

    @Override
    public void extractRendering(PrimitiveCollector collector) {
        try {
            if (highestBlaze != null && lowestBlaze != null && highestBlaze.method_5805() && lowestBlaze.method_5805() && SkyblockerConfigManager.get().dungeons.puzzleSolvers.blazeSolver) {
                if (highestBlaze.method_23318() < 69.0) {
                    DungeonBlaze.extractBlazeOutline(highestBlaze, nextHighestBlaze, collector);
                }
                if (lowestBlaze.method_23318() > 69.0) {
                    DungeonBlaze.extractBlazeOutline(lowestBlaze, nextLowestBlaze, collector);
                }
            }
        }
        catch (Exception e) {
            DungeonBlaze.handleException(e);
        }
    }

    private static void extractBlazeOutline(class_1531 blaze, @Nullable class_1531 nextBlaze, PrimitiveCollector collector) {
        class_238 blazeBox = blaze.method_5829().method_1009(0.3, 0.9, 0.3).method_989(0.0, -1.1, 0.0);
        collector.submitOutlinedBox(blazeBox, GREEN_COLOR_COMPONENTS, 5.0f, false);
        if (nextBlaze != null && nextBlaze.method_5805() && nextBlaze != blaze) {
            class_238 nextBlazeBox = nextBlaze.method_5829().method_1009(0.3, 0.9, 0.3).method_989(0.0, -1.1, 0.0);
            collector.submitOutlinedBox(nextBlazeBox, WHITE_COLOR_COMPONENTS, 5.0f, false);
            class_243 blazeCenter = blazeBox.method_1005();
            class_243 nextBlazeCenter = nextBlazeBox.method_1005();
            collector.submitLinesFromPoints(new class_243[]{blazeCenter, nextBlazeCenter}, WHITE_COLOR_COMPONENTS, 1.0f, 5.0f, false);
        }
    }

    private static void handleException(Exception e) {
        LOGGER.error("[Skyblocker BlazeRenderer] Encountered an unknown exception", (Throwable)e);
    }
}

