/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon.puzzle;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.hysky.skyblocker.events.DungeonEvents;
import de.hysky.skyblocker.skyblock.dungeon.secrets.DungeonManager;
import de.hysky.skyblocker.skyblock.dungeon.secrets.Room;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.Resettable;
import de.hysky.skyblocker.utils.Tickable;
import de.hysky.skyblocker.utils.render.Renderable;
import java.util.Set;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_2561;

public abstract class DungeonPuzzle
implements Tickable,
Renderable,
Resettable {
    protected final String puzzleName;
    private final Set<String> roomNames;
    private boolean shouldSolve;

    public DungeonPuzzle(String puzzleName, String ... roomName) {
        this(puzzleName, Set.of(roomName));
    }

    public DungeonPuzzle(String puzzleName, Set<String> roomNames) {
        this.puzzleName = puzzleName;
        this.roomNames = roomNames;
        DungeonEvents.PUZZLE_MATCHED.register(room -> {
            if (this.roomNames.contains(room.getName())) {
                room.addSubProcess(this);
                this.shouldSolve = true;
            }
        });
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"skyblocker").then(ClientCommandManager.literal((String)"dungeons").then(ClientCommandManager.literal((String)"puzzle").then(ClientCommandManager.literal((String)puzzleName).then(ClientCommandManager.literal((String)"solve").executes(context -> {
            Room currentRoom = DungeonManager.getCurrentRoom();
            if (currentRoom != null) {
                this.reset();
                currentRoom.addSubProcess(this);
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)Constants.PREFIX.get().method_27693("\u00a7aSolving " + puzzleName + " puzzle in the current room."));
            } else {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)Constants.PREFIX.get().method_27693("\u00a7cCurrent room is null."));
            }
            return 1;
        })))))));
        ClientPlayConnectionEvents.JOIN.register((Object)this);
    }

    public boolean shouldSolve() {
        return this.shouldSolve;
    }

    @Override
    public void reset() {
        this.shouldSolve = false;
    }
}

