/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon.puzzle;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.dungeon.puzzle.DungeonPuzzle;
import de.hysky.skyblocker.skyblock.dungeon.secrets.DungeonManager;
import de.hysky.skyblocker.skyblock.dungeon.secrets.Room;
import de.hysky.skyblocker.utils.render.RenderHelper;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveCollector;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1531;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_638;
import org.jspecify.annotations.Nullable;

public class ThreeWeirdos
extends DungeonPuzzle {
    private static final ThreeWeirdos INSTANCE = new ThreeWeirdos();
    protected static final Pattern PATTERN = Pattern.compile("^\\[NPC] ([A-Z][a-z]+): (?:The reward is(?: not in my chest!|n't in any of our chests\\.)|My chest (?:doesn't have the reward\\. We are all telling the truth\\.|has the reward and I'm telling the truth!)|At least one of them is lying, and the reward is not in [A-Z][a-z]+'s chest!|Both of them are telling the truth\\. Also, [A-Z][a-z]+ has the reward in their chest!)$");
    private static final float[] GREEN_COLOR_COMPONENTS = new float[]{0.0f, 1.0f, 0.0f};
    private static @Nullable class_2338 pos;
    static @Nullable class_238 boundingBox;

    private ThreeWeirdos() {
        super("three-weirdos", "three-chests");
        ClientReceiveMessageEvents.ALLOW_GAME.register((message, overlay) -> {
            class_638 world = class_310.method_1551().field_1687;
            if (overlay || !this.shouldSolve() || !SkyblockerConfigManager.get().dungeons.puzzleSolvers.solveThreeWeirdos || world == null || !DungeonManager.isCurrentRoomMatched()) {
                return true;
            }
            Matcher matcher = PATTERN.matcher(class_124.method_539((String)message.getString()));
            if (!matcher.matches()) {
                return true;
            }
            String name = matcher.group(1);
            Room room = DungeonManager.getCurrentRoom();
            if (room == null || !room.isMatched()) {
                return true;
            }
            this.checkForNPC(world, room, new class_2338(13, 69, 24), name);
            this.checkForNPC(world, room, new class_2338(15, 69, 25), name);
            this.checkForNPC(world, room, new class_2338(17, 69, 24), name);
            return true;
        });
        UseBlockCallback.EVENT.register((player, world, hand, blockHitResult) -> {
            if (blockHitResult.method_17783() == class_239.class_240.field_1332 && blockHitResult.method_17777().equals((Object)pos)) {
                pos = null;
            }
            return class_1269.field_5811;
        });
    }

    @Init
    public static void init() {
    }

    private void checkForNPC(class_638 world, Room room, class_2338 relative, String name) {
        class_2338 npcPos = room.relativeToActual(relative);
        List npcs = world.method_8390(class_1531.class, class_238.method_54784((class_2338)npcPos, (class_2338)npcPos), entity -> entity.method_5477().getString().equals(name));
        if (!npcs.isEmpty()) {
            pos = room.relativeToActual(relative.method_10069(1, 0, 0));
            boundingBox = RenderHelper.getBlockBoundingBox(world, pos);
            npcs.forEach(entity -> entity.skyblocker$setCustomName((class_2561)class_2561.method_43470((String)name).method_27692(class_124.field_1060)));
        }
    }

    @Override
    public void tick(class_310 client) {
    }

    @Override
    public void extractRendering(PrimitiveCollector collector) {
        if (this.shouldSolve() && boundingBox != null) {
            collector.submitFilledBox(boundingBox, GREEN_COLOR_COMPONENTS, 0.5f, false);
        }
    }

    @Override
    public void reset() {
        super.reset();
        pos = null;
    }
}

