/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon.puzzle.waterboard;

import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.skyblock.dungeon.puzzle.DungeonPuzzle;
import de.hysky.skyblocker.skyblock.dungeon.puzzle.waterboard.Waterboard;
import de.hysky.skyblocker.skyblock.dungeon.secrets.DungeonManager;
import de.hysky.skyblocker.skyblock.dungeon.secrets.Room;
import de.hysky.skyblocker.utils.ColorUtils;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveCollector;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_638;
import net.minecraft.class_746;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaterboardPreviewer
extends DungeonPuzzle {
    private static final Logger LOGGER = LoggerFactory.getLogger(WaterboardPreviewer.class);
    public static final WaterboardPreviewer INSTANCE = new WaterboardPreviewer();
    private Waterboard.LeverType prospective;
    private class_638 world;
    private Room room;
    private class_746 player;

    private WaterboardPreviewer() {
        super("waterboard", "water-puzzle");
    }

    @Init
    public static void init() {
    }

    @Override
    public void tick(class_310 client) {
    }

    @Override
    public void extractRendering(PrimitiveCollector collector) {
        if (!this.shouldSolve() || class_310.method_1551().field_1687 == null || class_310.method_1551().field_1724 == null || !DungeonManager.isCurrentRoomMatched()) {
            return;
        }
        this.world = class_310.method_1551().field_1687;
        this.room = DungeonManager.getCurrentRoom();
        this.player = class_310.method_1551().field_1724;
        try {
            this.findProspective();
            this.extractWaterPath(collector);
            this.extractProspectiveChanges(collector);
        }
        catch (Exception e) {
            LOGGER.error("[Skyblocker Waterboard] Error while rendering previews", (Throwable)e);
        }
    }

    private void extractWaterPath(PrimitiveCollector collector) {
        if (!SkyblockerConfigManager.get().dungeons.puzzleSolvers.previewWaterPath) {
            return;
        }
        ArrayList<class_3545<class_2338, class_2338>> waterPath = new ArrayList<class_3545<class_2338, class_2338>>();
        waterPath.add(new class_3545((Object)Waterboard.WATER_ENTRANCE_POSITION.method_10086(5), (Object)Waterboard.WATER_ENTRANCE_POSITION.method_10086(3)));
        this.findWaterPathVertical(Waterboard.WATER_ENTRANCE_POSITION.method_10086(3), waterPath);
        for (class_3545 class_35452 : waterPath) {
            class_243 head = this.room.relativeToActual((class_2338)class_35452.method_15442()).method_46558();
            class_243 tail = this.room.relativeToActual((class_2338)class_35452.method_15441()).method_46558();
            ArrayList<class_243[]> lines = new ArrayList<class_243[]>();
            if (this.prospective == null) {
                lines.add(new class_243[]{head, tail});
            } else {
                class_243 forward = tail.method_1020(head).method_1029();
                double distance = head.method_1022(tail);
                int i = 0;
                while ((double)i < distance) {
                    lines.add(new class_243[]{head, head.method_1019(forward.method_1021(0.3))});
                    lines.add(new class_243[]{head.method_1019(forward.method_1021(0.7)), head.method_1019(forward)});
                    head = head.method_1019(forward);
                    ++i;
                }
            }
            for (class_243[] line : lines) {
                collector.submitLinesFromPoints(line, ColorUtils.getFloatComponents(Waterboard.LeverType.WATER.color), 1.0f, 3.0f, true);
            }
        }
    }

    private void findWaterPathVertical(class_2338 root, List<class_3545<class_2338, class_2338>> waterPath) {
        if (this.isWaterPassable(root.method_10074())) {
            class_2338.class_2339 tail = new class_2338.class_2339().method_10101((class_2382)root.method_10074());
            while (this.isWaterPassable(tail.method_10074())) {
                tail.method_10098(class_2350.field_11033);
            }
            waterPath.add((class_3545<class_2338, class_2338>)new class_3545((Object)root, (Object)new class_2338((class_2382)tail)));
            this.findWaterPathHorizontal((class_2338)tail, waterPath);
        }
    }

    private void findWaterPathHorizontal(class_2338 root, List<class_3545<class_2338, class_2338>> waterPath) {
        if (!this.isWaterPassable(root.method_10074())) {
            int rightSteps;
            int leftSteps;
            class_2338.class_2339 left = new class_2338.class_2339().method_10101((class_2382)root);
            for (leftSteps = 0; this.isWaterPassable(left.method_10078()) && !this.isWaterPassable(left.method_10074()) && leftSteps < 7; ++leftSteps) {
                left.method_10098(class_2350.field_11034);
            }
            class_2338.class_2339 right = new class_2338.class_2339().method_10101((class_2382)root);
            for (rightSteps = 0; this.isWaterPassable(right.method_10067()) && !this.isWaterPassable(right.method_10074()) && rightSteps < 7; ++rightSteps) {
                right.method_10098(class_2350.field_11039);
            }
            if (this.isWaterPassable(left.method_10074()) && leftSteps <= 5 && (leftSteps < rightSteps || !this.isWaterPassable(right.method_10074()))) {
                waterPath.add((class_3545<class_2338, class_2338>)new class_3545((Object)root, (Object)new class_2338((class_2382)left)));
                this.findWaterPathVertical((class_2338)left, waterPath);
            } else if (this.isWaterPassable(right.method_10074()) && rightSteps <= 5 && (rightSteps < leftSteps || !this.isWaterPassable(left.method_10074()))) {
                waterPath.add((class_3545<class_2338, class_2338>)new class_3545((Object)root, (Object)new class_2338((class_2382)right)));
                this.findWaterPathVertical((class_2338)right, waterPath);
            } else {
                if (leftSteps > 0) {
                    waterPath.add((class_3545<class_2338, class_2338>)new class_3545((Object)root, (Object)new class_2338((class_2382)left)));
                    this.findWaterPathVertical((class_2338)left, waterPath);
                }
                if (rightSteps > 0) {
                    waterPath.add((class_3545<class_2338, class_2338>)new class_3545((Object)root, (Object)new class_2338((class_2382)right)));
                    this.findWaterPathVertical((class_2338)right, waterPath);
                }
            }
        }
    }

    private boolean isWaterPassable(class_2338 pos) {
        boolean open;
        if (pos.method_10263() < 6 || pos.method_10263() > 24 || pos.method_10264() < 58 || pos.method_10264() > 81 || pos.method_10260() != 26) {
            return false;
        }
        class_2680 state = this.world.method_8320(this.room.relativeToActual(pos));
        class_2680 behindState = this.world.method_8320(this.room.relativeToActual(pos.method_10093(class_2350.field_11035)));
        boolean bl = open = state.method_26215() || state.method_27852(class_2246.field_10382);
        if (this.prospective == null) {
            return open;
        }
        return open && !behindState.method_27852(this.prospective.block) || state.method_27852(this.prospective.block);
    }

    private void findProspective() {
        if (!SkyblockerConfigManager.get().dungeons.puzzleSolvers.previewLeverEffects) {
            return;
        }
        class_243 camera = this.room.actualToRelative(this.player.method_33571());
        class_243 look = this.room.actualToRelative(this.player.method_33571().method_1019(this.player.method_5720())).method_1020(camera);
        double t1 = (24.5 - camera.method_10215()) / look.method_10215();
        double t2 = (27.5 - camera.method_10215()) / look.method_10215();
        class_243 start = camera.method_1019(look.method_1021(t1));
        class_243 end = camera.method_1019(look.method_1021(t2));
        class_2350 behind = switch (this.room.getDirection()) {
            default -> throw new MatchException(null, null);
            case Room.Direction.NW -> class_2350.field_11035;
            case Room.Direction.NE -> class_2350.field_11039;
            case Room.Direction.SW -> class_2350.field_11034;
            case Room.Direction.SE -> class_2350.field_11043;
        };
        this.prospective = (Waterboard.LeverType)((Object)class_1922.method_17744((class_243)this.room.relativeToActual(start), (class_243)this.room.relativeToActual(end), null, (ctx, pos) -> {
            if (this.room.actualToRelative((class_2338)pos).method_10260() != 26) {
                return null;
            }
            Waterboard.LeverType leverType = Waterboard.LeverType.fromBlock(this.world.method_8320(pos).method_26204());
            if (leverType == null) {
                class_2338 alternatePos = pos.method_10093(behind);
                leverType = Waterboard.LeverType.fromBlock(this.world.method_8320(alternatePos).method_26204());
            }
            return leverType;
        }, ctx -> null));
    }

    private void extractProspectiveChanges(PrimitiveCollector collector) {
        if (!SkyblockerConfigManager.get().dungeons.puzzleSolvers.previewLeverEffects || this.prospective == null) {
            return;
        }
        for (int x = 6; x <= 24; ++x) {
            for (int y = 58; y <= 81; ++y) {
                class_2338 activePos = this.room.relativeToActual(new class_2338(x, y, 26));
                class_2338 inactivePos = this.room.relativeToActual(new class_2338(x, y, 27));
                if (this.world.method_8320(activePos).method_27852(this.prospective.block)) {
                    collector.submitOutlinedBox(activePos, ColorUtils.getFloatComponents(this.prospective.color), 2.0f, true);
                    continue;
                }
                if (!this.world.method_8320(inactivePos).method_27852(this.prospective.block)) continue;
                collector.submitFilledBox(activePos, ColorUtils.getFloatComponents(this.prospective.color), 0.8f, true);
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.world = null;
        this.room = null;
        this.player = null;
        this.prospective = null;
    }
}

