/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon.secrets;

import com.mojang.serialization.Dynamic;
import de.hysky.skyblocker.annotations.Init;
import de.hysky.skyblocker.events.DungeonEvents;
import de.hysky.skyblocker.skyblock.dungeon.secrets.SecretSync;
import de.hysky.skyblocker.utils.render.RenderHelper;
import de.hysky.skyblocker.utils.ws.Service;
import de.hysky.skyblocker.utils.ws.Type;
import de.hysky.skyblocker.utils.ws.WsStateManager;
import de.hysky.skyblocker.utils.ws.message.DungeonMimicKilledMessage;
import de.hysky.skyblocker.utils.ws.message.DungeonPrinceKilledMessage;
import de.hysky.skyblocker.utils.ws.message.DungeonRoomHideWaypointMessage;
import de.hysky.skyblocker.utils.ws.message.DungeonRoomMatchMessage;
import de.hysky.skyblocker.utils.ws.message.DungeonRoomSecretCountMessage;
import java.util.Optional;

public class DungeonWebSocket {
    @Init
    public static void init() {
        DungeonEvents.DUNGEON_STARTED.register(DungeonWebSocket::connect);
    }

    private static void connect() {
        WsStateManager.subscribeServer(Service.DUNGEON_SECRETS, Optional.empty());
    }

    public static void handleMessage(Type type, Optional<Dynamic<?>> rawMsg) {
        if (rawMsg.isEmpty()) {
            return;
        }
        Dynamic<?> message = rawMsg.get();
        if (type == Type.RESPONSE) {
            String messageType;
            if (message.get("type").asString().isError()) {
                return;
            }
            switch (messageType = (String)message.get("type").asString().getOrThrow()) {
                case "room_match": {
                    RenderHelper.runOnRenderThread(() -> SecretSync.handleRoomMatch((DungeonRoomMatchMessage)DungeonRoomMatchMessage.CODEC.parse(message).getOrThrow()));
                    break;
                }
                case "room_secret_count": {
                    RenderHelper.runOnRenderThread(() -> SecretSync.handleSecretCountUpdate((DungeonRoomSecretCountMessage)DungeonRoomSecretCountMessage.CODEC.parse(message).getOrThrow()));
                    break;
                }
                case "room_hide_waypoint": {
                    RenderHelper.runOnRenderThread(() -> SecretSync.handleHideWaypoint((DungeonRoomHideWaypointMessage)DungeonRoomHideWaypointMessage.CODEC.parse(message).getOrThrow()));
                    break;
                }
                case "mimic_killed": {
                    RenderHelper.runOnRenderThread(() -> SecretSync.handleMimicKilled((DungeonMimicKilledMessage)DungeonMimicKilledMessage.CODEC.parse(message).getOrThrow()));
                    break;
                }
                case "prince_killed": {
                    RenderHelper.runOnRenderThread(() -> SecretSync.handlePrinceKilled((DungeonPrinceKilledMessage)DungeonPrinceKilledMessage.CODEC.parse(message).getOrThrow()));
                }
            }
        }
    }
}

