/*
 * Decompiled with CFR 0.152.
 */
package de.hysky.skyblocker.skyblock.dungeon.secrets;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.serialization.Codec;
import de.hysky.skyblocker.config.SkyblockerConfigManager;
import de.hysky.skyblocker.events.DungeonEvents;
import de.hysky.skyblocker.skyblock.dungeon.secrets.DungeonManager;
import de.hysky.skyblocker.skyblock.dungeon.secrets.DungeonMapUtils;
import de.hysky.skyblocker.skyblock.dungeon.secrets.SecretWaypoint;
import de.hysky.skyblocker.utils.Constants;
import de.hysky.skyblocker.utils.Tickable;
import de.hysky.skyblocker.utils.Utils;
import de.hysky.skyblocker.utils.render.RenderHelper;
import de.hysky.skyblocker.utils.render.Renderable;
import de.hysky.skyblocker.utils.render.primitive.PrimitiveCollector;
import de.hysky.skyblocker.utils.scheduler.Scheduler;
import de.hysky.skyblocker.utils.waypoint.Waypoint;
import it.unimi.dsi.fastutil.ints.IntRBTreeSet;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import it.unimi.dsi.fastutil.ints.IntSortedSets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1297;
import net.minecraft.class_1421;
import net.minecraft.class_1542;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3542;
import net.minecraft.class_3620;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_7485;
import net.minecraft.class_7923;
import org.apache.commons.lang3.tuple.MutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.joml.Vector2i;
import org.joml.Vector2ic;
import org.jspecify.annotations.Nullable;

public class Room
implements Tickable,
Renderable {
    public static final Pattern SECRET_INDEX = Pattern.compile("^(\\d+)");
    private static final Pattern SECRETS = Pattern.compile("\u00a77(\\d{1,2})/(\\d{1,2}) Secrets");
    private static final String CHEST_ALREADY_OPENED = "This chest has already been searched!";
    protected static final float[] RED_COLOR_COMPONENTS = new float[]{1.0f, 0.0f, 0.0f};
    protected static final float[] GREEN_COLOR_COMPONENTS = new float[]{0.0f, 1.0f, 0.0f};
    private final Type type;
    final Set<Vector2ic> segments;
    public ClearState clearState = ClearState.UNCLEARED;
    private int maxSecrets = -1;
    protected int secretsFound = 0;
    public boolean secretCountOutdated = true;
    private final Shape shape;
    protected @Nullable Map<String, int[]> roomsData;
    protected @Nullable List<MutableTriple<Direction, Vector2ic, List<String>>> possibleRooms;
    private @Nullable Set<class_2338> checkedBlocks = new HashSet<class_2338>();
    protected @Nullable CompletableFuture<Void> findRoom;
    private int doubleCheckBlocks;
    protected MatchState matchState = MatchState.MATCHING;
    protected Table<Integer, class_2338, SecretWaypoint> secretWaypoints = HashBasedTable.create();
    protected @Nullable String name;
    protected @Nullable Direction direction;
    protected @Nullable Vector2ic physicalCornerPos;
    protected List<Tickable> tickables = new ArrayList<Tickable>();
    protected List<Renderable> renderables = new ArrayList<Renderable>();
    private @Nullable class_2338 lastChestSecret;
    private long lastChestSecretTime;
    boolean fromWebsocket = false;

    public Room(Type type, Vector2ic ... physicalPositions) {
        this.type = type;
        this.segments = Set.of(physicalPositions);
        IntSortedSet segmentsX = IntSortedSets.unmodifiable((IntSortedSet)new IntRBTreeSet(this.segments.stream().mapToInt(Vector2ic::x).toArray()));
        IntSortedSet segmentsY = IntSortedSets.unmodifiable((IntSortedSet)new IntRBTreeSet(this.segments.stream().mapToInt(Vector2ic::y).toArray()));
        this.shape = this.determineShape(segmentsX, segmentsY);
        this.roomsData = DungeonManager.ROOMS_DATA.getOrDefault("catacombs", Collections.emptyMap()).getOrDefault(this.shape.shape.toLowerCase(Locale.ENGLISH), Collections.emptyMap());
        this.possibleRooms = this.getPossibleRooms(segmentsX, segmentsY);
    }

    Room(Type type, Shape shape, Direction direction, String roomName, Set<Vector2ic> segments, IntSortedSet segmentsX, IntSortedSet segmentsY) {
        this.fromWebsocket = true;
        this.type = type;
        this.shape = shape;
        this.segments = segments;
        this.name = roomName;
        this.direction = direction;
        this.physicalCornerPos = DungeonMapUtils.getPhysicalCornerPos(direction, segmentsX, segmentsY);
        this.roomsData = DungeonManager.ROOMS_DATA.getOrDefault("catacombs", Collections.emptyMap()).getOrDefault(shape.shape.toLowerCase(Locale.ENGLISH), Collections.emptyMap());
        this.roomMatched();
        this.matchState = MatchState.MATCHED;
        ((DungeonEvents.RoomMatched)DungeonEvents.ROOM_MATCHED.invoker()).onRoomMatched(this);
        this.discard();
    }

    public Type getType() {
        return this.type;
    }

    public Set<Vector2ic> getSegments() {
        return this.segments;
    }

    public Shape getShape() {
        return this.shape;
    }

    public @Nullable Vector2ic getPhysicalCornerPos() {
        return this.physicalCornerPos;
    }

    public boolean isMatched() {
        return this.matchState == MatchState.DOUBLE_CHECKING || this.matchState == MatchState.MATCHED;
    }

    public @Nullable String getName() {
        return this.name;
    }

    public @Nullable Direction getDirection() {
        return this.direction;
    }

    public String toString() {
        return "Room{type=%s, segments=%s, shape=%s, matchState=%s, name=%s, direction=%s, physicalCornerPos=%s}".formatted(new Object[]{this.type, Arrays.toString(this.segments.toArray()), this.shape, this.matchState, this.name, this.direction, this.physicalCornerPos});
    }

    private Shape determineShape(IntSortedSet segmentsX, IntSortedSet segmentsY) {
        return Room.determineShape(this.type, this.segments, segmentsX, segmentsY);
    }

    protected static Shape determineShape(Type type, Set<Vector2ic> segments, IntSortedSet segmentsX, IntSortedSet segmentsY) {
        return switch (type.ordinal()) {
            case 2 -> Shape.PUZZLE;
            case 3 -> Shape.TRAP;
            case 4 -> Shape.MINIBOSS;
            default -> {
                switch (segments.size()) {
                    case 1: {
                        yield Shape.ONE_BY_ONE;
                    }
                    case 2: {
                        yield Shape.ONE_BY_TWO;
                    }
                    case 3: {
                        if (segmentsX.size() == 2 && segmentsY.size() == 2) {
                            yield Shape.L_SHAPE;
                        }
                        yield Shape.ONE_BY_THREE;
                    }
                    case 4: {
                        if (segmentsX.size() == 2 && segmentsY.size() == 2) {
                            yield Shape.TWO_BY_TWO;
                        }
                        yield Shape.ONE_BY_FOUR;
                    }
                }
                throw new IllegalArgumentException("There are no matching room shapes with this set of physical positions: " + Arrays.toString(segments.toArray()));
            }
        };
    }

    private List<MutableTriple<Direction, Vector2ic, List<String>>> getPossibleRooms(IntSortedSet segmentsX, IntSortedSet segmentsY) {
        if (this.roomsData == null) {
            return List.of();
        }
        ArrayList<String> possibleDirectionRooms = new ArrayList<String>(this.roomsData.keySet());
        ArrayList<MutableTriple<Direction, Vector2ic, List<String>>> possibleRooms = new ArrayList<MutableTriple<Direction, Vector2ic, List<String>>>();
        for (Direction direction : this.getPossibleDirections(segmentsX, segmentsY)) {
            possibleRooms.add((MutableTriple<Direction, Vector2ic, List<String>>)MutableTriple.of((Object)((Object)direction), (Object)DungeonMapUtils.getPhysicalCornerPos(direction, segmentsX, segmentsY), possibleDirectionRooms));
        }
        return possibleRooms;
    }

    protected Direction[] getPossibleDirections(IntSortedSet segmentsX, IntSortedSet segmentsY) {
        Direction[] directionArray;
        switch (this.shape.ordinal()) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                directionArray = Direction.values();
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                if (segmentsX.size() > 1 && segmentsY.size() == 1) {
                    Direction[] directionArray2 = new Direction[2];
                    directionArray2[0] = Direction.NW;
                    directionArray = directionArray2;
                    directionArray2[1] = Direction.SE;
                    break;
                }
                if (segmentsX.size() == 1 && segmentsY.size() > 1) {
                    Direction[] directionArray3 = new Direction[2];
                    directionArray3[0] = Direction.NE;
                    directionArray = directionArray3;
                    directionArray3[1] = Direction.SW;
                    break;
                }
                throw new IllegalArgumentException("Shape " + this.shape.shape + " does not match segments: " + Arrays.toString(this.segments.toArray()));
            }
            case 4: {
                if (!this.segments.contains(new Vector2i(segmentsX.firstInt(), segmentsY.firstInt()))) {
                    Direction[] directionArray4 = new Direction[1];
                    directionArray = directionArray4;
                    directionArray4[0] = Direction.SW;
                    break;
                }
                if (!this.segments.contains(new Vector2i(segmentsX.firstInt(), segmentsY.lastInt()))) {
                    Direction[] directionArray5 = new Direction[1];
                    directionArray = directionArray5;
                    directionArray5[0] = Direction.SE;
                    break;
                }
                if (!this.segments.contains(new Vector2i(segmentsX.lastInt(), segmentsY.firstInt()))) {
                    Direction[] directionArray6 = new Direction[1];
                    directionArray = directionArray6;
                    directionArray6[0] = Direction.NW;
                    break;
                }
                if (!this.segments.contains(new Vector2i(segmentsX.lastInt(), segmentsY.lastInt()))) {
                    Direction[] directionArray7 = new Direction[1];
                    directionArray = directionArray7;
                    directionArray7[0] = Direction.NE;
                    break;
                }
                throw new IllegalArgumentException("Shape " + this.shape.shape + " does not match segments: " + Arrays.toString(this.segments.toArray()));
            }
        }
        return directionArray;
    }

    protected void addCustomWaypoint(CommandContext<FabricClientCommandSource> context, class_2338 pos) {
        int secretIndex = IntegerArgumentType.getInteger(context, (String)"secretIndex");
        SecretWaypoint.Category category = SecretWaypoint.Category.CategoryArgumentType.getCategory(context, "category");
        class_2561 waypointName = (class_2561)context.getArgument("name", class_2561.class);
        this.addCustomWaypoint(secretIndex, category, waypointName, pos);
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_54159((String)"skyblocker.dungeons.secrets.customWaypointAdded", (Object[])new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260(), this.name, secretIndex, category, waypointName})));
    }

    private void addCustomWaypoint(int secretIndex, SecretWaypoint.Category category, class_2561 waypointName, class_2338 pos) {
        if (!this.isMatched()) {
            return;
        }
        SecretWaypoint waypoint = new SecretWaypoint(secretIndex, category, waypointName, pos);
        DungeonManager.addCustomWaypoint(this.name, waypoint);
        DungeonManager.getRoomsStream().filter(r -> this.name.equals(r.getName())).forEach(r -> r.addCustomWaypoint(waypoint));
    }

    private void addCustomWaypoint(SecretWaypoint relativeWaypoint) {
        SecretWaypoint actualWaypoint = relativeWaypoint.relativeToActual(this);
        this.secretWaypoints.put((Object)actualWaypoint.secretIndex, (Object)actualWaypoint.pos, (Object)actualWaypoint);
    }

    protected void removeCustomWaypoint(CommandContext<FabricClientCommandSource> context, class_2338 pos) {
        SecretWaypoint waypoint = this.removeCustomWaypoint(pos);
        if (waypoint != null) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43469((String)"skyblocker.dungeons.secrets.customWaypointRemoved", (Object[])new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260(), this.name, waypoint.secretIndex, waypoint.category.method_15434(), waypoint.getName()})));
        } else {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)Constants.PREFIX.get().method_10852((class_2561)class_2561.method_43469((String)"skyblocker.dungeons.secrets.customWaypointNotFound", (Object[])new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260(), this.name})));
        }
    }

    private @Nullable SecretWaypoint removeCustomWaypoint(class_2338 pos) {
        if (this.name == null) {
            return null;
        }
        SecretWaypoint waypoint = DungeonManager.removeCustomWaypoint(this.name, pos);
        if (waypoint != null) {
            DungeonManager.getRoomsStream().filter(r -> this.name.equals(r.getName())).forEach(r -> r.removeCustomWaypoint(waypoint.secretIndex, pos));
        }
        return waypoint;
    }

    private void removeCustomWaypoint(int secretIndex, class_2338 relativePos) {
        class_2338 actualPos = this.relativeToActual(relativePos);
        this.secretWaypoints.remove((Object)secretIndex, (Object)actualPos);
    }

    public <T extends Tickable & Renderable> void addSubProcess(T process) {
        this.tickables.add(process);
        this.renderables.add(process);
    }

    @Override
    public void tick(class_310 client) {
        if (client.field_1687 == null) {
            return;
        }
        for (Tickable tickable : this.tickables) {
            tickable.tick(client);
        }
        if (!this.type.needsScanning() || this.matchState != MatchState.MATCHING && this.matchState != MatchState.DOUBLE_CHECKING || !DungeonManager.isRoomsLoaded() || this.findRoom != null && !this.findRoom.isDone()) {
            return;
        }
        class_746 player = client.field_1724;
        if (player == null) {
            return;
        }
        this.findRoom = CompletableFuture.runAsync(() -> {
            for (class_2338 pos : class_2338.method_10097((class_2338)player.method_24515().method_10069(-5, -5, -5), (class_2338)player.method_24515().method_10069(5, 5, 5))) {
                assert (this.checkedBlocks != null);
                if (!this.segments.contains(DungeonMapUtils.getPhysicalRoomPos((class_2382)pos)) || !Room.notInDoorway(pos) || !this.checkedBlocks.add(pos) || !this.checkBlock(client.field_1687, pos)) continue;
                break;
            }
        }).exceptionally(e -> {
            DungeonManager.LOGGER.error("[Skyblocker Dungeon Secrets] Encountered an unknown exception while matching room {}", (Object)this, e);
            return null;
        });
    }

    private static boolean notInDoorway(class_2338 pos) {
        if (pos.method_10264() < 66 || pos.method_10264() > 73) {
            return true;
        }
        int x = Math.floorMod(pos.method_10263() - 8, 32);
        int z = Math.floorMod(pos.method_10260() - 8, 32);
        return (x < 13 || x > 17 || z > 2 && z < 28) && (z < 13 || z > 17 || x > 2 && x < 28);
    }

    protected boolean checkBlock(class_638 world, class_2338 pos) {
        byte id = DungeonManager.NUMERIC_ID.getByte((Object)class_7923.field_41175.method_10221((Object)world.method_8320(pos).method_26204()).toString());
        if (id == 0) {
            return false;
        }
        assert (this.possibleRooms != null);
        for (MutableTriple<Direction, Vector2ic, List<String>> directionRooms2 : this.possibleRooms) {
            int block = this.posIdToInt(DungeonMapUtils.actualToRelative((Direction)((Object)directionRooms2.getLeft()), (Vector2ic)directionRooms2.getMiddle(), pos), id);
            ArrayList<String> possibleDirectionRooms = new ArrayList<String>();
            for (String room : (List)directionRooms2.getRight()) {
                assert (this.roomsData != null);
                if (Arrays.binarySearch(this.roomsData.get(room), block) < 0) continue;
                possibleDirectionRooms.add(room);
            }
            directionRooms2.setRight(possibleDirectionRooms);
        }
        int matchingRoomsSize = this.possibleRooms.stream().map(Triple::getRight).mapToInt(Collection::size).sum();
        if (matchingRoomsSize == 0) {
            this.matchState = MatchState.FAILED;
            assert (this.checkedBlocks != null);
            DungeonManager.LOGGER.warn("[Skyblocker Dungeon Secrets] No dungeon room matched after checking {} block(s) including double checking {} block(s)", (Object)this.checkedBlocks.size(), (Object)this.doubleCheckBlocks);
            RenderHelper.runOnRenderThread(() -> {
                Scheduler.INSTANCE.schedule(() -> {
                    this.matchState = MatchState.MATCHING;
                }, 50);
                this.reset();
            });
            return true;
        }
        if (matchingRoomsSize == 1) {
            if (this.matchState == MatchState.MATCHING) {
                this.matchState = MatchState.DOUBLE_CHECKING;
                Triple directionRoom = (Triple)this.possibleRooms.stream().filter(directionRooms -> ((List)directionRooms.getRight()).size() == 1).findAny().orElseThrow();
                this.name = (String)((List)directionRoom.getRight()).getFirst();
                this.direction = (Direction)((Object)directionRoom.getLeft());
                this.physicalCornerPos = (Vector2ic)directionRoom.getMiddle();
                assert (this.checkedBlocks != null);
                DungeonManager.LOGGER.info("[Skyblocker Dungeon Secrets] Room {} matched after checking {} block(s), starting double checking", (Object)this.name, (Object)this.checkedBlocks.size());
                RenderHelper.runOnRenderThread(this::roomMatched);
                return false;
            }
            if (this.matchState == MatchState.DOUBLE_CHECKING && ++this.doubleCheckBlocks >= 10) {
                this.matchState = MatchState.MATCHED;
                assert (this.checkedBlocks != null);
                DungeonManager.LOGGER.info("[Skyblocker Dungeon Secrets] Room {} confirmed after checking {} block(s) including double checking {} block(s)", new Object[]{this.name, this.checkedBlocks.size(), this.doubleCheckBlocks});
                RenderHelper.runOnRenderThread(() -> {
                    ((DungeonEvents.RoomMatched)DungeonEvents.ROOM_MATCHED.invoker()).onRoomMatched(this);
                    this.discard();
                });
                return true;
            }
            return false;
        }
        assert (this.checkedBlocks != null);
        DungeonManager.LOGGER.debug("[Skyblocker Dungeon Secrets] {} room(s) remaining after checking {} block(s)", (Object)matchingRoomsSize, (Object)this.checkedBlocks.size());
        return false;
    }

    protected int posIdToInt(class_2338 pos, byte id) {
        return pos.method_10263() << 24 | pos.method_10264() << 16 | pos.method_10260() << 8 | id;
    }

    private void roomMatched() {
        String name = this.name;
        Direction direction = this.direction;
        Vector2ic physicalCornerPos = this.physicalCornerPos;
        if (name == null || direction == null || physicalCornerPos == null) {
            DungeonManager.LOGGER.warn("[Skyblocker Dungeon Secrets] Room matched called with invalid fields: matchState={}, name={}, direction={}, physicalCornerPos={}", new Object[]{this.matchState, name, direction, physicalCornerPos});
            return;
        }
        List<DungeonManager.RoomWaypoint> roomWaypoints = DungeonManager.getRoomWaypoints(name);
        if (roomWaypoints != null) {
            for (DungeonManager.RoomWaypoint waypoint : roomWaypoints) {
                String secretName = waypoint.secretName();
                Matcher secretIndexMatcher = SECRET_INDEX.matcher(secretName);
                int secretIndex = secretIndexMatcher.find() ? Integer.parseInt(secretIndexMatcher.group(1)) : 0;
                class_2338 pos = DungeonMapUtils.relativeToActual(direction, physicalCornerPos, waypoint);
                this.secretWaypoints.put((Object)secretIndex, (Object)pos, (Object)new SecretWaypoint(secretIndex, waypoint.category(), secretName, pos));
            }
        }
        DungeonManager.getCustomWaypoints(name).values().forEach(this::addCustomWaypoint);
        this.maxSecrets = Utils.parseInt(name.replaceAll("\\D", "")).orElse(-1);
    }

    protected void reset() {
        IntSortedSet segmentsX = IntSortedSets.unmodifiable((IntSortedSet)new IntRBTreeSet(this.segments.stream().mapToInt(Vector2ic::x).toArray()));
        IntSortedSet segmentsY = IntSortedSets.unmodifiable((IntSortedSet)new IntRBTreeSet(this.segments.stream().mapToInt(Vector2ic::y).toArray()));
        this.possibleRooms = this.getPossibleRooms(segmentsX, segmentsY);
        this.checkedBlocks = new HashSet<class_2338>();
        this.doubleCheckBlocks = 0;
        this.secretWaypoints.clear();
        this.name = null;
        this.direction = null;
        this.physicalCornerPos = null;
    }

    private void discard() {
        this.roomsData = null;
        this.possibleRooms = null;
        this.checkedBlocks = null;
        this.doubleCheckBlocks = 0;
    }

    public class_2338 actualToRelative(class_2338 pos) {
        assert (this.direction != null && this.physicalCornerPos != null);
        return DungeonMapUtils.actualToRelative(this.direction, this.physicalCornerPos, pos);
    }

    public class_243 actualToRelative(class_243 pos) {
        assert (this.direction != null && this.physicalCornerPos != null);
        return DungeonMapUtils.actualToRelative(this.direction, this.physicalCornerPos, pos);
    }

    public class_2338 relativeToActual(class_2338 pos) {
        assert (this.direction != null && this.physicalCornerPos != null);
        return DungeonMapUtils.relativeToActual(this.direction, this.physicalCornerPos, pos);
    }

    public class_243 relativeToActual(class_243 pos) {
        assert (this.direction != null && this.physicalCornerPos != null);
        return DungeonMapUtils.relativeToActual(this.direction, this.physicalCornerPos, pos);
    }

    @Override
    public void extractRendering(PrimitiveCollector collector) {
        for (Renderable renderable : this.renderables) {
            renderable.extractRendering(collector);
        }
        if (SkyblockerConfigManager.get().dungeons.secretWaypoints.enableSecretWaypoints && this.isMatched()) {
            for (SecretWaypoint secretWaypoint : this.secretWaypoints.values()) {
                if (!secretWaypoint.shouldRender()) continue;
                secretWaypoint.extractRendering(collector);
            }
        }
    }

    protected void onChatMessage(String message) {
        if (CHEST_ALREADY_OPENED.equals(message) && this.lastChestSecretTime + 1000L > System.currentTimeMillis() && this.lastChestSecret != null) {
            this.secretWaypoints.column((Object)this.lastChestSecret).values().stream().filter(SecretWaypoint::needsInteraction).findAny().ifPresent(secretWaypoint -> this.markSecretsFoundAndLogInfo((SecretWaypoint)secretWaypoint, "[Skyblocker Dungeon Secrets] Detected already searched chest interaction, setting secret #{} as found", secretWaypoint.secretIndex));
        }
        if (this.secretCountOutdated) {
            this.updateSecretCount(message);
        }
    }

    protected void updateSecretCount(String message) {
        Matcher matcher = SECRETS.matcher(message);
        if (!matcher.find()) {
            return;
        }
        this.secretsFound = Integer.parseInt(matcher.group(1));
        this.secretCountOutdated = false;
        ((DungeonEvents.SecretCountUpdate)DungeonEvents.SECRET_COUNT_UPDATED.invoker()).onSecretCountUpdate(this, false);
    }

    protected void onUseBlock(class_1937 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        if (state.method_27852(class_2246.field_10034) || state.method_27852(class_2246.field_10380)) {
            this.lastChestSecret = pos;
            this.lastChestSecretTime = System.currentTimeMillis();
            Scheduler.INSTANCE.schedule(() -> {
                if (!world.method_8320(pos).method_26215()) {
                    return;
                }
                this.secretWaypoints.column((Object)pos).values().stream().filter(SecretWaypoint::needsInteraction).filter(Waypoint::isEnabled).findAny().ifPresent(secretWaypoint -> this.markSecretsFoundAndLogInfo((SecretWaypoint)secretWaypoint, "[Skyblocker Dungeon Secrets] Detected chest block removed, setting secret #{} as found", secretWaypoint.secretIndex));
            }, 5);
        } else if (state.method_27852(class_2246.field_10432) || state.method_27852(class_2246.field_10208)) {
            this.secretWaypoints.column((Object)pos).values().stream().filter(SecretWaypoint::needsInteraction).filter(Waypoint::isEnabled).findAny().ifPresent(secretWaypoint -> {
                if (secretWaypoint.category == SecretWaypoint.Category.REDSTONE_KEY) {
                    DungeonManager.LOGGER.info("[Skyblocker Dungeon Secrets] Detected {} interaction, hiding secret #{} waypoint {}", new Object[]{secretWaypoint.category, secretWaypoint.secretIndex, secretWaypoint.name});
                    secretWaypoint.setFound();
                    return;
                }
                this.markSecretsFoundAndLogInfo((SecretWaypoint)secretWaypoint, "[Skyblocker Dungeon Secrets] Detected {} interaction, setting secret #{} as found", new Object[]{secretWaypoint.category, secretWaypoint.secretIndex});
            });
        } else if (state.method_27852(class_2246.field_10002)) {
            this.secretWaypoints.column((Object)pos.method_10084()).values().stream().filter(SecretWaypoint::needsInteraction).filter(Waypoint::isEnabled).findAny().ifPresent(secretWaypoint -> this.markSecretsFoundAndLogInfo((SecretWaypoint)secretWaypoint, "[Skyblocker Dungeon Secrets] Detected {} interaction, setting secret #{} as found", new Object[]{secretWaypoint.category, secretWaypoint.secretIndex}));
        } else if (state.method_27852(class_2246.field_10363)) {
            this.secretWaypoints.column((Object)pos).values().stream().filter(SecretWaypoint::isLever).forEach(Waypoint::setFound);
        }
    }

    protected void onChestOpened(class_2338 pos) {
        this.secretWaypoints.column((Object)pos).values().stream().filter(SecretWaypoint::needsInteraction).filter(Waypoint::isEnabled).findAny().ifPresent(secretWaypoint -> this.markSecretsFoundAndLogInfo((SecretWaypoint)secretWaypoint, "[Skyblocker Dungeon Secrets] Detected chest opened, setting secret #{} as found", secretWaypoint.secretIndex));
    }

    protected void onItemPickup(class_1542 itemEntity) {
        if (SecretWaypoint.SECRET_ITEMS.stream().noneMatch(itemEntity.method_6983().method_7964().getString()::contains)) {
            return;
        }
        this.secretWaypoints.values().stream().filter(SecretWaypoint::needsItemPickup).min(Comparator.comparingDouble(SecretWaypoint.getSquaredDistanceToFunction((class_1297)itemEntity))).filter(SecretWaypoint.getRangePredicate((class_1297)itemEntity)).ifPresent(secretWaypoint -> this.markSecretsFoundAndLogInfo((SecretWaypoint)secretWaypoint, "[Skyblocker Dungeon Secrets] Detected item {} removed from a {} secret, setting secret #{} as found", new Object[]{itemEntity.method_5477().getString(), secretWaypoint.category, secretWaypoint.secretIndex}));
    }

    protected void onBatRemoved(class_1421 bat) {
        this.secretWaypoints.values().stream().filter(SecretWaypoint::isBat).min(Comparator.comparingDouble(SecretWaypoint.getSquaredDistanceToFunction((class_1297)bat))).filter(SecretWaypoint.getRangePredicate((class_1297)bat)).ifPresent(secretWaypoint -> this.markSecretsFoundAndLogInfo((SecretWaypoint)secretWaypoint, "[Skyblocker Dungeon Secrets] Detected {} killed for a {} secret, setting secret #{} as found", new Object[]{bat.method_5477().getString(), secretWaypoint.category, secretWaypoint.secretIndex}));
    }

    private void markSecretsFoundAndLogInfo(SecretWaypoint secretWaypoint, String msg, Object ... args) {
        this.markSecretsAndLogInfo(secretWaypoint, true, msg, args);
    }

    private void markSecretsAndLogInfo(SecretWaypoint secretWaypoint, boolean found, String msg, Object ... args) {
        if (found) {
            ((DungeonEvents.SecretFound)DungeonEvents.SECRET_FOUND.invoker()).onSecretFound(this, secretWaypoint);
            this.secretCountOutdated = true;
        }
        this.markSecrets(secretWaypoint.secretIndex, found);
        DungeonManager.LOGGER.info(msg, args);
    }

    protected int getIndexByWaypointHash(int waypointHash) {
        for (int i = 0; i < this.getSecretCount(); ++i) {
            if (!this.secretWaypoints.containsRow((Object)i)) continue;
            for (SecretWaypoint waypoint : this.secretWaypoints.row((Object)i).values()) {
                if (!waypoint.isEnabled() || waypoint.hashCode() != waypointHash) continue;
                return i;
            }
        }
        return -1;
    }

    protected boolean markSecrets(int secretIndex, boolean found) {
        Map secret = this.secretWaypoints.row((Object)secretIndex);
        if (secret.isEmpty()) {
            return false;
        }
        secret.values().forEach(found ? Waypoint::setFound : Waypoint::setMissing);
        return true;
    }

    protected void markAllSecrets(boolean found) {
        this.secretWaypoints.values().forEach(found ? Waypoint::setFound : Waypoint::setMissing);
    }

    public int getMaxSecretCount() {
        return this.maxSecrets;
    }

    protected int getSecretCount() {
        return this.secretWaypoints.rowMap().size();
    }

    public int getFoundSecretCount() {
        return this.secretsFound;
    }

    public static enum ClearState {
        GREEN_CHECKED,
        WHITE_CHECKED,
        FAILED,
        UNCLEARED;

    }

    protected static enum MatchState {
        MATCHING,
        DOUBLE_CHECKING,
        MATCHED,
        FAILED;

    }

    public static enum Type implements class_3542
    {
        ENTRANCE(class_3620.field_16004.method_38481(class_3620.class_6594.field_34761), "Entrance"),
        ROOM(class_3620.field_15987.method_38481(class_3620.class_6594.field_34762), "Room"),
        PUZZLE(class_3620.field_15998.method_38481(class_3620.class_6594.field_34761), "Puzzle"),
        TRAP(class_3620.field_15987.method_38481(class_3620.class_6594.field_34761), "Trap"),
        MINIBOSS(class_3620.field_16010.method_38481(class_3620.class_6594.field_34761), "Miniboss"),
        FAIRY(class_3620.field_16030.method_38481(class_3620.class_6594.field_34761), "Fairy"),
        BLOOD(class_3620.field_16002.method_38481(class_3620.class_6594.field_34761), "Blood"),
        UNKNOWN(class_3620.field_15978.method_38481(class_3620.class_6594.field_34760), "Unknown");

        public final byte color;
        final String name;
        public static final Codec<Type> CODEC;

        private Type(byte color, String name) {
            this.color = color;
            this.name = name;
        }

        private boolean needsScanning() {
            return switch (this.ordinal()) {
                case 1, 2, 3, 4 -> true;
                default -> false;
            };
        }

        public String method_15434() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(Type::values);
        }
    }

    public static enum Shape implements class_3542
    {
        ONE_BY_ONE("1x1"),
        ONE_BY_TWO("1x2"),
        ONE_BY_THREE("1x3"),
        ONE_BY_FOUR("1x4"),
        L_SHAPE("L-shape"),
        TWO_BY_TWO("2x2"),
        PUZZLE("puzzle"),
        TRAP("trap"),
        MINIBOSS("miniboss");

        public static final Codec<Shape> CODEC;
        final String shape;

        private Shape(String shape) {
            this.shape = shape;
        }

        public String toString() {
            return this.shape;
        }

        public String method_15434() {
            return this.shape;
        }

        static {
            CODEC = class_3542.method_28140(Shape::values);
        }
    }

    public static enum Direction implements class_3542
    {
        NW("northwest"),
        NE("northeast"),
        SW("southwest"),
        SE("southeast");

        public static final Codec<Direction> CODEC;
        private final String name;

        private Direction(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        static {
            CODEC = class_3542.method_28140(Direction::values);
        }

        static class DirectionArgumentType
        extends class_7485<Direction> {
            DirectionArgumentType() {
                super(CODEC, Direction::values);
            }

            static DirectionArgumentType direction() {
                return new DirectionArgumentType();
            }

            static <S> Direction getDirection(CommandContext<S> context, String name) {
                return (Direction)((Object)context.getArgument(name, Direction.class));
            }
        }
    }
}

